<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Contact extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-contact';
	}

	public function get_title() {
		return esc_html__( 'Contact', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'text',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Contact Info', 'cassio' ) ),
					'editor_type' => 'AREA',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'icon',
			array(
				'label' => esc_html__( 'Icon', 'cassio' ),
				'type'  => Controls_Manager::ICON,
			)
		);

		$this->add_control(
			'text',
			array(
				'label' => esc_html__( 'Contact Info', 'cassio' ),
				'type'  => Controls_Manager::TEXTAREA,
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'text' );
		$this->add_render_attribute(
			'text',
			array(
				'class' => 'figure-contact__item',
			)
		);

		?>

		<div class="figure-contact">
			<?php if ( ! empty( $settings['icon'] ) ) : ?>
				<div class="figure-contact__icon <?php echo $settings['icon']; ?>"></div>
			<?php endif; ?>
			<?php if ( ! empty( $settings['text'] ) ) : ?>
				<div <?php $this->print_render_attribute_string( 'text' ); ?>><?php echo $settings['text']; ?></div>
			<?php endif; ?>
		</div>

		<?php
	}

	protected function content_template() {
		?>
		<#
			view.addInlineEditingAttributes( 'text' );
			view.addRenderAttribute('text', 'class', 'figure-contact__item');
		#>
		<div class="figure-contact">
			<# if (settings.icon) { #>
				<div class="figure-contact__icon {{{ settings.icon }}}"></div>
			<# } #>
			<# if (settings.text) { #>
				<div {{{ view.getRenderAttributeString( 'text' ) }}}>{{{ settings.text }}}</div>
			<# } #>
		</div>

		<?php
	}
}
