<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Feature extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-feature';
	}

	public function get_title() {
		return esc_html__( 'Feature', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'title',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Title', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'description',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Description', 'cassio' ) ),
					'editor_type' => 'AREA',
				),
				array(
					'field'       => 'link',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Link', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'icon',
			array(
				'label' => esc_html__( 'Icon', 'cassio' ),
				'type'  => Controls_Manager::ICON,
			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => esc_html__( 'Title', 'cassio' ),
				'label_block' => true,
				'default'     => esc_html__( 'Title...', 'cassio' ),
				'type'        => Controls_Manager::TEXT,
			)
		);

		$this->add_control(
			'description',
			array(
				'label'       => esc_html__( 'Description', 'cassio' ),
				'label_block' => true,
				'default'     => esc_html__( 'Description...', 'cassio' ),
				'type'        => Controls_Manager::TEXTAREA,
			)
		);

		$this->add_control(
			'link',
			array(
				'label'         => esc_html__( 'Link', 'cassio' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => 'https://...',
				'show_external' => true,
				'default'       => array(
					'is_external' => false,
					'nofollow'    => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => esc_html__( 'Typography', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'heading_tag',
			array(
				'label'   => esc_html__( 'Heading HTML Tag', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => array(
					'h2' => esc_html( '<h2>' ),
					'h3' => esc_html( '<h3>' ),
					'h4' => esc_html( '<h4>' ),
					'h5' => esc_html( '<h5>' ),
					'h6' => esc_html( '<h6>' ),
				),
			)
		);

		$this->add_control(
			'heading_size',
			array(
				'label'   => esc_html__( 'Heading Size', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h5',
				'options' => array(
					'h1'       => esc_html__( 'H1', 'cassio' ),
					'h2'       => esc_html__( 'H2', 'cassio' ),
					'h3'       => esc_html__( 'H3', 'cassio' ),
					'h4'       => esc_html__( 'H4', 'cassio' ),
					'h5'       => esc_html__( 'H5', 'cassio' ),
					'h6'       => esc_html__( 'H6', 'cassio' ),
					'text-xl'  => esc_html__( 'XL', 'cassio' ),
					'text-xxl' => esc_html__( 'XXL', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'heading_weight',
			array(
				'label'   => esc_html__( 'Heading Weight', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''              => esc_html__( 'Auto', 'cassio' ),
					'heading-light' => esc_html__( 'Normal', 'cassio' ),
					'heading-bold'  => esc_html__( 'Bold', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'icon' );
		$this->add_inline_editing_attributes( 'title' );
		$this->add_inline_editing_attributes( 'description' );

		$tag = 'div';

		$this->add_render_attribute(
			'item',
			array(
				'class' => 'figure-feature',
			)
		);

		$this->add_render_attribute(
			'title',
			array(
				'class' => array( 'figure-feature__heading', $settings['heading_size'], $settings['heading_weight'] ),
			)
		);

		if ( ! empty( $settings['link']['url'] ) ) {

			$tag = 'a';

			$this->add_render_attribute( 'item', 'href', $settings['link']['url'] );

			if ( $settings['link']['is_external'] ) {
				$this->add_render_attribute( 'item', 'target', '_blank' );
			}

			if ( $settings['link']['nofollow'] ) {
				$this->add_render_attribute( 'item', 'rel', 'nofollow' );
			}
		}

		?>

		<<?php echo $tag; ?> <?php $this->print_render_attribute_string( 'item' ); ?>>
			<div class="figure-feature__corner figure-feature__corner_top"></div>
			<div class="figure-feature__corner figure-feature__corner_bottom"></div>
			<?php if ( ! empty( $settings['icon'] ) ) : ?>
				<div class="figure-feature__icon <?php echo $settings['icon']; ?>"></div>
			<?php endif; ?>
			<?php if ( ! empty( $settings['title'] ) || ! empty( $settings['description'] ) ) : ?>
				<div class="figure-feature__header">
					<?php if ( ! empty( $settings['title'] ) ) : ?>
						<<?php echo $settings['heading_tag']; ?> <?php $this->print_render_attribute_string( 'title' ); ?>><?php echo $settings['title']; ?></<?php echo $settings['heading_tag']; ?>>
					<?php endif; ?>
					<?php if ( ! empty( $settings['description'] ) ) : ?>
						<p <?php $this->print_render_attribute_string( 'description' ); ?>><?php echo $settings['description']; ?></p>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</<?php echo $tag; ?>>

		<?php
	}

	protected function content_template() {
		?>
		<#

		view.addInlineEditingAttributes( 'icon' );
		view.addInlineEditingAttributes( 'title' );
		view.addInlineEditingAttributes( 'description' );

		var tag = 'div';

		view.addRenderAttribute( 'item', {
			'class': 'figure-feature'
		});
		view.addRenderAttribute( 'title', {
			'class': ['figure-feature__heading', settings.heading_size, settings.heading_weight]
		});

		if ( settings.link.url ) {

			tag = 'a';

			view.addRenderAttribute( 'item', 'href', settings.link.url );

			if ( settings.link.is_external ) {
				view.addRenderAttribute( 'item', 'target', '_blank' );
			}

			if ( settings.link.nofollow ) {
				view.addRenderAttribute( 'item', 'rel', 'nofollow' );
			}
		}
		#>

		<{{{ tag }}} {{{ view.getRenderAttributeString( 'item' ) }}}>
			<div class="figure-feature__corner figure-feature__corner_top"></div>
			<div class="figure-feature__corner figure-feature__corner_bottom"></div>
			<# if ( settings.icon ) { #>
				<div class="figure-feature__icon {{{ settings.icon }}}"></div>
			<# } #>
			<# if ( settings.title || settings.description ) { #>
				<div class="figure-feature__header">
					<# if ( settings.title ) { #>
						<{{{ settings.heading_tag }}} {{{ view.getRenderAttributeString( 'title' ) }}}>{{{ settings.title }}}</{{{ settings.heading_tag }}}>
					<# } #>
					<# if ( settings.description ) { #>
						<p {{{ view.getRenderAttributeString( 'description' ) }}}>{{{ settings.description }}}</p>
					<# } #>
				</div>
			<# } #>
		</{{{ tag }}}>

		<?php
	}
}
