<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Lightbox_Video extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-lightbox-video';
	}

	public function get_title() {
		return esc_html__( 'Lightbox Video', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'play_label',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( '"Play" button label', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'link',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Video URL', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			array(
				'label' => esc_html__( 'Background', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'image',
			array(
				'label'   => esc_html__( 'Background Image', 'cassio' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
			)
		);

		$this->add_control(
			'image_parallax',
			array(
				'label'     => esc_html__( 'Enable parallax', 'cassio' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'image_parallax_speed',
			array(
				'label'     => esc_html__( 'Parallax Speed', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'factor' => array(
						'min'  => -0.5,
						'max'  => 0.5,
						'step' => 0.01,
					),
				),
				'default'   => array(
					'unit' => 'factor',
					'size' => 0.1,
				),
				'condition' => array(
					'image_parallax' => 'yes',
					'image!'         => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'image_overlay_opacity',
			array(
				'label'     => esc_html__( 'Image Overlay Opacity', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => array(
					'size' => .6,
				),
				'range'     => array(
					'px' => array(
						'max'  => 1,
						'step' => 0.01,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .section-video__overlay' => 'opacity: {{SIZE}};',
				),
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'video_section',
			array(
				'label' => esc_html__( 'Video', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'play_label',
			array(
				'label'   => esc_html__( '"Play" button label', 'cassio' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Play', 'cassio' ),
			)
		);

		$this->add_control(
			'link',
			array(
				'label'         => esc_html__( 'Video URL', 'cassio' ),
				'type'          => Controls_Manager::URL,
				'show_external' => false,
				'placeholder'   => sprintf( '%1s: %2s', esc_html__( 'Example', 'cassio' ), 'https://youtu.be/watch?v=BsekcY04xvQ' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

		$this->add_control(
			'inner_paddings',
			array(
				'label'   => esc_html__( 'Paddings Inner', 'cassio' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''                                    => esc_html__( 'None', 'cassio' ),
					'section_pt-xsmall section_pb-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
					'section_pt-small section_pb-small'   => esc_html__( '+ Small', 'cassio' ),
					'section_pt section_pb'               => esc_html__( '+ Medium', 'cassio' ),
					'section_pt-large section_pb-large'   => esc_html__( '+ Large', 'cassio' ),
					'section_pt-xlarge section_pb-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'section', 'class', array( 'section-video', $settings['inner_paddings'] ) );

		if ( $settings['image_parallax'] ) {

			$this->add_render_attribute(
				'section',
				array(
					'data-art-parallax'        => 'background',
					'data-art-parallax-factor' => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
				)
			);

		}

		?>

		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<a class="container section-video__link mfp-iframe js-video" href="<?php echo $settings['link']['url']; ?>">
				<div class="section-video__icon js-button-circle">
					<?php if ( ! empty( $settings['play_label'] ) ) : ?>
						<?php echo $settings['play_label']; ?>
					<?php endif; ?>
					<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
						<g fill="none" fill-rule="evenodd">
							<g transform="translate(-134.000000, -98.000000)">
							<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0" style="stroke-dashoffset: 472.306; stroke-dasharray: 0px, 999999px;"></path>
							</g>
						</g>
					</svg>
				</div>
			</a>
			<?php if ( ! empty( $settings['image']['url'] ) ) : ?>
				<?php
					arts_the_lazy_image(
						array(
							'id'      => $settings['image']['id'],
							'class'   => array(
								'wrapper' => array( 'art-parallax__wrapper' ),
								'image'   => array( 'art-parallax__bg' ),
								'overlay' => array( 'overlay', 'overlay_dark', 'section-video__overlay' ),
							),
							'overlay' => true,
						)
					);
				?>
			<?php endif; ?>
		</div>

		<?php
	}
}
