<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Masonry_Grid extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-masonry-grid';
	}

	public function get_title() {
		return esc_html__( 'Masonry Grid', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	protected function register_controls() {

		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Images', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Gallery Lightbox
		 */
		$this->add_control(
			'gallery',
			array(
				'type'    => Controls_Manager::GALLERY,
				'default' => array(),
			)
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'label'   => esc_html__( 'Thumbnail Size', 'cassio' ),
				'name'    => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
				'default' => 'full',
			)
		);

		$this->end_controls_section();

		/**
		 * Section Settings
		 */
		$this->start_controls_section(
			'settings_section',
			array(
				'label' => esc_html__( 'Settings', 'cassio' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Enable Lightbox
		 */
		$this->add_control(
			'lightbox',
			array(
				'label'   => esc_html__( 'Enable Lightbox', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Enable Captions
		 */
		$this->add_control(
			'enable_captions',
			array(
				'label'   => esc_html__( 'Enable Image Captions', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'captions_style',
			array(
				'label'     => esc_html__( 'Captions Style', 'cassio' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'section-image__caption-horizontal',
				'options'   => array(
					'section-image__caption-horizontal'    => esc_html__( 'Horizontal', 'cassio' ),
					'section-image__caption-vertical-left' => esc_html__( 'Vertical Bottom Left', 'cassio' ),
					'section-image__caption-vertical-right' => esc_html__( 'Vertical Top Right', 'cassio' ),
				),
				'condition' => array(
					'enable_captions' => 'yes',
				),
			)
		);

		$this->add_control(
			'captions_alignment',
			array(
				'label'     => esc_html__( 'Captions Alignment', 'cassio' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'text-left'   => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-h-align-left',
					),
					'text-center' => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-h-align-center',
					),
					'text-right'  => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'default'   => 'text-center',
				'toggle'    => false,
				'condition' => array(
					'enable_captions' => 'yes',
					'captions_style'  => 'section-image__caption-horizontal',
				),
			)
		);

		$this->add_control(
			'container_class_vertical',
			array(
				'type'         => Controls_Manager::HIDDEN,
				'default'      => 'elementor-widget_vertical-captions',
				'prefix_class' => '',
				'classes'      => '{{WRAPPER}}',
				'condition'    => array(
					'enable_captions' => 'yes',
					'captions_style!' => 'section-image__caption-horizontal',
				),
			)
		);

		$this->end_controls_section();

		/**
		 * Section Layout
		 */
		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

		$this->add_control(
			'enable_fancy',
			array(
				'label'     => esc_html__( 'Enable Fancy Grid', 'cassio' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'columns!' => '12',
				),
			)
		);

		/**
		 * Columns
		 */
		$selector_value_string = 'flex: 0 0 calc({{VALUE}} / 12  * 100%); max-width: calc({{VALUE}} / 12 * 100%);';
		$this->add_responsive_control(
			'columns',
			array(
				'label'              => esc_html__( 'Columns', 'cassio' ),
				'type'               => Controls_Manager::SELECT,
				'options'            => array(
					3  => esc_html__( 'Four Columns', 'cassio' ),
					4  => esc_html__( 'Three Columns', 'cassio' ),
					6  => esc_html__( 'Two Columns', 'cassio' ),
					12 => esc_html__( 'Single Column', 'cassio' ),
				),
				'selectors'          => array(
					'{{WRAPPER}} .grid__sizer' => $selector_value_string,
					'{{WRAPPER}} .grid__item'  => $selector_value_string,
				),
				'render_type'        => 'template',
				'default'            => 4,
				'desktop_default'    => 4,
				'tablet_default'     => 6,
				'mobile_default'     => 12,
				'frontend_available' => true,
			)
		);

		/**
		 * Space Between
		 */
		$this->add_responsive_control(
			'space_between',
			array(
				'label'           => esc_html__( 'Space Between', 'cassio' ),
				'type'            => Controls_Manager::SLIDER,
				'range'           => array(
					'px' => array(
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					),
					'vw' => array(
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					),
				),
				'size_units'      => array( 'px', 'vw' ),
				'devices'         => array( 'desktop', 'tablet', 'mobile' ),
				'default'         => array(
					'size' => 6,
					'unit' => 'vw',
				),
				'desktop_default' => array(
					'size' => 6,
					'unit' => 'vw',
				),
				'tablet_default'  => array(
					'size' => 40,
					'unit' => 'px',
				),
				'mobile_default'  => array(
					'size' => 20,
					'unit' => 'px',
				),
				'selectors'       => array(
					'{{WRAPPER}}.elementor-widget_vertical-captions .elementor-widget-container' => 'padding: 0 calc({{SIZE}}{{UNIT}});',
					// '{{WRAPPER}}'             => 'overflow: hidden;',
					'{{WRAPPER}} .grid'       => 'margin: calc(-{{SIZE}}{{UNIT}}) calc(-{{SIZE}}{{UNIT}});',
					'{{WRAPPER}} .grid__item' => 'padding: calc({{SIZE}}{{UNIT}});',
					'{{WRAPPER}} .grid_fancy .grid__item:nth-child(3)' => 'margin-top: {{SIZE}}{{UNIT}};',
					'(tablet){{WRAPPER}} .grid_fancy .grid__item:nth-child(3)' => 'margin-top: 0;',
					'(mobile){{WRAPPER}} .grid_fancy .grid__item:nth-child(3)' => 'margin-top: 0;',
				),
				'render_type'     => 'template',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'animation_section',
			array(
				'label' => esc_html__( 'Animation', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_animation',
			array(
				'label'   => esc_html__( 'Enable on-scroll animation', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => '',
			)
		);

		$this->add_control(
			'heading_parallax',
			array(
				'label'     => esc_html__( 'Parallax', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'image_parallax',
			array(
				'label'   => esc_html__( 'Enable parallax', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'image_parallax_speed',
			array(
				'label'     => esc_html__( 'Parallax Speed', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'factor' => array(
						'min'  => -0.5,
						'max'  => 0.5,
						'step' => 0.01,
					),
				),
				'default'   => array(
					'unit' => 'factor',
					'size' => 0.1,
				),
				'condition' => array(
					'image_parallax' => 'yes',
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$columns_desktop = array_key_exists( 'columns', $settings ) ? $settings['columns'] : 12;
		$columns_tablet  = array_key_exists( 'columns_tablet', $settings ) ? $settings['columns_tablet'] : 12;
		$columns_mobile  = array_key_exists( 'columns_mobile', $settings ) ? $settings['columns_mobile'] : 12;

		$col_desktop = 'grid__item_desktop-' . $this->translate_columns_settings_inverse( $columns_desktop );
		$col_tablet  = 'grid__item_tablet-' . $this->translate_columns_settings_inverse( $columns_tablet );
		$col_mobile  = 'grid__item_mobile-' . $this->translate_columns_settings_inverse( $columns_mobile );

		$lightbox = $settings['lightbox'];

		$this->add_render_attribute(
			'section',
			array(
				'class'                    => array( 'section', 'section-grid', 'grid', 'js-grid' ),
				'data-grid-columns'        => 12 / $settings['columns'],
				'data-grid-columns-tablet' => 12 / $settings['columns_tablet'],
				'data-grid-columns-mobile' => 12 / $settings['columns_mobile'],
			)
		);

		$this->add_render_attribute(
			'sizerAtts',
			array(
				'class' => array( 'grid__sizer', 'js-grid__sizer', $col_desktop, $col_tablet, $col_mobile ),
			)
		);

		$this->add_render_attribute(
			'wrapperImg',
			array(
				'class' => array( 'figure-image__wrapper-img' ),
			)
		);

		if ( $settings['enable_fancy'] ) {

			$this->add_render_attribute(
				'section',
				array(
					'class' => array( 'grid_fancy', 'js-grid' ),
				)
			);

		}

		if ( $settings['enable_animation'] ) {

			$this->add_render_attribute(
				'section',
				array(
					'data-os-animation' => 'data-os-animation',
				)
			);
		}

		?>

		<?php if ( ! empty( $settings['gallery'] ) ) : ?>
			<div <?php $this->print_render_attribute_string( 'section' ); ?>>
				<div <?php $this->print_render_attribute_string( 'sizerAtts' ); ?>></div>
				<?php foreach ( $settings['gallery'] as $index => $image ) : ?>
					<?php
						$title         = wp_get_attachment_caption( $image['id'] );
						$class_caption = '';

						$this->add_render_attribute(
							'wrapperOutter',
							array(
								'class' => 'figure-image section-image',
							),
							true,
							true
						);

						if ( $settings['enable_captions'] && ! empty( $title ) ) {
							$class_caption = 'grid__item_caption';
						}

						$this->add_render_attribute(
							'itemAtts',
							array(
								'class' => array( 'grid__item', 'js-grid__item', $col_desktop, $col_tablet, $col_mobile, $class_caption ),
							),
							true,
							true
						);

					?>
					<div <?php $this->print_render_attribute_string( 'itemAtts' ); ?>>
						<?php

						$tag = 'div';

						if ( $lightbox ) {
							$img_full = wp_get_attachment_image_src( $image['id'], 'full' );
							$this->add_render_attribute(
								'wrapperOutter',
								array(
									'class' => 'figure-image section-image grid__item-link',
									'href'  => $img_full[0],
									'data-elementor-open-lightbox' => 'true',
									'data-elementor-lightbox-slideshow' => $this->get_id(),
									'aria-label' => ! empty( $title ) ? $title : esc_html__( 'View Image', 'cassio' ),
								),
								true,
								true
							);

							$tag = 'a';
						}
						?>
							<<?php echo $tag; ?> <?php $this->print_render_attribute_string( 'wrapperOutter' ); ?>>
								<div <?php $this->print_render_attribute_string( 'wrapperImg' ); ?>>
									<div class="figure-image__wrapper-img-inner">
										<div class="figure-image__wrapper-img-zoom">
											<?php
												arts_the_lazy_image(
													array(
														'id'   => $image['id'],
														'type' => 'image',
														'size' => $settings['image_size'],
														'parallax' => array(
															'wrapper' => true,
															'enabled' => $settings['image_parallax'],
															'factor' => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
														),
													)
												);
											?>
										</div>
									</div>
								</div>
								<?php if ( $settings['enable_captions'] && ! empty( $title ) ) : ?>
									<div class="section-image__caption <?php echo $settings['captions_style']; ?> <?php echo $settings['captions_alignment']; ?>">
										<?php
										if ( $settings['enable_animation'] ) :
											?>
											<div class="figure-image__wrapper-caption"><?php endif; ?>
											<?php echo $title; ?>
										<?php
										if ( $settings['enable_animation'] ) :
											?>
											</div><?php endif; ?>
									</div>
								<?php endif; ?>
							</<?php echo $tag; ?>>
						</div>
					<?php endforeach; ?>
			</div>
		<?php endif; ?>

		<?php
	}
}
