<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Parallax_Background extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-parallax-background';
	}

	public function get_title() {
		return esc_html__( 'Parallax Background', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'heading_background',
			array(
				'label' => esc_html__( 'Background', 'cassio' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		$this->add_control(
			'background_type',
			array(
				'label'   => esc_html__( 'Type', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'image' => array(
						'title' => esc_html__( 'Image', 'cassio' ),
						'icon'  => 'eicon-image-bold',
					),
					'video' => array(
						'title' => esc_html__( 'Video', 'cassio' ),
						'icon'  => 'eicon-video-camera',
					),
				),
				'default' => 'image',
				'toggle'  => false,
			)
		);

		$this->add_control(
			'image',
			array(
				'label'     => esc_html__( 'Choose Image', 'cassio' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'condition' => array(
					'background_type' => 'image',
				),
			)
		);

		$this->add_control(
			'video',
			array(
				'label'      => esc_html__( 'Choose Video', 'cassio' ),
				'type'       => Controls_Manager::MEDIA,
				'media_type' => 'video',
				'condition'  => array(
					'background_type' => 'video',
				),
			)
		);

		$this->add_control(
			'image_placement',
			array(
				'label'     => esc_html__( 'Background Placement', 'cassio' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'image'      => array(
						'title' => esc_html__( 'Embeded Element', 'cassio' ),
						'icon'  => 'eicon-image-before-after',
					),
					'background' => array(
						'title' => esc_html__( 'Background', 'cassio' ),
						'icon'  => 'eicon-image',
					),
				),
				'default'   => 'image',
				'toggle'    => false,
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'fullwidth',
			array(
				'label'     => esc_html__( 'Enable Fullwidth', 'cassio' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => '',
				'condition' => array(
					'background_type' => 'image',
					'image_placement' => 'image',
				),
				'selectors' => array(
					'{{WRAPPER}} .section-image__wrapper img' => 'width: 100%; height: auto;',
				),
			)
		);

		$this->add_responsive_control(
			'height',
			array(
				'label'           => esc_html__( 'Background Height', 'cassio' ),
				'type'            => Controls_Manager::SLIDER,
				'default' => array(
					'size' => 800,
					'unit' => 'px',
				),
				'desktop_default' => array(
					'size' => 800,
					'unit' => 'px',
				),
				'tablet_default'  => array(
					'size' => 70,
					'unit' => 'vh',
				),
				'mobile_default'  => array(
					'size' => 50,
					'unit' => 'vh',
				),
				'range'           => array(
					'px' => array(
						'min' => 0,
						'max' => 1440,
					),
					'vh' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'size_units'      => array( 'px', 'vh' ),
				'selectors'       => array(
					'{{WRAPPER}} .section-image__wrapper' => 'height: {{SIZE}}{{UNIT}};',
				),
				'condition'       => array(
					'image_placement' => 'background',
					'image!'          => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'heading_parallax',
			array(
				'label'     => esc_html__( 'Parallax', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'image_parallax',
			array(
				'label'     => esc_html__( 'Enable Parallax', 'cassio' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'image_parallax_speed',
			array(
				'label'     => esc_html__( 'Parallax Speed', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'factor' => array(
						'min'  => -0.5,
						'max'  => 0.5,
						'step' => 0.01,
					),
				),
				'default'   => array(
					'unit' => 'factor',
					'size' => 0.1,
				),
				'condition' => array(
					'image_parallax' => 'yes',
					'image!'         => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'heading_caption',
			array(
				'label'     => esc_html__( 'Caption', 'cassio' ),
				'separator' => 'before',
				'type'      => Controls_Manager::HEADING,
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'enable_caption',
			array(
				'label'     => esc_html__( 'Enable Caption', 'cassio' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'image!' => array(
						'id'  => '',
						'url' => '',
					),
				),
			)
		);

		$this->add_control(
			'caption_style',
			array(
				'label'     => esc_html__( 'Caption Style', 'cassio' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'horizontal',
				'options'   => array(
					'horizontal' => esc_html__( 'Horizontal', 'cassio' ),
					'vertical'   => esc_html__( 'Vertical', 'cassio' ),
				),
				'condition' => array(
					'image!'         => array(
						'id'  => '',
						'url' => '',
					),
					'enable_caption' => 'yes',
				),
			)
		);

		$this->add_control(
			'message_incompatible-layout',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'Your current image layout may not display vertical captions due to no left/right block space. Please adjust your image layout.', 'cassio' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
				'condition'       => array(
					'caption_style' => 'vertical',
					'layout'        => 'section text-center',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'   => esc_html__( 'Background Alignment', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'section text-center'       => array(
						'title' => esc_html__( 'Fullwidth', 'cassio' ),
						'icon'  => 'eicon-h-align-stretch',
					),
					'section_w-container-left'  => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-h-align-left',
					),
					'container text-center'     => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-h-align-center',
					),
					'section_w-container-right' => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'default' => 'section text-center',
				'toggle'  => false,
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$caption  = '';

		$this->add_render_attribute( 'section', 'class', array( 'section', 'section-image', $settings['layout'] ) );

		if ( $settings['enable_caption'] ) {

			if ( $settings['background_type'] == 'video' ) {
				$caption = wp_get_attachment_caption( $settings['video']['id'] );
			} else {
				$caption = wp_get_attachment_caption( $settings['image']['id'] );
			}

			switch ( $settings['layout'] ) {
				case 'section text-center': {
					if ( $settings['caption_style'] == 'vertical' ) {
						$this->add_render_attribute( 'caption', 'class', array( 'section-image__caption', 'section-image__caption-vertical-left' ), true, true );
					} else {
						$this->add_render_attribute( 'caption', 'class', array( 'section-image__caption', 'section-image__caption-horizontal' ), true, true );
					}
					break;
				}
				case 'section_w-container-left': {
					if ( $settings['caption_style'] == 'vertical' ) {
						$this->add_render_attribute( 'caption', 'class', array( 'section-image__caption', 'section-image__caption-vertical-right' ), true, true );
					} else {
						$this->add_render_attribute( 'caption', 'class', array( 'section-image__caption', 'section-image__caption-horizontal' ), true, true );
					}
					break;
				}
				case 'container text-center': {
					if ( $settings['caption_style'] == 'vertical' ) {
						$this->add_render_attribute( 'caption', 'class', array( 'section-image__caption', 'section-image__caption-vertical-left' ), true, true );
					} else {
						$this->add_render_attribute( 'caption', 'class', array( 'section-image__caption', 'section-image__caption-horizontal' ), true, true );
					}
					break;
				}
				case 'section_w-container-right': {
					if ( $settings['caption_style'] == 'vertical' ) {
						$this->add_render_attribute( 'caption', 'class', array( 'section-image__caption', 'section-image__caption-vertical-left' ), true, true );
					} else {
						$this->add_render_attribute( 'caption', 'class', array( 'section-image__caption', 'section-image__caption-horizontal' ), true, true );
					}
					break;
				}

			}
		}

		?>

		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<?php if ( $settings['image_placement'] === 'background' ) : ?>
				<?php if ( $settings['background_type'] === 'video' ) : ?>
					<?php
						arts_the_lazy_image(
							array(
								'id'       => $settings['video']['id'],
								'type'     => 'background-video',
								'class'    => array(
									'wrapper' => array( 'section-image__wrapper' ),
									'image'   => array( 'art-parallax__bg' ),
								),
								'parallax' => array(
									'wrapper' => true,
									'enabled' => $settings['image_parallax'],
									'factor'  => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
								),
							)
						);
					?>
				<?php else : ?>
					<?php
						arts_the_lazy_image(
							array(
								'id'       => $settings['image']['id'],
								'type'     => 'background',
								'class'    => array(
									'wrapper' => array( 'section-image__wrapper' ),
									'image'   => array( 'art-parallax__bg' ),
								),
								'parallax' => array(
									'wrapper' => true,
									'enabled' => $settings['image_parallax'],
									'factor'  => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
								),
							)
						);
					?>
				<?php endif; ?>
			<?php elseif ( $settings['image_placement'] === 'image' ) : ?>
				<?php if ( $settings['background_type'] == 'video' ) : ?>
					<?php
						arts_the_lazy_image(
							array(
								'id'       => $settings['video']['id'],
								'type'     => 'video',
								'class'    => array(
									'wrapper' => array( 'section-image__wrapper' ),
									'image'   => array( 'art-parallax__bg' ),
								),
								'parallax' => array(
									'wrapper' => true,
									'enabled' => $settings['image_parallax'],
									'factor'  => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
								),
							)
						);
					?>
				<?php else : ?>
					<?php
						arts_the_lazy_image(
							array(
								'id'       => $settings['image']['id'],
								'type'     => 'image',
								'class'    => array(
									'wrapper' => array( 'section-image__wrapper' ),
									'image'   => array( 'art-parallax__bg' ),
								),
								'parallax' => array(
									'wrapper' => true,
									'enabled' => $settings['image_parallax'],
									'factor'  => $settings['image_parallax_speed'] ? $settings['image_parallax_speed']['size'] : 0,
								),
							)
						);
					?>
				<?php endif; ?>
			<?php endif; ?>
			<?php if ( ! empty( $caption ) ) : ?>
				<div <?php $this->print_render_attribute_string( 'caption' ); ?>><?php echo $caption; ?></div>
			<?php endif; ?>
		</div>

		<?php
	}
}
