<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'init', 'arts_register_taxonomies' );
function arts_register_taxonomies() {

	/**
	 * Portfolio Category
	 */
	register_taxonomy(
		'arts_portfolio_category',
		array( 'arts_portfolio_item' ),
		array(
			'labels'            => array(
				'name'                       => _x( 'Portfolio Categories', 'taxonomy general name', 'cassio' ),
				'singular_name'              => _x( 'Portfolio Category', 'taxonomy singular name', 'cassio' ),
				'search_items'               => __( 'Search Portfolio Categories', 'cassio' ),
				'all_items'                  => __( 'All Portfolio Categories', 'cassio' ),
				'parent_item'                => __( 'Parent Portfolio Category', 'cassio' ),
				'parent_item_colon'          => __( 'Parent Portfolio Category:', 'cassio' ),
				'edit_item'                  => __( 'Edit Portfolio Category', 'cassio' ),
				'update_item'                => __( 'Update Portfolio Category', 'cassio' ),
				'add_new_item'               => __( 'Add New Portfolio Category', 'cassio' ),
				'new_item_name'              => __( 'New Portfolio Category', 'cassio' ),
				'separate_items_with_commas' => __( 'Separate portfolio categories with commas', 'cassio' ),
				'add_or_remove_items'        => __( 'Add or remove writers', 'cassio' ),
				'choose_from_most_used'      => __( 'Choose from the most used portfolio categories', 'cassio' ),
				'not_found'                  => __( 'No portfolio categories found.', 'cassio' ),
				'menu_name'                  => __( 'Portfolio Categories', 'cassio' ),
			),
			'public'            => true,
			'hierarchical'      => false,
			'show_admin_column' => true,
			'query_var'         => true,
		)
	);

}

