<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Page Header in Elementor Document Settings
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_header' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_header' );
function arts_add_elementor_document_settings_page_header( \Elementor\Core\DocumentTypes\PageBase $page ) {
	$page->start_controls_section(
		'page_header_section',
		array(
			'label' => esc_html__( 'Page Header', 'cassio' ),
			'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
		)
	);

	$page->add_control(
		'page_header_settings',
		array(
			'label'       => esc_html__( 'Override Page Header Settings', 'cassio' ),
			'description' => esc_html__( 'Use custom header settings for this page instead of global customizer settings', 'cassio' ),
			'type'        => \Elementor\Controls_Manager::SWITCHER,
			'default'     => '',
		)
	);

	$page->add_control(
		'page_header_heading_theme',
		array(
			'label'     => esc_html__( 'Main', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_header_main_theme',
		array(
			'label'     => esc_html__( 'Main Color Theme', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'header_color-white' => esc_html__( 'White', 'cassio' ),
				'header_color-black' => esc_html__( 'Black', 'cassio' ),
			),
			'default'   => 'header_color-black',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_header_main_logo',
		array(
			'label'     => esc_html__( 'Main Logo to Display', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'header_logo-primary'   => esc_html__( 'Primary', 'cassio' ),
				'header_logo-secondary' => esc_html__( 'Secondary', 'cassio' ),
			),
			'default'   => 'header_logo-primary',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_header_heading_sticky',
		array(
			'label'     => esc_html__( 'Sticky', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_header_sticky_theme',
		array(
			'label'     => esc_html__( 'Sticky Color Theme', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'bg-white'              => esc_html__( 'White', 'cassio' ),
				'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
				'bg-light'              => esc_html__( 'Light', 'cassio' ),
				'bg-black'              => esc_html__( 'Black', 'cassio' ),
				'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
				'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
				'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
				'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
				'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
				'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
				'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
				'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
				'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
				'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
				'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
			),
			'default'   => 'bg-dark-2',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_header_sticky_logo',
		array(
			'label'     => esc_html__( 'Sticky Logo to Display', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'header_logo-primary'   => esc_html__( 'Primary', 'cassio' ),
				'header_logo-secondary' => esc_html__( 'Secondary', 'cassio' ),
			),
			'default'   => 'header_logo-secondary',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_header_heading_menu',
		array(
			'label'     => esc_html__( 'Menu', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_header_overlay_menu_theme',
		array(
			'label'     => esc_html__( 'Menu Overlay Theme', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'bg-white'              => esc_html__( 'White', 'cassio' ),
				'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
				'bg-light'              => esc_html__( 'Light', 'cassio' ),
				'bg-black'              => esc_html__( 'Black', 'cassio' ),
				'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
				'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
				'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
				'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
				'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
				'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
				'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
				'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
				'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
				'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
				'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
			),
			'default'   => 'bg-dark',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_menu_overlay_background_color',
		array(
			'label'     => esc_html__( 'Menu Background Overlay', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'default'   => 'rgba(0,0,0,0)',
			'condition' => array(
				'page_header_settings' => 'yes',
			),
			'selectors' => array(
				'.header__curtain:after' => 'background-color: {{VALUE}} !important;',
			),
		)
	);

	$page->end_controls_section();
}
