<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Page Transition in Elementor Document Settings
 */
add_action( 'elementor/element/wp-page/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_transition' );
add_action( 'elementor/element/wp-post/document_settings/after_section_end', 'arts_add_elementor_document_settings_page_transition' );
function arts_add_elementor_document_settings_page_transition( \Elementor\Core\DocumentTypes\PageBase $page ) {
	$page->start_controls_section(
		'page_transition_section',
		array(
			'label' => esc_html__( 'Page Transition', 'cassio' ),
			'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
		)
	);

	$page->add_control(
		'page_transition_settings',
		array(
			'label'       => esc_html__( 'Override Page Transition Settings', 'cassio' ),
			'description' => esc_html__( 'Use custom AJAX transition settings for this page instead of global customizer settings', 'cassio' ),
			'type'        => \Elementor\Controls_Manager::SWITCHER,
			'default'     => '',
		)
	);

	$page->add_control(
		'page_ajax_flying_heading_enabled',
		array(
			'label'     => esc_html__( 'Enable Flying Heading Transition', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'default'   => 'yes',
			'condition' => array(
				'page_transition_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_ajax_curtain_color',
		array(
			'label'     => esc_html__( 'Curtain Color', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => array(
				'bg-white'              => esc_html__( 'White', 'cassio' ),
				'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
				'bg-light'              => esc_html__( 'Light', 'cassio' ),
				'bg-black'              => esc_html__( 'Black', 'cassio' ),
				'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
				'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
				'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
				'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
				'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
				'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
				'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
				'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
				'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
				'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
				'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
			),
			'default'   => get_theme_mod( 'ajax_curtain_color', 'bg-off-white' ),
			'condition' => array(
				'page_transition_settings' => 'yes',
			),
		)
	);

	$page->add_control(
		'page_ajax_to_enabled',
		array(
			'label'     => sprintf(
				'%1s <strong>%2s</strong> %3s',
				esc_html__( 'Enable AJAX Transition', 'cassio' ),
				esc_html__( 'TO', 'cassio' ),
				esc_html__( 'this Page', 'cassio' )
			),
			'separator' => 'before',
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'default'   => 'yes',
		)
	);

	$page->add_control(
		'page_ajax_to_disabled_notice',
		array(
			'type'            => \Elementor\Controls_Manager::RAW_HTML,
			'raw'             => esc_html__( 'This page will interrupt an active AJAX transition and perform a hard refresh in browser.', 'cassio' ),
			'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
			'condition'       => array(
				'page_ajax_to_enabled' => '',
			),
		)
	);

	$page->add_control(
		'page_ajax_from_enabled',
		array(
			'label'   => sprintf(
				'%1s <strong>%2s</strong> %3s',
				esc_html__( 'Enable AJAX Transition', 'cassio' ),
				esc_html__( 'FROM', 'cassio' ),
				esc_html__( 'this Page', 'cassio' )
			),
			'type'    => \Elementor\Controls_Manager::SWITCHER,
			'default' => 'yes',
		)
	);

	$page->add_control(
		'page_ajax_from_disabled_notice',
		array(
			'type'            => \Elementor\Controls_Manager::RAW_HTML,
			'raw'             => esc_html__( 'All the links on this page will perform a hard refresh in browser.', 'cassio' ),
			'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
			'condition'       => array(
				'page_ajax_from_enabled' => '',
			),
		)
	);

	$page->end_controls_section();
}
