<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Add new controls to Elementor standard "Section" widget
 */
add_action( 'elementor/element/section/section_advanced/before_section_end', 'arts_add_elementor_section_after_controls', 10, 2 );
add_action( 'elementor/element/container/section_layout/before_section_end', 'arts_add_elementor_section_after_controls', 10, 2 );
function arts_add_elementor_section_after_controls( $control ) {
	$control->add_control(
		'heading_theme',
		array(
			'label'     => esc_html__( 'Theme Options', 'cassio' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
		)
	);

	$control->add_control(
		'theme_section_pt',
		array(
			'label'        => esc_html__( 'Padding Top', 'cassio' ),
			'type'         => \Elementor\Controls_Manager::SELECT,
			'default'      => '',
			'options'      => array(
				''                  => esc_html__( 'Auto', 'cassio' ),
				'section_pt-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
				'section_pt-small'  => esc_html__( '+ Small', 'cassio' ),
				'section_pt'        => esc_html__( '+ Medium', 'cassio' ),
				'section_pt-large'  => esc_html__( '+ Large', 'cassio' ),
				'section_pt-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
			),
			'prefix_class' => '',
			'classes'      => '{{WRAPPER}}',
			'condition'    => array(
				'theme_section_gutters!' => 'container-fluid container-fluid_paddings',
			),
		)
	);

	$control->add_control(
		'theme_section_pb',
		array(
			'label'        => esc_html__( 'Padding Bottom', 'cassio' ),
			'type'         => \Elementor\Controls_Manager::SELECT,
			'default'      => '',
			'options'      => array(
				''                  => esc_html__( 'Auto', 'cassio' ),
				'section_pb-xsmall' => esc_html__( '+ XSmall', 'cassio' ),
				'section_pb-small'  => esc_html__( '+ Small', 'cassio' ),
				'section_pb'        => esc_html__( '+ Medium', 'cassio' ),
				'section_pb-large'  => esc_html__( '+ Large', 'cassio' ),
				'section_pb-xlarge' => esc_html__( '+ XLarge', 'cassio' ),
			),
			'prefix_class' => '',
			'classes'      => '{{WRAPPER}}',
			'condition'    => array(
				'theme_section_gutters!' => 'container-fluid container-fluid_paddings',
			),
		)
	);

	$control->add_control(
		'theme_section_gutters',
		array(
			'label'        => esc_html__( 'Gutters', 'cassio' ),
			'type'         => \Elementor\Controls_Manager::SELECT,
			'default'      => '',
			'options'      => array(
				''                                         => esc_html__( 'Auto', 'cassio' ),
				'container-fluid'                          => esc_html__( 'Left / Right Only', 'cassio' ),
				'container-fluid container-fluid_paddings' => esc_html__( 'All Sides', 'cassio' ),
			),
			'prefix_class' => '',
			'classes'      => '{{WRAPPER}}',
		)
	);

	$control->add_control(
		'theme_section_offset_from_bottom',
		array(
			'label'        => esc_html__( 'Offset from Bottom', 'cassio' ),
			'type'         => \Elementor\Controls_Manager::SWITCHER,
			'return_value' => 'section-offset_top',
			'default'      => '',
			'prefix_class' => '',
			'classes'      => '{{WRAPPER}}',
			'condition'    => array(
				'theme_section_pt'  => '',
				'theme_section_pb!' => '',
			),
		)
	);

	$control->add_control(
		'theme_section_offset_from_top',
		array(
			'label'        => esc_html__( 'Offset from Top', 'cassio' ),
			'type'         => \Elementor\Controls_Manager::SWITCHER,
			'return_value' => 'section-offset_bottom',
			'default'      => '',
			'prefix_class' => '',
			'classes'      => '{{WRAPPER}}',
			'condition'    => array(
				'theme_section_pb'  => '',
				'theme_section_pt!' => '',
			),
		)
	);

	$control->add_control(
		'theme_section_mt',
		array(
			'label'        => esc_html__( 'Margin Top', 'cassio' ),
			'type'         => \Elementor\Controls_Manager::SELECT,
			'default'      => '',
			'separator'    => 'before',
			'options'      => array(
				''                        => esc_html__( 'Auto', 'cassio' ),
				'section_mt-xsmall'       => esc_html__( '+ XSmall', 'cassio' ),
				'section_mt-small'        => esc_html__( '+ Small', 'cassio' ),
				'section_mt'              => esc_html__( '+ Medium', 'cassio' ),
				'section_mt-large'        => esc_html__( '+ Large', 'cassio' ),
				'section_mt-xlarge'       => esc_html__( '+ XLarge', 'cassio' ),
				'section_minus-mt-xsmall' => esc_html__( '- XSmall', 'cassio' ),
				'section_minus-mt-small'  => esc_html__( '- Small', 'cassio' ),
				'section_minus-mt'        => esc_html__( '- Medium', 'cassio' ),
				'section_minus-mt-large'  => esc_html__( '- Large', 'cassio' ),
				'section_minus-mt-xlarge' => esc_html__( '- XLarge', 'cassio' ),
			),
			'prefix_class' => '',
			'classes'      => '{{WRAPPER}}',
		)
	);

	$control->add_control(
		'theme_section_mb',
		array(
			'label'        => esc_html__( 'Margin Bottom', 'cassio' ),
			'type'         => \Elementor\Controls_Manager::SELECT,
			'default'      => '',
			'options'      => array(
				''                        => esc_html__( 'Auto', 'cassio' ),
				'section_mb-xsmall'       => esc_html__( '+ XSmall', 'cassio' ),
				'section_mb-small'        => esc_html__( '+ Small', 'cassio' ),
				'section_mb'              => esc_html__( '+ Medium', 'cassio' ),
				'section_mb-large'        => esc_html__( '+ Large', 'cassio' ),
				'section_mb-xlarge'       => esc_html__( '+ XLarge', 'cassio' ),
				'section_minus-mb-xsmall' => esc_html__( '- XSmall', 'cassio' ),
				'section_minus-mb-small'  => esc_html__( '- Small', 'cassio' ),
				'section_minus-mb'        => esc_html__( '- Medium', 'cassio' ),
				'section_minus-mb-large'  => esc_html__( '- Large', 'cassio' ),
				'section_minus-mb-xlarge' => esc_html__( '- XLarge', 'cassio' ),
			),
			'prefix_class' => '',
			'classes'      => '{{WRAPPER}}',
		)
	);

	$control->add_control(
		'theme_section_color',
		array(
			'label'        => esc_html__( 'Color Theme', 'cassio' ),
			'type'         => \Elementor\Controls_Manager::SELECT,
			'separator'    => 'before',
			'default'      => '',
			'options'      => array(
				''                      => esc_html__( 'Auto', 'cassio' ),
				'bg-white'              => esc_html__( 'White', 'cassio' ),
				'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
				'bg-light'              => esc_html__( 'Light', 'cassio' ),
				'bg-black'              => esc_html__( 'Black', 'cassio' ),
				'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
				'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
				'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
				'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
				'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
				'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
				'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
				'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
				'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
				'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
				'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
			),
			'prefix_class' => '',
			'classes'      => '{{WRAPPER}}',
		)
	);
}
