<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class WPML_Elementor_Cassio_Widget_About extends WPML_Elementor_Module_With_Items {
	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'counters';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'label' );
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_title( $field ) {
		switch ( $field ) {
			case 'label':
				return sprintf( '<strong>%1$s</strong><br>%2$s', esc_html__( 'Counters', 'cassio' ), esc_html__( 'Label', 'cassio' ) );
			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 *
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'label':
				return 'LINE';

			default:
				return '';
		}
	}
}
