<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Portfolio_Halfscreen_Slider extends Arts_Widget_Base {
	protected static $_instance, $_posts, $_post_type = 'arts_portfolio_item';
	protected static $_data_static_fields             = array( 'title', 'subheading', 'permalink', 'categories_names', 'image', 'video' );

	public function get_name() {
		return 'cassio-widget-portfolio-halfscreen-slider';
	}

	public function get_title() {
		return esc_html__( 'Portfolio Halfscreen Slider', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return array( 'cassio-dynamic' );
	}

	public function get_script_depends() {
		$deps = array( 'swiper' );

		if ( ! \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
			$transition_effect = $this->get_settings_for_display( 'transition_effect' );

			if ( $transition_effect === 'distortion' ) {
				$deps[] = 'three';
			}
		} else {
			$deps[] = 'three';
		}

		return $deps;
	}

	public function get_style_depends() {
		return array( 'swiper' );
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {

		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'button_text',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Button Title', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
			),
		);

		return $widgets;

	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		// posts toggles & posts amount
		$this->add_controls_posts_toggles();

		$this->start_controls_section(
			'button_section',
			array(
				'label' => esc_html__( 'Button', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'button_type',
			array(
				'label'   => esc_html__( 'Type', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'button',
				'options' => array(
					'button' => esc_html__( 'Button', 'cassio' ),
					'link'   => esc_html__( 'Link', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'button_text',
			array(
				'label'   => esc_html__( 'Title', 'cassio' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Explore Project', 'cassio' ),
			)
		);

		$this->add_control(
			'button_color',
			array(
				'label'       => esc_html__( 'Color', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'bg-white'              => esc_html__( 'White', 'cassio' ),
					'bg-off-white'          => esc_html__( 'Off white', 'cassio' ),
					'bg-light'              => esc_html__( 'Light', 'cassio' ),
					'bg-black'              => esc_html__( 'Black', 'cassio' ),
					'bg-dark'               => esc_html__( 'Dark', 'cassio' ),
					'bg-dark-2'             => esc_html__( 'Dark 2', 'cassio' ),
					'bg-dark-3'             => esc_html__( 'Dark 3', 'cassio' ),
					'bg-accent-primary-1'   => esc_html__( 'Accent Primary 1', 'cassio' ),
					'bg-accent-primary-2'   => esc_html__( 'Accent Primary 2', 'cassio' ),
					'bg-accent-primary-3'   => esc_html__( 'Accent Primary 3', 'cassio' ),
					'bg-accent-primary-4'   => esc_html__( 'Accent Primary 4', 'cassio' ),
					'bg-accent-secondary-1' => esc_html__( 'Accent Secondary 1', 'cassio' ),
					'bg-accent-secondary-2' => esc_html__( 'Accent Secondary 2', 'cassio' ),
					'bg-accent-secondary-3' => esc_html__( 'Accent Secondary 3', 'cassio' ),
					'bg-accent-secondary-4' => esc_html__( 'Accent Secondary 4', 'cassio' ),
				),
				'default'     => 'bg-accent-primary-3',
				'condition'   => array(
					'button_type' => 'button',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'settings_section',
			array(
				'label' => esc_html__( 'Elements', 'cassio' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		$this->add_control(
			'enable_categories',
			array(
				'type'    => Controls_Manager::SWITCHER,
				'label'   => esc_html__( 'Show Categories', 'cassio' ),
				'default' => 'yes',
			)
		);

		$this->add_control(
			'enable_subheadings',
			array(
				'type'    => Controls_Manager::SWITCHER,
				'label'   => esc_html__( 'Show Subheadings', 'cassio' ),
				'default' => '',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_section',
			array(
				'label' => esc_html__( 'Slider', 'cassio' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		$this->add_control(
			'direction',
			array(
				'label'   => esc_html__( 'Direction', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'horizontal',
				'options' => array(
					'horizontal' => array(
						'title' => esc_html__( 'Horizontal', 'cassio' ),
						'icon'  => 'eicon-h-align-stretch',
					),
					'vertical'   => array(
						'title' => esc_html__( 'Vertical', 'cassio' ),
						'icon'  => 'eicon-v-align-stretch',
					),
				),
				'toggle'  => false,
			)
		);

		$this->add_control(
			'enable_autoplay',
			array(
				'label'   => esc_html__( 'Enable Autoplay', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'autoplay_delay',
			array(
				'label'     => esc_html__( 'Autoplay Delay (ms)', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'ms' => array(
						'min'  => 1000,
						'max'  => 60000,
						'step' => 100,
					),
				),
				'default'   => array(
					'unit' => 'ms',
					'size' => 6000,
				),
				'condition' => array(
					'enable_autoplay' => 'yes',
				),
			)
		);

		$this->add_control(
			'speed',
			array(
				'label'   => esc_html__( 'Speed', 'cassio' ),
				'type'    => Controls_Manager::SLIDER,
				'range'   => array(
					'ms' => array(
						'min'  => 100,
						'max'  => 10000,
						'step' => 100,
					),
				),
				'default' => array(
					'unit' => 'ms',
					'size' => 1200,
				),
			)
		);

		$this->add_control(
			'heading_controls',
			array(
				'label'     => esc_html__( 'Controls', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'controls_position',
			array(
				'label'   => esc_html__( 'Position', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'justify-content-between',
				'options' => array(
					'justify-content-between' => esc_html__( 'Space Between', 'cassio' ),
					'justify-content-center'  => esc_html__( 'Center', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'enable_navigation',
			array(
				'label'   => esc_html__( 'Enable Navigation Arrows', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'enable_dots',
			array(
				'label'   => esc_html__( 'Enable Dots', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'enable_counter',
			array(
				'label'   => esc_html__( 'Enable Counter', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'counter_zeros',
			array(
				'label'     => esc_html__( 'Counter Prefix', 'cassio' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 2,
				'options'   => array(
					0 => esc_html__( 'None', 'cassio' ),
					1 => esc_html__( '1 Zero', 'cassio' ),
					2 => esc_html__( '2 Zeros', 'cassio' ),
				),
				'condition' => array(
					'enable_counter' => 'yes',
				),
			)
		);

		$this->add_control(
			'enable_mousewheel_control',
			array(
				'label'   => esc_html__( 'Enable Mousewheel Control', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'mousewheel_target',
			array(
				'label'     => esc_html__( 'Mousewheel Events Target', 'cassio' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '.page-wrapper',
				'options'   => array(
					'.page-wrapper' => esc_html__( 'Page Wrapper', 'cassio' ),
					'container'     => esc_html__( 'Container', 'cassio' ),
				),
				'condition' => array(
					'enable_mousewheel_control' => 'yes',
				),
			)
		);

		$this->add_control(
			'enable_keyboard_control',
			array(
				'label'   => esc_html__( 'Enable Keyboard Control', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'enable_touch_control',
			array(
				'label'   => esc_html__( 'Enable Touch Swipes Control', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

		$this->add_control(
			'heading_content',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'type'  => Controls_Manager::HEADING,
			)
		);

		$this->add_control(
			'content_position',
			array(
				'label'   => esc_html__( 'Position', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'order-lg-2',
				'options' => array(
					''           => esc_html__( 'Left', 'cassio' ),
					'order-lg-2' => esc_html__( 'Right', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'content_alignment',
			array(
				'label'   => esc_html__( 'Alignment', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'text-left'   => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-text-align-left',
					),
					'text-center' => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-text-align-center',
					),
					'text-right'  => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'default' => 'text-left',
				'toggle'  => false,
			)
		);

		$this->add_control(
			'container',
			array(
				'label'   => esc_html__( 'Container', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'container-fluid',
				'options' => array(
					'container'       => esc_html__( 'Boxed', 'cassio' ),
					'container-fluid' => esc_html__( 'Fullwidth', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'heading_image',
			array(
				'label'     => esc_html__( 'Background', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'image_type',
			array(
				'label'   => esc_html__( 'Priority Background', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'primary',
				'options' => array(
					'primary'   => esc_html__( 'Primary Featured Image', 'cassio' ),
					'secondary' => esc_html__( 'Secondary Featured Image', 'cassio' ),
				),
			)
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'label'   => esc_html__( 'Thumbnail Size', 'cassio' ),
				'name'    => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
				'default' => 'cassio-800x1200-crop',
			)
		);

		$this->add_control(
			'enable_video',
			array(
				'label'   => esc_html__( 'Use Featured Video', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'unsupported_transition',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'The selected transition effect doesn\'t support featured videos. The fallback image will be used.', 'cassio' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
				'condition'       => array(
					'enable_video'      => 'yes',
					'transition_effect' => 'distortion',
				),
			)
		);

		$this->add_control(
			'image_type_info',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => sprintf(
					'%1$s<br><br>%2$s <a href="%3$s" target="_blank">%4$s</a>',
					esc_html__( 'If a secondary featured image is not set for a post then it will fallback to a primary featured image.', 'cassio' ),
					esc_html__( 'You can edit your posts and adjust the featured images', 'cassio' ),
					admin_url( 'edit.php?post_type=arts_portfolio_item' ),
					esc_html__( 'in WordPress admin panel', 'cassio' )
				),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
				'condition'       => array(
					'image_type' => 'secondary',
				),
			)
		);

		$this->add_control(
			'image_position',
			array(
				'label'   => esc_html__( 'Position', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'slider-halfscreen_fullheight' => esc_html__( 'Fullheight', 'cassio' ),
					''                             => esc_html__( 'Gutters', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => esc_html__( 'Typography', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'heading_tag',
			array(
				'label'   => esc_html__( 'Headings HTML Tag', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => array(
					'h2' => esc_html( '<h2>' ),
					'h3' => esc_html( '<h3>' ),
					'h4' => esc_html( '<h4>' ),
					'h5' => esc_html( '<h5>' ),
					'h6' => esc_html( '<h6>' ),
				),
			)
		);

		$this->add_control(
			'heading_size',
			array(
				'label'   => esc_html__( 'Headings Size', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h1',
				'options' => array(
					'h1'       => esc_html__( 'H1', 'cassio' ),
					'h2'       => esc_html__( 'H2', 'cassio' ),
					'h3'       => esc_html__( 'H3', 'cassio' ),
					'h4'       => esc_html__( 'H4', 'cassio' ),
					'h5'       => esc_html__( 'H5', 'cassio' ),
					'h6'       => esc_html__( 'H6', 'cassio' ),
					'text-xl'  => esc_html__( 'XL', 'cassio' ),
					'text-xxl' => esc_html__( 'XXL', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'heading_weight',
			array(
				'label'   => esc_html__( 'Headings Weight', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''              => esc_html__( 'Auto', 'cassio' ),
					'heading-light' => esc_html__( 'Normal', 'cassio' ),
					'heading-bold'  => esc_html__( 'Bold', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'effects_section',
			array(
				'label' => esc_html__( 'Transition', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'transition_text_enabled',
			array(
				'label'   => esc_html__( 'Enable Text Transition', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'transition_effect',
			array(
				'label'   => esc_html__( 'Slides Transition Effect', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'enter_leave',
				'options' => array(
					''            => esc_html__( 'None', 'cassio' ),
					'distortion'  => esc_html__( 'Distortion', 'cassio' ),
					'enter_leave' => esc_html__( 'Enter-leave', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'transition_effect_intensity',
			array(
				'label'     => esc_html__( 'Effect Intensity', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'ms' => array(
						'min'  => 0,
						'max'  => 1,
						'step' => 0.01,
					),
				),
				'default'   => array(
					'unit' => 'ms',
					'size' => 0.33,
				),
				'condition' => array(
					'transition_effect!' => '',
				),
			)
		);

		$this->add_control(
			'transition_displacement_img_url',
			array(
				'label'     => esc_html__( 'Displacement Texture', 'cassio' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '/img/general/bg-displacement-9.jpg',
				'options'   => array(
					'/img/general/bg-displacement-1.jpg'  => esc_html__( 'Texture 1', 'cassio' ),
					'/img/general/bg-displacement-2.jpg'  => esc_html__( 'Texture 2', 'cassio' ),
					'/img/general/bg-displacement-3.jpg'  => esc_html__( 'Texture 3', 'cassio' ),
					'/img/general/bg-displacement-4.jpg'  => esc_html__( 'Texture 4', 'cassio' ),
					'/img/general/bg-displacement-5.jpg'  => esc_html__( 'Texture 5', 'cassio' ),
					'/img/general/bg-displacement-6.jpg'  => esc_html__( 'Texture 6', 'cassio' ),
					'/img/general/bg-displacement-7.jpg'  => esc_html__( 'Texture 7', 'cassio' ),
					'/img/general/bg-displacement-8.jpg'  => esc_html__( 'Texture 8', 'cassio' ),
					'/img/general/bg-displacement-9.jpg'  => esc_html__( 'Texture 9', 'cassio' ),
					'/img/general/bg-displacement-10.jpg' => esc_html__( 'Texture 10', 'cassio' ),
					'/img/general/bg-displacement-11.jpg' => esc_html__( 'Texture 11', 'cassio' ),
					'/img/general/bg-displacement-12.jpg' => esc_html__( 'Texture 12', 'cassio' ),
					'/img/general/bg-displacement-13.jpg' => esc_html__( 'Texture 13', 'cassio' ),
					'/img/general/bg-displacement-14.jpg' => esc_html__( 'Texture 14', 'cassio' ),
					'/img/general/bg-displacement-15.jpg' => esc_html__( 'Texture 15', 'cassio' ),
				),
				'condition' => array(
					'transition_effect' => 'distortion',
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$posts    = $this->get_posts_to_display();

		$icon_prev = 'keyboard_arrow_left';
		$icon_next = 'keyboard_arrow_right';

		$this->add_render_attribute(
			'section',
			array(
				'class'             => array( 'section', 'section-fullscreen-slider', 'section-fullheight' ),
				'data-os-animation' => 'data-os-animation',
			)
		);

		$this->add_render_attribute(
			'wrapper',
			array(
				'class' => array( 'slider', 'slider-fullscreen', 'slider-halfscreen', 'js-slider-fullscreen', $settings['image_position'] ),
			)
		);

		$this->add_render_attribute(
			'slider_content',
			array(
				'class' => array( 'swiper', 'swiper-container', 'slider-halfscreen__content', 'slider-halfscreen__content_padding', 'js-slider-fullscreen__content' ),
			)
		);

		$this->add_render_attribute(
			'slider_images',
			array(
				'class'              => array( 'swiper', 'swiper-container', 'slider-halfscreen__images', 'js-slider-fullscreen__images', 'h-100' ),
				'data-direction'     => $settings['direction'],
				'data-speed'         => $settings['speed']['size'],
				'data-counter-zeros' => $settings['counter_zeros'],
			)
		);

		$this->add_render_attribute(
			'heading',
			array(
				'class' => array( $settings['heading_size'], $settings['heading_weight'], 'slider__heading' ),
				// 'data-split-text-type' => 'lines, words, chars',
				// 'data-split-text-set'  => 'chars',
			)
		);

		$this->add_render_attribute(
			'category',
			array(
				'class' => array( 'subheading', 'slider__subheading' ),
				// 'data-split-text-type' => 'lines, words, chars',
				// 'data-split-text-set'  => 'chars',
			)
		);

		$this->add_render_attribute(
			'subheading',
			array(
				'class' => array( 'slider__text' ),
				// 'data-split-text-type' => 'lines',
				// 'data-split-text-set'  => 'lines',
			)
		);

		if ( $settings['transition_text_enabled'] ) {
			$this->add_render_attribute(
				'heading',
				array(
					'class'                => array( 'split-text', 'js-text-to-fly', 'js-split-text' ),
					'data-split-text-type' => 'lines, words, chars',
					'data-split-text-set'  => 'chars',
				)
			);

			$this->add_render_attribute(
				'category',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines, words, chars',
					'data-split-text-set'  => 'chars',
				)
			);

			$this->add_render_attribute(
				'subheading',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);
		} else {
			$this->add_render_attribute(
				'slider_content',
				array(
					'data-no-transition-text' => 'true',
				)
			);
		}

		$this->add_render_attribute(
			'col_content',
			array(
				'class' => array( 'col-lg-7', $settings['content_position'], $settings['content_alignment'] ),
			)
		);

		$this->add_render_attribute(
			'col_images',
			array(
				'class' => array( 'col-lg-5', 'h-100', 'order-lg-1' ),
			)
		);

		$this->add_render_attribute(
			'container',
			array(
				'class' => array( $settings['container'], 'h-100', 'slider-halfscreen__container' ),
			)
		);

		$this->add_render_attribute(
			'wrapper_footer',
			array(
				'class' => array( 'slider__footer', 'slider__footer_halfscreen' ),
			)
		);

		if ( $settings['enable_autoplay'] ) {
			$this->add_render_attribute(
				'slider_images',
				array(
					'data-autoplay-enabled' => 'true',
					'data-autoplay-delay'   => $settings['autoplay_delay']['size'],
				)
			);
		}

		if ( $settings['enable_keyboard_control'] ) {
			$this->add_render_attribute(
				'slider_images',
				array(
					'data-keyboard-enabled' => 'true',
				)
			);
		}

		if ( $settings['enable_touch_control'] ) {
			$this->add_render_attribute(
				'slider_images',
				array(
					'data-touch-enabled' => 'true',
				)
			);
		}

		if ( $settings['direction'] == 'vertical' ) {
			$icon_prev = 'keyboard_arrow_up';
			$icon_next = 'keyboard_arrow_down';
		}

		if ( $settings['image_position'] == 'slider-halfscreen_fullheight' ) {

			$this->add_render_attribute(
				'container',
				array(
					'class' => 'slider-halfscreen__container_fullheight',
				)
			);
			$this->add_render_attribute(
				'wrapper_footer',
				array(
					'class' => array( 'col-lg-7' ),
				)
			);

			if ( $settings['content_position'] ) {
				$this->add_render_attribute(
					'wrapper_footer',
					array(
						'class' => array( 'slider__footer_right' ),
					)
				);
			} else {
				$this->add_render_attribute(
					'wrapper_footer',
					array(
						'class' => array( 'slider__footer_left' ),
					)
				);
			}
		}

		if ( $settings['transition_effect'] ) {

			$this->add_render_attribute(
				'slider_images',
				array(
					'data-transition-effect'           => $settings['transition_effect'],
					'data-transition-effect-intensity' => $settings['transition_effect_intensity']['size'],
				)
			);

		}

		if ( $settings['transition_effect'] == 'distortion' ) {

			$this->add_render_attribute(
				'slider_images',
				array(
					'data-transition-displacement-img' => get_template_directory_uri() . $settings['transition_displacement_img_url'],
				)
			);

		}

		if ( $settings['enable_mousewheel_control'] ) {
			$this->add_render_attribute(
				'slider_images',
				array(
					'data-mousewheel-enabled' => 'true',
					'data-mousewheel-target'  => $settings['mousewheel_target'],
				)
			);
		}

		?>

		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<div class="section-fullheight__inner section-fullscreen-slider__inner">
				<div <?php $this->print_render_attribute_string( 'wrapper' ); ?>>
					<div <?php $this->print_render_attribute_string( 'container' ); ?>>
						<div class="row align-items-center justify-content-between h-100 no-gutters">
							<div <?php $this->print_render_attribute_string( 'col_content' ); ?>>
								<div <?php $this->print_render_attribute_string( 'slider_content' ); ?>>
									<div class="swiper-wrapper">
									<?php foreach ( $posts as $index => $item ) : ?>
										<?php
											$this->add_render_attribute(
												'linkAtts' . $index,
												array(
													'class' => array( 'slider__link' ),
													'href' => $item['permalink'],
												)
											);

											if ( ! empty( $item['title'] ) ) {
												$this->add_render_attribute( 'linkAtts' . $index, 'aria-label', $item['title'] );
											}

											if ( $settings['transition_text_enabled'] ) {
												$this->add_render_attribute( 'linkAtts' . $index, 'data-pjax-link', 'flyingHeading' );
											}

											if ( array_key_exists( 'permalink_is_external', $item ) && ! ! $item['permalink_is_external'] ) {
												$this->add_render_attribute( 'linkAtts' . $index, 'target', '_blank' );
											}

											if ( array_key_exists( 'permalink_nofollow', $item ) && ! ! $item['permalink_nofollow'] ) {
												$this->add_render_attribute( 'linkAtts' . $index, 'rel', 'nofollow' );
											}
										?>
											<div class="swiper-slide slider-halfscreen__content-slide">
												<div class="slider-halfscreen__content-inner">
													<header class="slider-halfscreen__header">
														<?php if ( $settings['enable_categories'] && ! empty( $item['categories_names'] ) ) : ?>
															<div <?php $this->print_render_attribute_string( 'category' ); ?>><?php echo implode( '&nbsp;&nbsp;/&nbsp;&nbsp;', $item['categories_names'] ); ?></div>
														<?php endif; ?>
														<a <?php $this->print_render_attribute_string( 'linkAtts' . $index ); ?>>
															<<?php echo $settings['heading_tag']; ?> <?php $this->print_render_attribute_string( 'heading' ); ?>><?php echo $item['title']; ?></<?php echo $settings['heading_tag']; ?>>
														</a>
													</header>
													<?php if ( $settings['enable_subheadings'] && ! empty( $item['subheading'] ) ) : ?>
														<div <?php $this->print_render_attribute_string( 'subheading' ); ?>><p><?php echo $item['subheading']; ?></p></div>
													<?php endif; ?>
													<?php if ( ! empty( $settings['button_text'] ) ) : ?>
														<div class="slider-halfscreen__wrapper-button slider-fullscreen__wrapper-button slider__wrapper-button">
															<?php if ( $settings['button_type'] == 'button' ) : ?>
																<?php
																	$this->add_render_attribute(
																		'button' . $index,
																		array(
																			'class' => array(
																				'button',
																				'button_icon',
																				$settings['button_color'],
																			),
																			'href' => $item['permalink'],
																		)
																	);

																if ( $settings['transition_text_enabled'] ) {
																	$this->add_render_attribute( 'button' . $index, 'data-pjax-link', 'flyingHeading' );
																}

																if ( array_key_exists( 'permalink_is_external', $item ) && ! ! $item['permalink_is_external'] ) {
																	$this->add_render_attribute( 'button' . $index, 'target', '_blank' );
																}

																if ( array_key_exists( 'permalink_nofollow', $item ) && ! ! $item['permalink_nofollow'] ) {
																	$this->add_render_attribute( 'button' . $index, 'rel', 'nofollow' );
																}
																?>
																<a <?php $this->print_render_attribute_string( 'button' . $index ); ?>>
																	<div class="button__label"><?php echo $settings['button_text']; ?></div>
																	<div class="button__icon"><i class="material-icons">keyboard_arrow_right</i></div>
																</a>
															<?php endif; ?>
															<?php if ( $settings['button_type'] == 'link' ) : ?>
																<?php
																	$this->add_render_attribute(
																		'button_link' . $index,
																		array(
																			'class' => array( 'link-arrow' ),
																			'href' => $item['permalink'],
																		)
																	);

																if ( $settings['transition_text_enabled'] ) {
																	$this->add_render_attribute( 'button_link' . $index, 'data-pjax-link', 'flyingHeading' );
																}

																if ( array_key_exists( 'permalink_is_external', $item ) && ! ! $item['permalink_is_external'] ) {
																	$this->add_render_attribute( 'button_link' . $index, 'target', '_blank' );
																}

																if ( array_key_exists( 'permalink_nofollow', $item ) && ! ! $item['permalink_nofollow'] ) {
																	$this->add_render_attribute( 'button_link' . $index, 'rel', 'nofollow' );
																}
																?>
																<a <?php $this->print_render_attribute_string( 'button_link' . $index ); ?>>
																	<div class="link-arrow__label"><?php echo $settings['button_text']; ?></div>
																	<div class="link-arrow__icon material-icons">keyboard_arrow_right</div>
																</a>
															<?php endif; ?>
														</div>
													<?php endif; ?>
												</div>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
								<!-- - slider content -->
							</div>
							<div <?php $this->print_render_attribute_string( 'col_images' ); ?>>
								<div <?php $this->print_render_attribute_string( 'slider_images' ); ?>>
									<div class="swiper-wrapper">
										<?php foreach ( $posts as $item ) : ?>
											<?php
												$img    = '';
												$path   = '';
												$srcset = '';
												$sizes  = '';
												$alt    = '';

												$this->add_render_attribute(
													'image' . $item['id'],
													array(
														'class' => array( 'slider__bg', 'of-cover' ),
													)
												);

											if ( $settings['image_type'] === 'primary' ) {

												$path   = wp_get_attachment_image_src( $item['image_id'], $settings['image_size'] );
												$srcset = wp_get_attachment_image_srcset( $item['image_id'], $settings['image_size'] );
												$sizes  = wp_get_attachment_image_sizes( $item['image_id'], $settings['image_size'] );
												$alt    = get_post_meta( $item['image_id'], '_wp_attachment_image_alt', true );

												if ( is_array( $path ) && $path[1] && $path[2] ) {
													$this->add_render_attribute(
														'image' . $item['id'],
														array(
															'data-aspect-ratio' => $path[1] / $path[2],
														)
													);
												}

												$img = is_array( $path ) ? $path[0] : null;

											} else {

												if ( $item['image_secondary_id'] ) {

													$path   = wp_get_attachment_image_src( $item['image_secondary_id'], $settings['image_size'] );
													$srcset = wp_get_attachment_image_srcset( $item['image_secondary_id'], $settings['image_size'] );
													$sizes  = wp_get_attachment_image_sizes( $item['image_secondary_id'], $settings['image_size'] );
													$alt    = get_post_meta( $item['image_secondary_id'], '_wp_attachment_image_alt', true );

													if ( $path[1] && $path[2] ) {
														$this->add_render_attribute(
															'image' . $item['id'],
															array(
																'data-aspect-ratio' => $path[1] / $path[2],
															)
														);
													}

													$img = is_array( $path ) ? $path[0] : null;

												} else {

													$path   = wp_get_attachment_image_src( $item['image_id'], $settings['image_size'] );
													$srcset = wp_get_attachment_image_srcset( $item['image_id'], $settings['image_size'] );
													$sizes  = wp_get_attachment_image_sizes( $item['image_id'], $settings['image_size'] );
													$alt    = get_post_meta( $item['image_id'], '_wp_attachment_image_alt', true );

													if ( $path[1] && $path[2] ) {
														$this->add_render_attribute(
															'image' . $item['id'],
															array(
																'data-aspect-ratio' => $path[1] / $path[2],
															)
														);
													}

													$img = is_array( $path ) ? $path[0] : null;

												}
											}

											if ( $img ) {
												if ( $settings['transition_effect'] !== 'distortion' ) {
													$this->add_render_attribute(
														'image' . $item['id'],
														array(
															'class' => array( 'swiper-lazy' ),
															'data-src' => $img,
															'data-srcset' => $srcset,
															'data-sizes' => $sizes,
															'alt' => $alt,
														)
													);
												} else {
													$this->add_render_attribute(
														'image' . $item['id'],
														array(
															'src' => $img,
															'srcset' => $srcset,
															'sizes' => $sizes,
															'alt' => $alt,
														)
													);
												}
											}

											?>
											<div class="swiper-slide slider__images-slide">
												<div class="slider__images-slide-inner">
													<?php if ( $settings['enable_video'] && $item['video'] && $settings['transition_effect'] !== 'distortion' ) : ?>
														<video class="slider__bg of-cover" src="<?php echo esc_url( $item['video'] ); ?>" poster="<?php echo esc_url( $img ); ?>" playsinline loop muted autoplay></video>
													<?php else : ?>
														<img <?php $this->print_render_attribute_string( 'image' . $item['id'] ); ?> />
													<?php endif; ?>
												</div>
											</div>
										<?php endforeach; ?>
									</div>
									<?php if ( $settings['transition_effect'] == 'distortion' ) : ?>
										<div class="slider__wrapper-canvas">
											<canvas class="slider__canvas"></canvas>
										</div>
									<?php endif; ?>
								</div>
								<!-- - slider images -->
							</div>
						</div>
					</div>
					<div <?php $this->print_render_attribute_string( 'wrapper_footer' ); ?>>
						<div class="container-fluid">
							<div class="row <?php echo $settings['controls_position']; ?>">
								<?php if ( $settings['enable_navigation'] ) : ?>
									<div class="col-auto text-left slider__footer-col">
										<div class="slider__arrows slider-halfscreen__arrows">
											<div class="slider__arrow slider-halfscreen__arrow_prev js-slider-fullscreen__prev"><i class="material-icons"><?php echo $icon_prev; ?></i></div>
											<div class="slider__arrows-divider"></div>
											<div class="slider__arrow slider-halfscreen__arrow_next js-slider-fullscreen__next"><i class="material-icons"><?php echo $icon_next; ?></i></div>
										</div>
									</div>
									<!-- - slider nav arrows -->
								<?php endif; ?>
								<?php if ( $settings['enable_dots'] ) : ?>
									<div class="col-auto text-center slider__footer-col">
										<div class="slider__dots js-slider-dots">
											<div class="slider__dot slider__dot_active">
												<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
													<g fill="none" fill-rule="evenodd">
														<g transform="translate(-134.000000, -98.000000)">
															<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
														</g>
													</g>
												</svg>
											</div>
										</div>
									</div>
									<!-- - slider nav dots -->
								<?php endif; ?>
								<div class="col-auto text-right slider__footer-col <?php echo $settings['enable_counter'] ? '' : 'hidden_absolute'; ?>">
									<div class="slider__progress">
										<div class="swiper swiper-container slider__counter slider__counter_current js-slider-fullscreen__counter-current">
											<div class="swiper-wrapper"></div>
										</div>
										<div class="slider__counter-divider"></div>
										<div class="slider__counter slider__counter_total js-slider-fullscreen__counter-total">001</div>
									</div>
								</div>
								<!-- - slider counter -->
							</div>
						</div>
					</div>
					<!-- - slider footer (controls) -->
				</div>
			</div>
		</div>

		<?php
	}
}
