<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Content_Block extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-content-block';
	}

	public function get_title() {
		return esc_html__( 'Content Block', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'heading',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Header', 'cassio' ) ),
					'editor_type' => 'VISUAL',
				),
				array(
					'field'       => 'content_1',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Column 1', 'cassio' ) ),
					'editor_type' => 'VISUAL',
				),
				array(
					'field'       => 'content_2',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Column 2', 'cassio' ) ),
					'editor_type' => 'VISUAL',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'header_section',
			array(
				'label' => esc_html__( 'Header', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'heading',
			array(
				'type'        => Controls_Manager::WYSIWYG,
				'description' => sprintf(
					'%1s <ul><li><strong>%2s</strong></li><strong>%3s</strong></li></ul> %4s',
					esc_html__( 'To override the font weight, please use', 'cassio' ),
					esc_html( 'heading-light' ),
					esc_html( 'heading-bold' ),
					esc_html__( 'helper classes for the elements in editor "Text" tab' )
				),
				'default'     => esc_html__( 'The heading...', 'cassio' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'heading_content_1',
			array(
				'label'      => esc_html__( 'Column 1', 'cassio' ),
				'type'       => Controls_Manager::HEADING,
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'layout',
							'operator' => '==',
							'value'    => 'columns_1_2',
						),
						array(
							'name'     => 'layout',
							'operator' => '==',
							'value'    => 'columns_1_3',
						),
					),
				),
			)
		);

		$this->add_control(
			'content_1',
			array(
				'type'        => Controls_Manager::WYSIWYG,
				'description' => sprintf(
					'%1s <ul><li><strong>%2s</strong></li><strong>%3s</strong></li></ul> %4s',
					esc_html__( 'To override the font weight, please use', 'cassio' ),
					esc_html( 'heading-light' ),
					esc_html( 'heading-bold' ),
					esc_html__( 'helper classes for the elements in editor "Text" tab' )
				),
				'default'     => esc_html__( 'The content...', 'cassio' ),
			)
		);

		$this->add_control(
			'heading_content_2',
			array(
				'label'      => esc_html__( 'Column 2', 'cassio' ),
				'type'       => Controls_Manager::HEADING,
				'separator'  => 'before',
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'layout',
							'operator' => '==',
							'value'    => 'columns_1_2',
						),
						array(
							'name'     => 'layout',
							'operator' => '==',
							'value'    => 'columns_1_3',
						),
					),
				),
			)
		);

		$this->add_control(
			'content_2',
			array(
				'type'        => Controls_Manager::WYSIWYG,
				'description' => sprintf(
					'%1s <ul><li><strong>%2s</strong></li><strong>%3s</strong></li></ul> %4s',
					esc_html__( 'To override the font weight, please use', 'cassio' ),
					esc_html( 'heading-light' ),
					esc_html( 'heading-bold' ),
					esc_html__( 'helper classes for the elements in editor "Text" tab' )
				),
				'default'     => esc_html__( 'The content...', 'cassio' ),
				'conditions'  => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'layout',
							'operator' => '==',
							'value'    => 'columns_1_2',
						),
						array(
							'name'     => 'layout',
							'operator' => '==',
							'value'    => 'columns_1_3',
						),
					),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

		$this->add_control(
			'layout',
			array(
				'label'   => esc_html__( 'Content Layout', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => array(
					'columns'     => esc_html__( '2 Columns', 'cassio' ),
					'columns_1_2' => esc_html__( '1 Column / 2 Columns', 'cassio' ),
					'columns_1_3' => esc_html__( '1 Column / Line + 2 Columns', 'cassio' ),
					'stack'       => esc_html__( 'Stack', 'cassio' ),
				),
				'default' => 'columns',
			)
		);

		$this->add_control(
			'heading_layout_header',
			array(
				'label'     => esc_html__( 'Header', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'header_position',
			array(
				'label'   => esc_html__( 'Header Position', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'justify-content-start'   => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-h-align-left',
					),
					'justify-content-center'  => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-h-align-center',
					),
					'justify-content-end'     => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-h-align-right',
					),
					'justify-content-between' => array(
						'title' => esc_html__( 'Space Between', 'cassio' ),
						'icon'  => 'eicon-h-align-stretch',
					),
				),
				'default' => 'justify-content-between',
			)
		);

		$this->add_control(
			'header_col',
			array(
				'label'   => esc_html__( 'Header Proportions', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'col-lg-5',
				'options' => array(
					'col-lg-4'  => esc_html__( '4 Columns (33%)', 'cassio' ),
					'col-lg-5'  => esc_html__( '5 Columns (41%)', 'cassio' ),
					'col-lg-6'  => esc_html__( '6 Columns (50%)', 'cassio' ),
					'col-lg-7'  => esc_html__( '7 Columns (58%)', 'cassio' ),
					'col-lg-8'  => esc_html__( '8 Columns (66%)', 'cassio' ),
					'col-lg-9'  => esc_html__( '9 Columns (75%)', 'cassio' ),
					'col-lg-10' => esc_html__( '10 Columns (83%)', 'cassio' ),
					'col-lg-11' => esc_html__( '11 Columns (92%)', 'cassio' ),
					'col-lg-12' => esc_html__( '12 Columns (100%)', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'enable_headline',
			array(
				'label'   => esc_html__( 'Show Headline', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'headline_position',
			array(
				'label'     => esc_html__( 'Headline Position', 'cassio' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'mr-auto text-left'   => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-h-align-left',
					),
					'mx-auto text-center' => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-h-align-center',
					),
					'ml-auto text-right'  => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'default'   => 'mr-auto text-left',
				'condition' => array(
					'enable_headline' => 'yes',
				),
			)
		);

		$this->add_control(
			'heading_layout_content',
			array(
				'label'     => esc_html__( 'Content', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'content_position',
			array(
				'label'   => esc_html__( 'Content Position', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'justify-content-start'   => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-h-align-left',
					),
					'justify-content-center'  => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-h-align-center',
					),
					'justify-content-end'     => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-h-align-right',
					),
					'justify-content-between' => array(
						'title' => esc_html__( 'Space Between', 'cassio' ),
						'icon'  => 'eicon-h-align-stretch',
					),
				),
				'default' => 'justify-content-between',
			)
		);

		$this->add_control(
			'content_col',
			array(
				'label'   => esc_html__( 'Content Proportions', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'col-lg-5',
				'options' => array(
					'col-lg-4'  => esc_html__( '4 Columns (33%)', 'cassio' ),
					'col-lg-5'  => esc_html__( '5 Columns (41%)', 'cassio' ),
					'col-lg-6'  => esc_html__( '6 Columns (50%)', 'cassio' ),
					'col-lg-7'  => esc_html__( '7 Columns (58%)', 'cassio' ),
					'col-lg-8'  => esc_html__( '8 Columns (66%)', 'cassio' ),
					'col-lg-9'  => esc_html__( '9 Columns (75%)', 'cassio' ),
					'col-lg-10' => esc_html__( '10 Columns (83%)', 'cassio' ),
					'col-lg-11' => esc_html__( '11 Columns (92%)', 'cassio' ),
					'col-lg-12' => esc_html__( '12 Columns (100%)', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => esc_html__( 'Animation', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'   => esc_html__( 'Enable on-scroll animation', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'section', 'class', array( 'section', 'section-content', 'section-content_' . $settings['layout'] ) );
		$this->add_render_attribute( 'col_header', 'class', array( 'col-12', 'section-content__header' ) );
		$this->add_render_attribute( 'col_content_1', 'class', array( 'col-12', 'section-content__content' ) );
		$this->add_render_attribute( 'col_content_2', 'class', array( 'col-12', 'section-content__content' ) );

		if ( $settings['enable_animation'] ) {
			$this->add_render_attribute( 'section', 'data-os-animation' );
			$this->add_render_attribute(
				'heading',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);

			$this->add_render_attribute(
				'content_1',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);

			$this->add_render_attribute(
				'content_2',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);
		}

		$this->add_render_attribute( 'col_header', 'class', $settings['header_col'] );
		$this->add_render_attribute( 'col_content_1', 'class', $settings['content_col'] );

		if ( $settings['layout'] == 'columns_1_2' ) {
			$this->add_render_attribute( 'col_header', 'class', 'section-content__header_mb' );
			$this->add_render_attribute( 'col_content_1', 'class', $settings['content_col'] );
			$this->add_render_attribute( 'col_content_2', 'class', $settings['content_col'] );
		}

		if ( $settings['layout'] == 'columns_1_3' ) {
			$this->add_render_attribute( 'col_header', 'class', 'section-content__header_mb' );
			$this->add_render_attribute( 'col_content_1', 'class', $settings['content_col'] );
			$this->add_render_attribute( 'col_content_2', 'class', $settings['content_col'] );
		}

		$this->add_inline_editing_attributes( 'heading' );
		$this->add_inline_editing_attributes( 'content_1' );
		$this->add_inline_editing_attributes( 'content_2' );

		if ( $settings['enable_headline'] ) {

			$this->add_render_attribute( 'section', 'class', array( 'section-content_has-headline' ) );

			$this->add_render_attribute(
				'headline',
				array(
					'class' => array( 'section__headline', 'section-content__headline', $settings['headline_position'] ),
				)
			);

		}
		?>
		<div <?php $this->print_render_attribute_string( 'section' ); ?>>
			<div class="row <?php echo esc_attr( $settings['content_position'] ); ?>">
				<div <?php $this->print_render_attribute_string( 'col_header' ); ?>>
					<div <?php $this->print_render_attribute_string( 'heading' ); ?>><?php echo $settings['heading']; ?></div>
					<?php if ( $settings['enable_headline'] && $settings['layout'] != 'columns_1_3' ) : ?>
						<div <?php $this->print_render_attribute_string( 'headline' ); ?>></div>
					<?php endif; ?>
				</div>
				<?php if ( $settings['layout'] != 'columns' ) : ?>
					<div class="w-100"></div>
				<?php endif; ?>
				<?php if ( $settings['layout'] == 'columns_1_3' && $settings['enable_headline'] ) : ?>
					<div class="col-lg-2 section-content__content">
						<div <?php $this->print_render_attribute_string( 'headline' ); ?>></div>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $settings['content_1'] ) ) : ?>
					<div <?php $this->print_render_attribute_string( 'col_content_1' ); ?>>
						<div <?php $this->print_render_attribute_string( 'content_1' ); ?>><?php echo $settings['content_1']; ?></div>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $settings['content_2'] ) && ( $settings['layout'] == 'columns_1_2' || $settings['layout'] == 'columns_1_3' ) ) : ?>
					<div <?php $this->print_render_attribute_string( 'col_content_2' ); ?>>
						<div <?php $this->print_render_attribute_string( 'content_2' ); ?>><?php echo $settings['content_2']; ?></div>
					</div>
				<?php endif; ?>
			</div>
		</div>

		<?php
	}
}
