<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Logo_Clients extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-logo-clients';
	}

	public function get_title() {
		return esc_html__( 'Logo Clients', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Logos', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'images',
			array(
				'type'    => Controls_Manager::GALLERY,
				'default' => array(),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);

		$this->add_control(
			'content_position',
			array(
				'label'   => esc_html__( 'Position', 'cassio' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
					'justify-content-start'   => array(
						'title' => esc_html__( 'Left', 'cassio' ),
						'icon'  => 'eicon-h-align-left',
					),
					'justify-content-center'  => array(
						'title' => esc_html__( 'Center', 'cassio' ),
						'icon'  => 'eicon-h-align-center',
					),
					'justify-content-end'     => array(
						'title' => esc_html__( 'Right', 'cassio' ),
						'icon'  => 'eicon-h-align-right',
					),
					'justify-content-between' => array(
						'title' => esc_html__( 'Space Between', 'cassio' ),
						'icon'  => 'eicon-h-align-stretch',
					),
				),
				'default' => 'justify-content-between',
			)
		);

		$this->add_responsive_control(
			'col',
			array(
				'label'              => esc_html__( 'Items per Row', 'cassio' ),
				'type'               => Controls_Manager::SELECT,
				'options'            => array(
					2  => esc_html__( '6 Items', 'cassio' ),
					3  => esc_html__( '4 Items', 'cassio' ),
					4  => esc_html__( '3 Items', 'cassio' ),
					6  => esc_html__( '2 Items', 'cassio' ),
					12 => esc_html__( '1 Item', 'cassio' ),
				),
				'render_type'        => 'template',
				'default'            => 4,
				'desktop_default'    => 4,
				'tablet_default'     => 6,
				'mobile_default'     => 12,
				'frontend_available' => true,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			array(
				'label' => esc_html__( 'Style', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'height',
			array(
				'label'              => esc_html__( 'Maximum Logos Height', 'cassio' ),
				'type'               => Controls_Manager::SLIDER,
				'size_units'         => array( 'px' ),
				'range'              => array(
					'px' => array(
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					),
				),
				'devices'            => array( 'desktop', 'tablet', 'mobile' ),
				'default'            => array(
					'size' => 100,
					'unit' => 'px',
				),
				'desktop_default'    => array(
					'size' => 100,
					'unit' => 'px',
				),
				'tablet_default'     => array(
					'size' => 100,
					'unit' => 'px',
				),
				'mobile_default'     => array(
					'size' => 100,
					'unit' => 'px',
				),
				'selectors'          => array(
					'{{WRAPPER}} .aside-logos__wrapper-logo img' => 'height: {{SIZE}}{{UNIT}};',
				),
				'frontend_available' => true,
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$columns_desktop = array_key_exists( 'col', $settings ) ? $settings['col'] : 12;
		$columns_tablet  = array_key_exists( 'col_tablet', $settings ) ? $settings['col_tablet'] : 12;
		$columns_mobile  = array_key_exists( 'col_mobile', $settings ) ? $settings['col_mobile'] : 12;

		$col_desktop = 'col-lg-' . $this->translate_columns_settings_inverse( $columns_desktop );
		$col_tablet  = 'col-sm-' . $this->translate_columns_settings_inverse( $columns_tablet );
		$col_mobile  = 'col-' . $this->translate_columns_settings_inverse( $columns_mobile );

		$this->add_render_attribute(
			'row',
			array(
				'class' => array( 'row', 'align-items-center', $settings['content_position'] ),
			)
		);

		$this->add_render_attribute(
			'col',
			array(
				'class' => array( 'aside-logos__col', $col_desktop, $col_tablet, $col_mobile ),
			)
		);

		?>

		<?php if ( ! empty( $settings['images'] ) ) : ?>
			<div class="aside aside-logos section">
				<div <?php $this->print_render_attribute_string( 'row' ); ?>>
					<?php foreach ( $settings['images'] as $index => $image ) : ?>
						<?php
							$img = wp_get_attachment_image_src( $image['id'], 'full' );

							$this->add_render_attribute(
								'wrapper',
								array(
									'class' => 'lazy',
									'style' => 'padding-bottom: calc( (' . $img[2] . '/' . $img[1] . ') * 100% ); height: 0;',
								),
								true,
								true
							);

							$this->add_render_attribute(
								'img',
								array(
									'src'    => $img[0],
									'width'  => $img[1],
									'height' => $img[2],
									'alt'    => '',
								),
								true,
								true
							);
						?>
						<div <?php $this->print_render_attribute_string( 'col' ); ?>>
							<div class="aside-logos__wrapper-logo">
								<img <?php $this->print_render_attribute_string( 'img' ); ?>>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		<?php endif; ?>

		<?php
	}
}
