<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Project_Properties extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-project-properties';
	}

	public function get_title() {
		return esc_html__( 'Project Properties', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {

		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions'        => array( 'widgetType' => $name ),
			'fields'            => array(),
			'integration-class' => 'WPML_Elementor_Cassio_Widget_Project_Properties',
		);

		return $widgets;

	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'option',
			array(
				'label'       => esc_html__( 'Option', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
			)
		);

		$repeater->add_control(
			'value',
			array(
				'label'       => esc_html__( 'Value', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
			)
		);

		$this->add_control(
			'properties',
			array(
				'type'          => Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ option || value }}}',
				'prevent_empty' => false,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_section',
			array(
				'label' => esc_html__( 'Layout', 'cassio' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			)
		);
		/**
		 * Columns
		 */
		$selector_value_string = 'flex: 0 0 calc({{VALUE}} / 12  * 100%); max-width: calc({{VALUE}} / 12 * 100%);';
		$this->add_responsive_control(
			'columns',
			array(
				'label'              => esc_html__( 'Columns', 'cassio' ),
				'type'               => Controls_Manager::SELECT,
				'options'            => array(
					3  => esc_html__( 'Four Columns', 'cassio' ),
					4  => esc_html__( 'Three Columns', 'cassio' ),
					6  => esc_html__( 'Two Columns', 'cassio' ),
					12 => esc_html__( 'Single Column', 'cassio' ),
				),
				'selectors'          => array(
					'{{WRAPPER}} .section-properties__item' => $selector_value_string,
				),
				'render_type'        => 'template',
				'default'            => 4,
				'desktop_default'    => 4,
				'tablet_default'     => 6,
				'mobile_default'     => 12,
				'frontend_available' => true,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'animation_section',
			array(
				'label' => esc_html__( 'Animation', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'enable_animation',
			array(
				'label'   => esc_html__( 'Enable on-scroll animation', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$columns_desktop = array_key_exists( 'columns', $settings ) ? $settings['columns'] : 12;
		$columns_tablet  = array_key_exists( 'columns_tablet', $settings ) ? $settings['columns_tablet'] : 12;
		$columns_mobile  = array_key_exists( 'columns_mobile', $settings ) ? $settings['columns_mobile'] : 12;

		$col_desktop = 'col-lg-' . $this->translate_columns_settings_inverse( $columns_desktop );
		$col_tablet  = 'col-sm-' . $this->translate_columns_settings_inverse( $columns_tablet );
		$col_mobile  = 'col-' . $this->translate_columns_settings_inverse( $columns_mobile );

		$this->add_render_attribute(
			'section',
			array(
				'class' => array( 'section', 'section-properties' ),
			)
		);

		$this->add_render_attribute(
			'option',
			array(
				'class' => array( 'figure-info__option' ),
			)
		);

		$this->add_render_attribute(
			'value',
			array(
				'class' => array( 'figure-info__value' ),
			)
		);

		$this->add_render_attribute(
			'column',
			array(
				'class' => array( 'section-properties__item', $col_desktop, $col_tablet, $col_mobile ),
			)
		);

		if ( $settings['enable_animation'] ) {

			$this->add_render_attribute(
				'section',
				array(
					'data-os-animation' => 'data-os-animation',
				)
			);
			$this->add_render_attribute(
				'option',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);
			$this->add_render_attribute(
				'value',
				array(
					'class'                => array( 'split-text', 'js-split-text' ),
					'data-split-text-type' => 'lines',
					'data-split-text-set'  => 'lines',
				)
			);

		}

		?>

		<?php if ( ! empty( $settings['properties'] ) ) : ?>
			<div <?php $this->print_render_attribute_string( 'section' ); ?>>
				<div class="row">
					<?php foreach ( $settings['properties'] as $index => $item ) : ?>
						<?php
							$keyOption = $this->get_repeater_setting_key( 'option', 'properties', $index );
							$keyValue  = $this->get_repeater_setting_key( 'value', 'properties', $index );
							$this->add_inline_editing_attributes( $keyOption );
							$this->add_inline_editing_attributes( $keyValue );
						?>
						<div <?php $this->print_render_attribute_string( 'column' ); ?>>
							<div class="figure-info">
								<div <?php $this->print_render_attribute_string( 'option' ); ?>>
									<span <?php $this->print_render_attribute_string( $keyOption ); ?>><?php echo $item['option']; ?></span>
								</div>
								<div <?php $this->print_render_attribute_string( 'value' ); ?>>
									<span <?php $this->print_render_attribute_string( $keyValue ); ?>><?php echo $item['value']; ?></span>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		<?php endif; ?>

		<?php
	}

	protected function content_template() {
		?>

		<#
			view.addRenderAttribute(
				'section', {
					'class': [ 'section', 'section-properties', 'section_container-paddings' ],
				}
			);

			var class_lg = settings.columns ? 'col-lg-' + settings.columns : '';
			var class_sm = settings.columns_tablet ? 'col-sm-' + settings.columns_tablet : '';
			var class_xs = settings.columns_mobile ? 'col-' + settings.columns_mobile : '';

			view.addRenderAttribute(
				'column', {
					'class': [ 'section-properties__item', class_lg, class_sm, class_xs ],
				}
			);
		#>

		<# if (settings.properties.length ) { #>
			<div {{{ view.getRenderAttributeString( 'section' ) }}}>
				<div class="row">
					<# _.each( settings.properties, function(item, index) { #>
						<#
							var keyOption = view.getRepeaterSettingKey( 'option', 'properties', index );
							var keyValue = view.getRepeaterSettingKey( 'value', 'properties', index );
							view.addInlineEditingAttributes( keyOption );
							view.addInlineEditingAttributes( keyValue );
						#>
						<div {{{ view.getRenderAttributeString( 'column' ) }}}>
							<div class="figure-info">
								<div class="figure-info__option">
									<span {{{ view.getRenderAttributeString( keyOption ) }}}>{{{ item.option }}}</span>
								</div>
								<div class="figure-info__value">
									<span {{{ view.getRenderAttributeString( keyValue ) }}}>{{{ item.value }}}</span>
								</div>
							</div>
						</div>
					<# }); #>
				</div>
			</div>
		<# } #>

		<?php
	}
}
