<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Slider_Testimonials extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-slider-testimonials';
	}

	public function get_title() {
		return esc_html__( 'Slider Testimonials', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function get_script_depends() {
		return array( 'swiper' );
	}

	public function get_style_depends() {
		return array( 'swiper' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {

		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions'        => array( 'widgetType' => $name ),
			'fields'            => array(),
			'integration-class' => 'WPML_Elementor_Cassio_Widget_Slider_Testimonials',
		);

		return $widgets;

	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'author',
			array(
				'label'       => esc_html__( 'Author', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Author...', 'cassio' ),
			)
		);

		$repeater->add_control(
			'text',
			array(
				'label'       => esc_html__( 'Text', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__( 'Text...', 'cassio' ),
			)
		);

		$this->add_control(
			'testimonials',
			array(
				'type'          => Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ author }}}',
				'prevent_empty' => false,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_section',
			array(
				'label' => esc_html__( 'Slider', 'cassio' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			)
		);

		$this->add_control(
			'enable_autoplay',
			array(
				'label'   => esc_html__( 'Enable Autoplay', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'autoplay_delay',
			array(
				'label'     => esc_html__( 'Autoplay Delay (ms)', 'cassio' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'ms' => array(
						'min'  => 1000,
						'max'  => 60000,
						'step' => 100,
					),
				),
				'default'   => array(
					'unit' => 'ms',
					'size' => 6000,
				),
				'condition' => array(
					'enable_autoplay' => 'yes',
				),
			)
		);

		$this->add_control(
			'speed',
			array(
				'label'   => esc_html__( 'Speed', 'cassio' ),
				'type'    => Controls_Manager::SLIDER,
				'range'   => array(
					'ms' => array(
						'min'  => 100,
						'max'  => 10000,
						'step' => 100,
					),
				),
				'default' => array(
					'unit' => 'ms',
					'size' => 1200,
				),
			)
		);

		$this->add_control(
			'heading_controls',
			array(
				'label'     => esc_html__( 'Controls', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'controls_position',
			array(
				'label'   => esc_html__( 'Position', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'justify-content-between no-gutters',
				'options' => array(
					'justify-content-between no-gutters' => esc_html__( 'Space Between', 'cassio' ),
					'justify-content-center'             => esc_html__( 'Center', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'enable_navigation',
			array(
				'label'   => esc_html__( 'Enable Navigation Arrows', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'enable_dots',
			array(
				'label'   => esc_html__( 'Enable Dots', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'enable_counter',
			array(
				'label'   => esc_html__( 'Enable Counter', 'cassio' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		$this->add_control(
			'counter_zeros',
			array(
				'label'     => esc_html__( 'Counter Prefix', 'cassio' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 2,
				'options'   => array(
					0 => esc_html__( 'None', 'cassio' ),
					1 => esc_html__( '1 Zero', 'cassio' ),
					2 => esc_html__( '2 Zeros', 'cassio' ),
				),
				'condition' => array(
					'enable_counter' => 'yes',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			array(
				'label' => esc_html__( 'Typography', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'text_size',
			array(
				'label'   => esc_html__( 'Text Size', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h4',
				'options' => array(
					'h1'       => esc_html__( 'H1', 'cassio' ),
					'h2'       => esc_html__( 'H2', 'cassio' ),
					'h3'       => esc_html__( 'H3', 'cassio' ),
					'h4'       => esc_html__( 'H4', 'cassio' ),
					'h5'       => esc_html__( 'H5', 'cassio' ),
					'h6'       => esc_html__( 'H6', 'cassio' ),
					'text-xl'  => esc_html__( 'XL', 'cassio' ),
					'text-xxl' => esc_html__( 'XXL', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'text_weight',
			array(
				'label'   => esc_html__( 'Text Weight', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''              => esc_html__( 'Auto', 'cassio' ),
					'heading-light' => esc_html__( 'Normal', 'cassio' ),
					'heading-bold'  => esc_html__( 'Bold', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute(
			'slider',
			array(
				'class'              => array( 'section', 'section-testimonials', 'section_container-paddings', 'swiper', 'swiper-container', 'slider', 'slider-testimonials', 'js-slider-testimonials' ),
				'data-counter-zeros' => $settings['counter_zeros'],
			)
		);

		if ( $settings['enable_autoplay'] ) {
			$this->add_render_attribute(
				'slider',
				array(
					'data-autoplay-enabled' => 'true',
					'data-autoplay-delay'   => $settings['autoplay_delay']['size'],
				)
			);
		}

		?>

		<div <?php $this->print_render_attribute_string( 'slider' ); ?>>
			<div class="swiper-wrapper">
				<?php foreach ( $settings['testimonials'] as $index => $item ) : ?>
					<?php
						$authorKey = $this->get_repeater_setting_key( 'author', 'testimonials', $index );
						$textKey   = $this->get_repeater_setting_key( 'text', 'testimonials', $index );

						$this->add_inline_editing_attributes( $authorKey );
						$this->add_inline_editing_attributes( $textKey );

						$this->add_render_attribute(
							$textKey,
							array(
								'class'                => array( 'slider-testimonials__text', 'split-text', 'js-split-text', $settings['text_size'], $settings['text_weight'] ),
								'data-split-text-type' => 'lines',
								'data-split-text-set'  => 'lines',
							)
						);

						$this->add_render_attribute(
							$authorKey,
							array(
								'class'                => array( 'split-text', 'js-split-text' ),
								'data-split-text-type' => 'lines, words, chars',
								'data-split-text-set'  => 'chars',
							)
						);

					?>
					<div class="swiper-slide">
						<div class="slider-testimonials__inner">
							<div <?php $this->print_render_attribute_string( $textKey ); ?>><?php echo $item['text']; ?></div>
							<?php if ( ! empty( $item['author'] ) ) : ?>
								<div class="slider-testimonials__author">
									<div class="slider-testimonials__author-line"></div>
									<span <?php $this->print_render_attribute_string( $authorKey ); ?>><?php echo $item['author']; ?></span>
								</div>
							<?php endif; ?>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
			<?php if ( $settings['enable_navigation'] || $settings['enable_dots'] || $settings['enable_counter'] ) : ?>
				<div class="row slider__footer-relative slider-testimonials__footer js-slider-testimonials__footer <?php echo $settings['controls_position']; ?>">
					<div class="slider-testimonials__footer-line"></div>
					<?php if ( $settings['enable_navigation'] ) : ?>
						<div class="col-auto slider__footer-col">
							<div class="slider__arrows">
								<div class="slider__arrow js-slider-testimonials__prev"><i class="material-icons">keyboard_arrow_left</i></div>
								<div class="slider__arrows-divider"></div>
								<div class="slider__arrow js-slider-testimonials__next"><i class="material-icons">keyboard_arrow_right</i></div>
							</div>
						</div>
						<!-- - slider nav arrows -->
					<?php endif; ?>
					<?php if ( $settings['enable_dots'] ) : ?>
						<div class="col-auto slider__footer-col d-none d-md-block">
							<div class="slider__dots js-slider-testimonials__dots">
								<div class="slider__dot slider__dot_active">
									<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
										<g fill="none" fill-rule="evenodd">
											<g transform="translate(-134.000000, -98.000000)">
												<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
											</g>
										</g>
									</svg>
								</div>
							</div>
						</div>
						<!-- - slider nav dots -->
					<?php endif; ?>
					<div class="col-auto slider__footer-col <?php echo $settings['enable_counter'] ? '' : 'hidden_absolute'; ?>">
						<div class="slider__progress">
							<div class="swiper swiper-container slider__counter slider__counter_current js-slider-testimonials__counter-current">
								<div class="swiper-wrapper"></div>
							</div>
							<div class="slider__counter-divider"></div>
							<div class="slider__counter slider__counter_total js-slider-testimonials__counter-total">001</div>
						</div>
					</div>
					<!-- - slider counter -->
				</div>
			<?php endif; ?>
		</div>

		<?php
	}
}
