<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Cassio_Widget_Team_Member extends Arts_Widget_Base {
	protected static $_instance = null;

	public function get_name() {
		return 'cassio-widget-team-member';
	}

	public function get_title() {
		return esc_html__( 'Team Member', 'cassio' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'cassio-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {

		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'name',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Name', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'position',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, esc_html__( 'Position', 'cassio' ) ),
					'editor_type' => 'LINE',
				),
			),
		);

		return $widgets;

	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'Content', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'name',
			array(
				'label'       => esc_html__( 'Name', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Edit name...', 'cassio' ),
			)
		);

		$this->add_control(
			'position',
			array(
				'label'       => esc_html__( 'Position', 'cassio' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Edit position...', 'cassio' ),
			)
		);

		$this->add_control(
			'social_heading',
			array(
				'label'     => esc_html__( 'Social Media', 'cassio' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'social_link',
			array(
				'label'         => esc_html__( 'Link', 'cassio' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://...', 'cassio' ),
				'show_external' => true,
				'default'       => array(
					'is_external' => true,
					'nofollow'    => true,
				),
			)
		);

		$repeater->add_control(
			'social_icon',
			array(
				'label' => esc_html__( 'Icon', 'cassio' ),
				'type'  => Controls_Manager::ICON,
			)
		);

		$this->add_control(
			'social',
			array(
				'type'          => Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ social_icon.replace("fa fa-", "") }}}',
				'prevent_empty' => false,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'avatar_section',
			array(
				'label' => esc_html__( 'Avatar', 'cassio' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'avatar',
			array(
				'label'   => esc_html__( 'Choose Image', 'cassio' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),
			)
		);

		$this->add_control(
			'enable_grayscale',
			array(
				'label'        => esc_html__( 'Enable Grayscale Filter', 'cassio' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'grayscale',
				'default'      => 'grayscale',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => esc_html__( 'Typography', 'cassio' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'heading_tag',
			array(
				'label'   => esc_html__( 'Name HTML Tag', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => array(
					'h2' => esc_html( '<h2>' ),
					'h3' => esc_html( '<h3>' ),
					'h4' => esc_html( '<h4>' ),
					'h5' => esc_html( '<h5>' ),
					'h6' => esc_html( '<h6>' ),
				),
			)
		);

		$this->add_control(
			'heading_size',
			array(
				'label'   => esc_html__( 'Name Size', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h4',
				'options' => array(
					'h1'       => esc_html__( 'H1', 'cassio' ),
					'h2'       => esc_html__( 'H2', 'cassio' ),
					'h3'       => esc_html__( 'H3', 'cassio' ),
					'h4'       => esc_html__( 'H4', 'cassio' ),
					'h5'       => esc_html__( 'H5', 'cassio' ),
					'h6'       => esc_html__( 'H6', 'cassio' ),
					'text-xl'  => esc_html__( 'XL', 'cassio' ),
					'text-xxl' => esc_html__( 'XXL', 'cassio' ),
				),
			)
		);

		$this->add_control(
			'heading_weight',
			array(
				'label'   => esc_html__( 'Name Weight', 'cassio' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''              => esc_html__( 'Auto', 'cassio' ),
					'heading-light' => esc_html__( 'Normal', 'cassio' ),
					'heading-bold'  => esc_html__( 'Bold', 'cassio' ),
				),
			)
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'name' );
		$this->add_inline_editing_attributes( 'position' );

		$this->add_render_attribute( 'item', 'class', 'figure-member' );
		$this->add_render_attribute(
			'name',
			array(
				'class' => array( 'figure-member__name', $settings['heading_size'], $settings['heading_weight'] ),
			)
		);

		if ( $settings['social'] ) {
			$this->add_render_attribute( 'item', 'class', 'figure-member_has-social' );
		}

		?>

		<div <?php $this->print_render_attribute_string( 'item' ); ?>>
			<?php if ( ! empty( $settings['avatar']['url'] ) ) : ?>
				<div class="figure-member__wrapper-img">
					<div class="figure-member__wrapper-img-inner">
						<?php
							arts_the_lazy_image(
								array(
									'id'    => $settings['avatar']['id'],
									'type'  => 'image',
									'class' => array(
										'wrapper' => array( $settings['enable_grayscale'] ),
									),
								)
							);
						?>
						<div <?php $this->print_render_attribute_string( 'wrapper' ); ?>>
							<img <?php $this->print_render_attribute_string( 'img' ); ?>>
						</div>
						<div class="figure-member__curtain"></div>
					</div>
					<?php if ( $settings['social'] ) : ?>
						<div class="figure-member__social">
							<ul class="social">
								<?php foreach ( $settings['social'] as $item ) : ?>
									<li class="social__item">
										<?php
											$target   = $item['social_link']['is_external'] ? ' target="_blank"' : '';
											$nofollow = $item['social_link']['nofollow'] ? ' rel="nofollow"' : '';
										?>
										<a class="<?php echo $item['social_icon']; ?>" href="<?php echo $item['social_link']['url']; ?>" <?php echo $target . ' ' . $nofollow; ?>>
										</a>
									</li>
								<?php endforeach; ?>
							</ul>
						</div>
						<div class="figure-member__line"></div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<?php if ( ! empty( $settings['name'] || ! empty( $settings['position'] ) ) ) : ?>
				<div class="figure-member__content">
					<?php if ( ! empty( $settings['name'] ) ) : ?>
						<<?php echo $settings['heading_tag']; ?> <?php $this->print_render_attribute_string( 'name' ); ?>><?php echo $settings['name']; ?></<?php echo $settings['heading_tag']; ?>>
					<?php endif; ?>
					<?php if ( ! empty( $settings['position'] ) ) : ?>
						<div class="figure-member__position">
							<span <?php $this->print_render_attribute_string( 'position' ); ?>><?php echo $settings['position']; ?></span>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>

		<?php
	}
}
