<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'init', 'arts_register_post_types' );
function arts_register_post_types() {
	$priority = 5;

	/**
	 * Portfolio
	 */
	$labels  = array(
		'name'                  => _x( 'Portfolio Items', 'Post Type General Name', 'cassio' ),
		'singular_name'         => _x( 'Portfolio Item', 'Post Type Singular Name', 'cassio' ),
		'menu_name'             => _x( 'Portfolio Items', 'Admin Menu text', 'cassio' ),
		'name_admin_bar'        => _x( 'Portfolio Item', 'Add New on Toolbar', 'cassio' ),
		'archives'              => esc_html__( 'Portfolio Item Archives', 'cassio' ),
		'attributes'            => esc_html__( 'Portfolio Item Attributes', 'cassio' ),
		'parent_item_colon'     => esc_html__( 'Parent Portfolio Item:', 'cassio' ),
		'all_items'             => esc_html__( 'All Portfolio Items', 'cassio' ),
		'add_new_item'          => esc_html__( 'Add New Portfolio Item', 'cassio' ),
		'add_new'               => esc_html__( 'Add New', 'cassio' ),
		'new_item'              => esc_html__( 'New Portfolio Item', 'cassio' ),
		'edit_item'             => esc_html__( 'Edit Portfolio Item', 'cassio' ),
		'update_item'           => esc_html__( 'Update Portfolio Item', 'cassio' ),
		'view_item'             => esc_html__( 'View Portfolio Item', 'cassio' ),
		'view_items'            => esc_html__( 'View Portfolio Items', 'cassio' ),
		'search_items'          => esc_html__( 'Search Portfolio Item', 'cassio' ),
		'not_found'             => esc_html__( 'Not found', 'cassio' ),
		'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'cassio' ),
		'featured_image'        => esc_html__( 'Featured Image', 'cassio' ),
		'set_featured_image'    => esc_html__( 'Set featured image', 'cassio' ),
		'remove_featured_image' => esc_html__( 'Remove featured image', 'cassio' ),
		'use_featured_image'    => esc_html__( 'Use as featured image', 'cassio' ),
		'insert_into_item'      => esc_html__( 'Insert into Portfolio Item', 'cassio' ),
		'uploaded_to_this_item' => esc_html__( 'Uploaded to this Portfolio Item', 'cassio' ),
		'items_list'            => esc_html__( 'Portfolio Items list', 'cassio' ),
		'items_list_navigation' => esc_html__( 'Portfolio Items list navigation', 'cassio' ),
		'filter_items_list'     => esc_html__( 'Filter Portfolio Items list', 'cassio' ),
	);
	$rewrite = array(
		'slug'       => 'portfolio',
		'with_front' => true,
		'pages'      => true,
		'feeds'      => true,
	);
	$args    = array(
		'label'               => esc_html__( 'Portfolio Item', 'cassio' ),
		'description'         => esc_html__( '', 'cassio' ),
		'labels'              => $labels,
		'menu_icon'           => 'dashicons-art',
		'supports'            => array( 'title', 'thumbnail', 'revisions' ),
		'taxonomies'          => array( 'arts_portfolio_category' ),
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => $priority++,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => false,
		'hierarchical'        => false,
		'exclude_from_search' => false,
		'show_in_rest'        => true,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
		'rewrite'             => $rewrite,
	);
	register_post_type( 'arts_portfolio_item', $args );

	/**
	 * Services
	 */
	$labels  = array(
		'name'                  => _x( 'Services', 'Post Type General Name', 'cassio' ),
		'singular_name'         => _x( 'Service', 'Post Type Singular Name', 'cassio' ),
		'menu_name'             => _x( 'Services', 'Admin Menu text', 'cassio' ),
		'name_admin_bar'        => _x( 'Service', 'Add New on Toolbar', 'cassio' ),
		'archives'              => esc_html__( 'Service Archives', 'cassio' ),
		'attributes'            => esc_html__( 'Service Attributes', 'cassio' ),
		'parent_item_colon'     => esc_html__( 'Parent Service:', 'cassio' ),
		'all_items'             => esc_html__( 'All Services', 'cassio' ),
		'add_new_item'          => esc_html__( 'Add New Service', 'cassio' ),
		'add_new'               => esc_html__( 'Add New', 'cassio' ),
		'new_item'              => esc_html__( 'New Service', 'cassio' ),
		'edit_item'             => esc_html__( 'Edit Service', 'cassio' ),
		'update_item'           => esc_html__( 'Update Service', 'cassio' ),
		'view_item'             => esc_html__( 'View Service', 'cassio' ),
		'view_items'            => esc_html__( 'View Services', 'cassio' ),
		'search_items'          => esc_html__( 'Search Service', 'cassio' ),
		'not_found'             => esc_html__( 'Not found', 'cassio' ),
		'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'cassio' ),
		'featured_image'        => esc_html__( 'Featured Image', 'cassio' ),
		'set_featured_image'    => esc_html__( 'Set featured image', 'cassio' ),
		'remove_featured_image' => esc_html__( 'Remove featured image', 'cassio' ),
		'use_featured_image'    => esc_html__( 'Use as featured image', 'cassio' ),
		'insert_into_item'      => esc_html__( 'Insert into Service', 'cassio' ),
		'uploaded_to_this_item' => esc_html__( 'Uploaded to this Service', 'cassio' ),
		'items_list'            => esc_html__( 'Services list', 'cassio' ),
		'items_list_navigation' => esc_html__( 'Services list navigation', 'cassio' ),
		'filter_items_list'     => esc_html__( 'Filter Services list', 'cassio' ),
	);
	$rewrite = array(
		'slug'       => 'services',
		'with_front' => true,
		'pages'      => true,
		'feeds'      => true,
	);
	$args    = array(
		'label'               => esc_html__( 'Service', 'cassio' ),
		'description'         => esc_html__( '', 'cassio' ),
		'labels'              => $labels,
		'menu_icon'           => 'dashicons-hammer',
		'supports'            => array( 'title', 'thumbnail' ),
		'taxonomies'          => array(),
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => $priority++,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => false,
		'hierarchical'        => false,
		'exclude_from_search' => false,
		'show_in_rest'        => true,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
		'rewrite'             => $rewrite,
	);

	register_post_type( 'arts_service', $args );
}

