<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

if ( ! function_exists( 'arts_elementor_get_document_option' ) ) {
	/**
	 * Retrieve a specific document option for a given post.
	 *
	 * @param string   $option_name    The name of the option to retrieve.
	 * @param int|null $post_id        The ID of the post. Defaults to null.
	 * @param mixed    $option_default The value to return if the option is not found. Defaults to an empty string.
	 *
	 * @return mixed The value of the option, or the fallback value if not found.
	 * @deprecated 3.6.0 Use `\Arts\Utilities\Utilities::get_document_option()` method instead.
	 */
	function arts_elementor_get_document_option( $option, $post_id = null, $option_default = false ) {
		return Utilities::get_document_option( $option, $post_id, $option_default );
	}
}

if ( ! function_exists( 'arts_have_rows' ) ) {
	/**
	 * Proxy for `have_rows()` function from ACF.
	 *
	 * @param string $selector The field name or field key.
	 * @param int    $post_id  Optional. The post ID where the value is saved. Defaults to the current post.
	 *
	 * @return bool Whether the field has rows or not.
	 * @deprecated 3.6.0 Use `Arts\Utilities\Utilities::acf_have_rows()` method instead.
	 */
	function arts_have_rows( $selector, $post_id = false ) {
		return Utilities::acf_have_rows( $selector, $post_id );
	}
}

if ( ! function_exists( 'arts_get_field' ) ) {
	/**
	 * Proxy for `get_field()` function from ACF.
	 *
	 * @param string $selector The field name or field key.
	 * @param int    $post_id  Optional. The post ID where the value is saved. Defaults to the current post.
	 * @param bool   $format_value Optional. Whether to apply formatting logic. Defaults to true.
	 * @param bool   $escape_html Optional. Whether to escape HTML. Defaults to false.
	 *
	 * @return mixed|false The value of the field or false if not found.
	 * @deprecated 3.6.0 Use `Arts\Utilities\Utilities::acf_get_field()` method instead.
	 */
	function arts_get_field( $selector, $post_id = false, $format_value = true, $escape_html = false ) {
		return Utilities::acf_get_field( $selector, $post_id, $format_value, $escape_html );
	}
}

if ( ! function_exists( 'arts_get_field_objects' ) ) {
	/**
	 * Proxy for `get_field_objects()` function from ACF.
	 *
	 * @param int  $post_id     Optional. The post ID where the value is saved. Defaults to the current post.
	 * @param bool $format_value Optional. Whether to apply formatting logic. Defaults to true.
	 * @param bool $load_value   Optional. Whether to load the value. Defaults to true.
	 * @param bool $escape_html  Optional. Whether to escape HTML. Defaults to false.
	 *
	 * @return array|false The field objects or false if not found.
	 * @deprecated 3.6.0 Use `Arts\Utilities\Utilities::acf_get_field_objects()` method instead.
	 */
	function arts_get_field_objects( $post_id = false, $format_value = true, $load_value = true, $escape_html = false ) {
		return Utilities::acf_get_field_objects( $post_id, $format_value, $load_value, $escape_html );
	}
}

/**
 * Markup for lazy background/image/video
 */
if ( ! function_exists( 'arts_the_lazy_image' ) ) {
	function arts_the_lazy_image( $args ) {
		$defaults = array(
			'id'        => null,
			'type'      => 'background',
			'size'      => 'full',
			'class'     => array(
				'section' => array(),
				'wrapper' => array(),
				'image'   => array(),
				'overlay' => array(),
			),
			'attribute' => array(
				'image' => array(),
			),
			'parallax'  => array(
				'wrapper' => false,
				'enabled' => false,
				'factor'  => 0.1,
			),
			'overlay'   => false,
		);

		$attrs = '';

		$class_section = '';
		$attrs_section = '';

		$attrs_wrapper = '';
		$class_wrapper = '';

		$class_media = '';
		$attrs_media = '';

		$class_parallax_wrapper = '';

		$class_overlay = '';

		$lazy_placeholder_src       = '#';
		$lazy_placeholder_type      = get_theme_mod( 'lazy_placeholder_type', 'inline' );
		$lazy_placeholder_inline    = get_theme_mod( 'lazy_placeholder_inline', 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAHCGzyUAAAABGdBTUEAALGPC/xhBQAAADhlWElmTU0AKgAAAAgAAYdpAAQAAAABAAAAGgAAAAAAAqACAAQAAAABAAAAAaADAAQAAAABAAAAAQAAAADa6r/EAAAAC0lEQVQI12NolQQAASYAn89qhTcAAAAASUVORK5CYII=' );
		$lazy_placeholder_image_url = get_theme_mod( 'lazy_placeholder_image_url', '' );

		if ( $lazy_placeholder_type === 'inline' && ! empty( $lazy_placeholder_inline ) ) {
			$lazy_placeholder_src = $lazy_placeholder_inline;
		}

		if ( $lazy_placeholder_type === 'custom_image' && ! empty( $lazy_placeholder_image_url ) ) {
			$lazy_placeholder_src = $lazy_placeholder_image_url;
		}

		$lazy_placeholder_src = apply_filters( 'arts/lazy/placeholder', $lazy_placeholder_src );

		$args = wp_parse_args( $args, $defaults );

		if ( ! $args['id'] || ! $args['type'] ) {
			return;
		}

		// section
		if ( array_key_exists( 'section', $args['class'] ) && is_array( $args['class']['section'] ) && ! empty( $args['class']['section'] ) ) {
			$class_section = implode( ' ', $args['class']['section'] );
		}

		// wrapper
		if ( array_key_exists( 'wrapper', $args['class'] ) && is_array( $args['class']['wrapper'] ) && ! empty( $args['class']['wrapper'] ) ) {
			$class_wrapper = implode( ' ', $args['class']['wrapper'] );
		}

		// image class
		if ( array_key_exists( 'image', $args['class'] ) && is_array( $args['class']['image'] ) && ! empty( $args['class']['image'] ) ) {
			$class_media = implode( ' ', $args['class']['image'] );
		}

		// image attributes
		if ( array_key_exists( 'image', $args['attribute'] ) && is_array( $args['attribute']['image'] ) && ! empty( $args['attribute']['image'] ) ) {
			$attrs_media = implode( ' ', $args['attribute']['image'] );
		}

		// parallax
		if ( array_key_exists( 'parallax', $args ) && is_array( $args['parallax'] ) && $args['parallax']['enabled'] ) {
			if ( $args['type'] === 'background' ) {
				$attrs_wrapper .= ' data-art-parallax=background';
			} else {
				$attrs_wrapper .= ' data-art-parallax=image';
			}
			$attrs_wrapper .= ' data-art-parallax-factor=' . floatval( $args['parallax']['factor'] );
		}

		// parallax wrapper
		if ( array_key_exists( 'parallax', $args ) && is_array( $args['parallax'] ) && array_key_exists( 'wrapper', $args['parallax'] ) && $args['parallax']['wrapper'] ) {
			$class_parallax_wrapper = 'art-parallax__wrapper';
		}

		// image class
		if ( array_key_exists( 'overlay', $args['class'] ) && is_array( $args['class']['overlay'] ) && ! empty( $args['class']['overlay'] ) ) {
			$class_overlay = implode( ' ', $args['class']['overlay'] );
		}

		switch ( $args['type'] ) {
			case 'background':
				$class_media .= ' lazy-bg of-cover';
				break;
			case 'image':
				if ( $args['class']['wrapper'] !== false ) {
					$class_wrapper .= ' lazy';
				}
				break;
			case 'background-video':
				$class_media .= ' of-cover';
				break;
			case 'video':
				break;
		}

		if ( $args['type'] === 'background' || $args['type'] === 'image' ) {
			$attrs                    = wp_get_attachment_image_src( $args['id'], $args['size'] );
			$srcset                   = '';
			$sizes                    = '';
			$alt                      = get_post_meta( $args['id'], '_wp_attachment_image_alt', true );
			$full_size_images_enabled = get_theme_mod( 'full_size_images_enabled', false );
			$enable_optimized_sizes   = apply_filters( 'arts/lazy/enable_optimized_sizes', ! $full_size_images_enabled );

			if ( $enable_optimized_sizes ) {
				$srcset = wp_get_attachment_image_srcset( $args['id'], $args['size'] );
				$sizes  = wp_get_attachment_image_sizes( $args['id'], $args['size'] );
			}
		}

		?>
		<?php if ( ! empty( $class_section ) || ! empty( $attrs_section ) ) : ?>
			<div class="<?php echo esc_attr( trim( $class_section ) ); ?>" <?php echo esc_attr( trim( $attrs_section ) ); ?>>
		<?php endif; ?>
			<?php if ( ! empty( $class_wrapper ) || ! empty( $attrs_wrapper ) ) : ?>
				<?php if ( $args['type'] === 'image' ) : ?>
					<div class="<?php echo esc_attr( trim( $class_wrapper ) ); ?>" <?php echo esc_attr( trim( $attrs_wrapper ) ); ?> style="padding-bottom: calc( (<?php echo esc_attr( $attrs[2] ); ?> / <?php echo esc_attr( $attrs[1] ); ?>) * 100% ); height: 0;">
				<?php else : ?>
					<div class="<?php echo esc_attr( trim( $class_wrapper ) ); ?>" <?php echo esc_attr( trim( $attrs_wrapper ) ); ?>>
				<?php endif; ?>
			<?php endif; ?>
		<?php if ( ! empty( $class_parallax_wrapper ) ) : ?>
		<div class="<?php echo esc_attr( trim( $class_parallax_wrapper ) ); ?>">
		<?php endif; ?>
				<?php
				switch ( $args['type'] ) {
					case 'background' && is_array( $attrs ):
						?>
							<img class="<?php echo esc_attr( $class_media ); ?>" src="<?php echo esc_attr( $lazy_placeholder_src ); ?>" data-src="<?php echo esc_attr( $attrs[0] ); ?>" data-srcset="<?php echo esc_attr( $srcset ); ?>" data-sizes="<?php echo esc_attr( $sizes ); ?>" alt="<?php echo esc_attr( $alt ); ?>" <?php echo esc_attr( $attrs_media ); ?> />
							<?php
						break;
					case 'image' && is_array( $attrs ):
						?>
							<img class="<?php echo esc_attr( $class_media ); ?>" src="<?php echo esc_attr( $lazy_placeholder_src ); ?>" data-src="<?php echo esc_attr( $attrs[0] ); ?>" width="<?php echo esc_attr( $attrs[1] ); ?>" height="<?php echo esc_attr( $attrs[2] ); ?>" data-srcset="<?php echo esc_attr( $srcset ); ?>" data-sizes="<?php echo esc_attr( $sizes ); ?>" alt="<?php echo esc_attr( $alt ); ?>"/>
							<?php
						break;
					case 'background-video':
						?>
							<video class="<?php echo esc_attr( $class_media ); ?>" src="<?php echo esc_url( wp_get_attachment_url( $args['id'] ) ); ?>" playsinline loop muted autoplay></video>
							<?php
						break;
					case 'video':
						?>
							<video class="<?php echo esc_attr( $class_media ); ?>" src="<?php echo esc_url( wp_get_attachment_url( $args['id'] ) ); ?>" playsinline loop muted autoplay></video>
							<?php
						break;
				}
				?>
		<?php if ( ! empty( $class_parallax_wrapper ) ) : ?>
		  </div>
		<?php endif; ?>
				<?php if ( ! empty( $class_overlay ) ) : ?>
					<div class="<?php echo esc_attr( $class_overlay ); ?>"></div>
				<?php endif; ?>
			<?php if ( ! empty( $class_wrapper ) ) : ?>
				</div>
			<?php endif; ?>
		<?php if ( ! empty( $class_section ) || ! empty( $attrs_section ) ) : ?>
			</div>
		<?php endif; ?>
		<?php
	}
}

/**
 * Get the Google Maps API Key
 */
if ( ! function_exists( 'arts_get_gmap_key' ) ) {
	function arts_get_gmap_key() {
		$gmap_key = get_option( 'elementor_google_maps_api_key' );

		if ( is_string( $gmap_key ) && ! empty( $gmap_key ) ) {
			return $gmap_key;
		}

		$gmap_key_legacy = get_option( 'arts_gmap' );

		if ( is_array( $gmap_key_legacy ) && array_key_exists( 'key', $gmap_key_legacy ) && is_string( $gmap_key_legacy['key'] ) && ! empty( $gmap_key_legacy['key'] ) ) {
			return $gmap_key_legacy['key'];
		}

		return '';
	}
}
