<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Widget Copyright
 */
class Cassio_Widget_Copyright extends WP_Widget {

	function __construct() {
		parent::__construct(
			'cassio_copyright',
			esc_html__( 'Cassio: Copyright', 'cassio' ),
			array( 'description' => esc_html__( 'Displays small text.', 'cassio' ) )
		);
	}

	/**
	 * Display widget on frontend
	 *
	 * @param array $args     widget arguments.
	 * @param array $instance saved data from settings
	 */
	function widget( $args, $instance ) {

		$text = ( ! empty( $instance['text'] ) ) ? $instance['text'] : '';

		echo $args['before_widget'];
		?>

		<?php if ( ! empty( $text ) ) : ?>
			<small class="copyright"><?php echo wp_kses( $text, wp_kses_allowed_html( 'post' ) ); ?></small>
		<?php endif; ?>

		<?php
		echo $args['after_widget'];
	}

	/**
	 * Admin settings
	 *
	 * @param array $instance saved data from settings
	 */
	function form( $instance ) {

		$text = @ $instance['text'] ? : '';

		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'text' ); ?>"><?php esc_html_e( 'Text', 'cassio' ); ?></label> 
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'text' ); ?>" name="<?php echo $this->get_field_name( 'text' ); ?>"><?php echo wp_kses( $text, wp_kses_allowed_html( 'post' ) ); ?></textarea>
		</p>
		<?php
	}

	/**
	 * Sanitize and save widget settings.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance new settings
	 * @param array $old_instance previous settings
	 *
	 * @return array data to save
	 */
	function update( $new_instance, $old_instance ) {

		$instance         = array();
		$instance['text'] = ( ! empty( $new_instance['text'] ) ) ? wp_kses( $new_instance['text'], wp_kses_allowed_html( 'post' ) ) : '';

		return $instance;

	}
}
