<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Widget Social
 */
class Cassio_Widget_Social extends WP_Widget {
	function __construct() {
		parent::__construct(
			'cassio_social',
			esc_html__( 'Cassio: Social Media', 'cassio' ),
			array( 'description' => esc_html__( 'Displays social media links', 'cassio' ) )
		);

		$this->socials = apply_filters(
			'arts/widgets/cassio_widget_social/icons',
			array(
				'facebook'    => array(
					'title'      => esc_html__( 'Facebook URL', 'cassio' ),
					'icon'       => 'fa fa-facebook-f fa-fw',
					'aria-label' => esc_html__( 'Facebook', 'cassio' ),
				),
				'twitter'     => array(
					'title'      => esc_html__( 'Twitter URL', 'cassio' ),
					'icon'       => 'fa fa-twitter fa-fw',
					'aria-label' => esc_html__( 'Twitter', 'cassio' ),
				),
				'instagram'   => array(
					'title'      => esc_html__( 'Instagram URL', 'cassio' ),
					'icon'       => 'fa fa-instagram fa-fw',
					'aria-label' => esc_html__( 'Instagram', 'cassio' ),
				),
				'linkedin'    => array(
					'title'      => esc_html__( 'LinkedIn URL', 'cassio' ),
					'icon'       => 'fa fa-linkedin fa-fw',
					'aria-label' => esc_html__( 'LinkedIn', 'cassio' ),
				),
				'google_plus' => array(
					'title'      => esc_html__( 'Google Plus URL', 'cassio' ),
					'icon'       => 'fa fa-google-plus fa-fw',
					'aria-label' => esc_html__( 'Google Plus', 'cassio' ),
				),
				'vk'          => array(
					'title'      => esc_html__( 'VK URL', 'cassio' ),
					'icon'       => 'fa fa-vk fa-fw',
					'aria-label' => esc_html__( 'VK', 'cassio' ),
				),
				'youtube'     => array(
					'title'      => esc_html__( 'YouTube URL', 'cassio' ),
					'icon'       => 'fa fa-youtube fa-fw',
					'aria-label' => esc_html__( 'YouTube', 'cassio' ),
				),
				'vimeo'       => array(
					'title'      => esc_html__( 'Vimeo URL', 'cassio' ),
					'icon'       => 'fa fa-vimeo fa-fw',
					'aria-label' => esc_html__( 'Vimeo', 'cassio' ),
				),
				'dribbble'    => array(
					'title'      => esc_html__( 'Dribbble URL', 'cassio' ),
					'icon'       => 'fa fa-dribbble fa-fw',
					'aria-label' => esc_html__( 'Dribbble', 'cassio' ),
				),
				'pinterest'   => array(
					'title'      => esc_html__( 'Pinterest URL', 'cassio' ),
					'icon'       => 'fa fa-pinterest fa-fw',
					'aria-label' => esc_html__( 'Pinterest', 'cassio' ),
				),
				'behance'     => array(
					'title'      => esc_html__( 'Behance URL', 'cassio' ),
					'icon'       => 'fa fa-behance fa-fw',
					'aria-label' => esc_html__( 'Behance', 'cassio' ),
				),
				'flickr'      => array(
					'title'      => esc_html__( 'Flickr URL', 'cassio' ),
					'icon'       => 'fa fa-flickr fa-fw',
					'aria-label' => esc_html__( 'Flickr', 'cassio' ),
				),
				'tumblr'      => array(
					'title'      => esc_html__( 'Tumblr URL', 'cassio' ),
					'icon'       => 'fa fa-tumblr fa-fw',
					'aria-label' => esc_html__( 'Tumblr', 'cassio' ),
				),
				'vine'        => array(
					'title'      => esc_html__( 'Vine URL', 'cassio' ),
					'icon'       => 'fa fa-vine fa-fw',
					'aria-label' => esc_html__( 'Vine', 'cassio' ),
				),
				'github'      => array(
					'title'      => esc_html__( 'Github URL', 'cassio' ),
					'icon'       => 'fa fa-github fa-fw',
					'aria-label' => esc_html__( 'Github', 'cassio' ),
				),
				'soundcloud'  => array(
					'title'      => esc_html__( 'SoundCloud URL', 'cassio' ),
					'icon'       => 'fa fa-soundcloud fa-fw',
					'aria-label' => esc_html__( 'SoundCloud', 'cassio' ),
				),
				'telegram'    => array(
					'title'      => esc_html__( 'Telegram URL', 'cassio' ),
					'icon'       => 'fa fa-telegram fa-fw',
					'aria-label' => esc_html__( 'Telegram', 'cassio' ),
				),
				'medium'      => array(
					'title'      => esc_html__( 'Medium URL', 'cassio' ),
					'icon'       => 'fa fa-medium fa-fw',
					'aria-label' => esc_html__( 'Medium', 'cassio' ),
				),
				'skype'       => array(
					'title'      => esc_html__( 'Skype URL', 'cassio' ),
					'icon'       => 'fa fa-skype fa-fw',
					'aria-label' => esc_html__( 'Skype', 'cassio' ),
				),
				'whatsapp'    => array(
					'title'      => esc_html__( 'WhatsApp URL', 'cassio' ),
					'icon'       => 'fa fa-whatsapp fa-fw',
					'aria-label' => esc_html__( 'WhatsApp', 'cassio' ),
				),
				'slack'       => array(
					'title'      => esc_html__( 'Slack URL', 'cassio' ),
					'icon'       => 'fa fa-slack fa-fw',
					'aria-label' => esc_html__( 'Slack', 'cassio' ),
				),
				'tiktok'      => array(
					'title'      => esc_html__( 'TikTok URL', 'cassio' ),
					'icon'       => 'fa fa-tiktok fa-fw',
					'aria-label' => esc_html__( 'TikTok', 'cassio' ),
				),
			)
		);
	}

	/**
	 * Social Medias
	 *
	 * @var array
	 */
	private $socials;

	/**
	 * Display widget on frontend
	 *
	 * @param array $args     widget arguments.
	 * @param array $instance saved data from settings
	 */
	function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$widget_id = $args['widget_id'];

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		?>
			<ul class="social">
				<?php foreach ( $this->socials as $index => $item ) : ?>
					<?php $option = array_key_exists( $index, $instance ) ? $instance[ $index ] : ''; ?>
					<?php $aria_label = array_key_exists( 'aria-label', $item ) ? $item['aria-label'] : ''; ?>
					<?php $icon = array_key_exists( 'icon', $item ) ? $item['icon'] : ''; ?>
					<?php if ( ! empty( $option ) ) : ?>
						<li class="social__item">
							<a class="social__icon <?php echo esc_attr( $icon ); ?>" href="<?php echo esc_url( $option ); ?>" target="_blank"<?php if ( $aria_label ) : ?> aria-label="<?php echo esc_attr( $aria_label ); ?>"<?php endif; ?>></a>
						</li>
					<?php endif; ?>
				<?php endforeach; ?>
			</ul>
		<?php
		echo $args['after_widget'];
	}

	/**
	 * Admin settings
	 *
	 * @param array $instance saved data from settings
	 */
	function form( $instance ) {
		$title = @ $instance['title'] ? : '';
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title:', 'cassio' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<br>
		<?php foreach ( $this->socials as $index => $item ) : ?>
			<?php
					$field_name  = $this->get_field_name( $index );
					$field_value = @ $instance[ $index ] ? : '';
					$field_id    = $this->get_field_id( $index );
					$field_title = $item['title'];
			?>
				<p>
					<label for="<?php echo esc_html( $field_id ); ?>"><?php echo esc_html( $item['title'] ); ?></label> 
					<input class="widefat" id="<?php echo esc_html( $field_id ); ?>" name="<?php echo esc_html( $field_name ); ?>" type="text" value="<?php echo esc_url( $field_value ); ?>">
				</p>
		<?php endforeach; ?>

		<?php
	}

	/**
	 * Sanitize and save widget settings.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance new settings
	 * @param array $old_instance previous settings
	 *
	 * @return array data to save
	 */
	function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		foreach ( $this->socials as $index => $item ) {

			$url                = $new_instance[ $index ];
			$instance[ $index ] = '';

			if ( ! empty( $url ) ) {
				$instance[ $index ] = esc_url( $url );
			}
		}

		return $instance;
	}
}
