<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$arts_page_title      = get_theme_mod( '404_title', esc_html__( 'Page not Found', 'cassio' ) );
$arts_page_subtitle   = get_theme_mod( '404_message', esc_html__( 'It looks like nothing found here. Try to navigate the menu or return to the home page.', 'cassio' ) );
$arts_page_big        = get_theme_mod( '404_big', esc_html__( '404', 'cassio' ) );
$arts_page_button     = get_theme_mod( '404_button', esc_html__( 'Back to homepage', 'cassio' ) );
$arts_page_background = get_theme_mod( '404_background', 'bg-ornament' );
$arts_page_theme      = get_theme_mod( '404_theme', 'bg-light' );
$arts_button_theme    = get_theme_mod( '404_button_theme', 'bg-accent-primary-3' );
?>

<?php get_header(); ?>

<!-- section 404 -->
<section class="section section-404 section-fullheight text-center <?php echo esc_attr( $arts_page_theme ); ?> <?php echo esc_attr( $arts_page_background ); ?>">
	<div class="section-fullheight__inner section-404__inner">
		<div class="container">
			<header class="row justify-content-center align-items-center">
				<div class="col-lg-10">
					<div class="section__header section-404__header">
						<h1><?php echo esc_html( $arts_page_title ); ?></h1>
						<h4 class="heading-light"><?php echo esc_html( $arts_page_subtitle ); ?></h4>
					</div>
					<div class="section-404__wrapper-button">
						<a class="button button_solid <?php echo esc_attr( $arts_button_theme ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html( $arts_page_button ); ?></a>
					</div>
				</div>
			</header>
		</div>
	</div>
</section>
<!-- - section 404 -->

<?php get_footer(); ?>
