<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

$arts_enable_ajax = get_theme_mod( 'enable_ajax', true );

$arts_page_footer_settings = Utilities::get_document_option( 'page_footer_settings' );
$arts_footer_hide          = false;
$arts_class_container      = get_theme_mod( 'footer_container', 'container-fluid' );
$arts_class_theme          = get_theme_mod( 'footer_theme', 'bg-light' );
$arts_attrs_logo           = get_theme_mod( 'footer_logo', 'primary' );
$arts_class_area_primary   = '';
$arts_class_area_secondary = '';
$arts_has_upper_section    = arts_footer_has_active_sidebars( 'upper' );
$arts_has_lower_section    = arts_footer_has_active_sidebars( 'lower' );

$arts_has_border_primary   = get_theme_mod( 'enable_footer_border_primary', true );
$arts_has_border_secondary = get_theme_mod( 'enable_footer_border_secondary', true );

/**
 * Use Individual Page Footer Settings from Elementor
 * Or Use Global Settings from Customizer
 */
if ( $arts_page_footer_settings ) {

	if ( Utilities::get_document_option( 'page_footer_hide' ) ) {
		$arts_footer_hide = true;
	}

	$arts_class_theme          = Utilities::get_document_option( 'page_footer_theme' );
	$arts_attrs_logo           = Utilities::get_document_option( 'page_footer_logo' );
	$arts_has_border_primary   = Utilities::get_document_option( 'page_enable_footer_border_primary' );
	$arts_has_border_secondary = Utilities::get_document_option( 'page_enable_footer_border_secondary' );

}

if ( $arts_has_border_primary ) {
	$arts_class_area_primary = 'footer__area-border';
}

if ( $arts_has_border_secondary ) {
	$arts_class_area_secondary = 'footer__area-border';
}

?>
						<canvas id="js-webgl"></canvas>
					</main>
					<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'footer' ) ) : ?>
						<?php if ( ! $arts_footer_hide && ! is_404() && ( $arts_has_upper_section || $arts_has_lower_section ) ) : ?>
							<footer id="page-footer" class="footer <?php echo esc_attr( $arts_class_container ); ?> <?php echo esc_attr( $arts_class_theme ); ?>" data-logo="<?php echo esc_attr( $arts_attrs_logo ); ?>">
								<?php if ( $arts_has_upper_section ) : ?>
									<div class="footer__area-primary <?php echo esc_attr( $arts_class_area_primary ); ?>">
										<div class="row">
											<?php arts_render_footer_widgets( 'upper', 3 ); ?>
										</div>
									</div>
								<?php endif; ?>
								<?php if ( $arts_has_lower_section ) : ?>
									<div class="footer__area-secondary <?php echo esc_attr( $arts_class_area_secondary ); ?>">
										<div class="row">
											<?php arts_render_footer_widgets( 'lower', 3 ); ?>
										</div>
									</div>
								<?php endif; ?>
							</footer>
						<?php endif; ?>
					<?php endif; ?>
				</div>
			<?php if ( $arts_enable_ajax ) : ?>
				</div>
				<!-- - Barba Wrapper-->
			<?php endif; ?>
		<?php wp_footer(); ?>
	</body>
</html>
