<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once __DIR__ . '/vendor/autoload.php';

/**
 * Theme Constants
 */
$theme_version = \Arts\Utilities\Utilities::get_parent_theme_version();

define( 'ARTS_THEME_SLUG', 'cassio' );
define( 'ARTS_THEME_PATH', get_template_directory() );
define( 'ARTS_THEME_URL', get_template_directory_uri() );
define( 'ARTS_THEME_VERSION', $theme_version );
define(
	'ARTS_THEME_COLORS_ARRAY',
	array(
		'bg-white'              => 'White',
		'bg-off-white'          => 'Off white',
		'bg-light'              => 'Light',
		'bg-black'              => 'Black',
		'bg-dark'               => 'Dark',
		'bg-dark-2'             => 'Dark 2',
		'bg-dark-3'             => 'Dark 3',
		'bg-accent-primary-1'   => 'Accent Primary 1',
		'bg-accent-primary-2'   => 'Accent Primary 2',
		'bg-accent-primary-3'   => 'Accent Primary 3',
		'bg-accent-primary-4'   => 'Accent Primary 4',
		'bg-accent-secondary-1' => 'Accent Secondary 1',
		'bg-accent-secondary-2' => 'Accent Secondary 2',
		'bg-accent-secondary-3' => 'Accent Secondary 3',
		'bg-accent-secondary-4' => 'Accent Secondary 4',
	)
);

/**
 * Polyfills
 */
require_once ARTS_THEME_PATH . '/inc/functions/polyfills/get_page_by_title.php';

/**
 * Social Icons Helper
 */
require_once ARTS_THEME_PATH . '/inc/functions/get_social_icon.php';

/**
 * Preloader helper functions
 */
require_once ARTS_THEME_PATH . '/inc/functions/is_referer_from_same_domain.php';
require_once ARTS_THEME_PATH . '/inc/functions/is_preloader_enabled.php';

/**
 * Get Google Maps API Key
 */
require_once ARTS_THEME_PATH . '/inc/functions/get_gmap_key.php';

/**
 * ACF Fields
 */
require_once ARTS_THEME_PATH . '/inc/functions/acf.php';

/**
 * ACF Helper Functions
 */
require_once ARTS_THEME_PATH . '/inc/functions/acf_helpers.php';

/**
 * Additional <body> Classes
 */
require_once ARTS_THEME_PATH . '/inc/functions/add_body_classes.php';

/**
 * Add Custom Icons to Elementor
 */
require_once ARTS_THEME_PATH . '/inc/functions/add_elementor_icons.php';

/**
 * Add a Pingback URL to Posts
 */
require_once ARTS_THEME_PATH . '/inc/functions/add_pingback_url.php';

/**
 * Comments Form
 */
require_once ARTS_THEME_PATH . '/inc/functions/comments.php';

/**
 * Change CPT Slug
 */
require_once ARTS_THEME_PATH . '/inc/functions/change_cpt_slug.php';

/**
 * Adobe Fonts (Typekit) & Custom Fonts Support
 */
require_once ARTS_THEME_PATH . '/inc/functions/fonts.php';

/**
 * Get WooCommerce URLs
 */
require_once ARTS_THEME_PATH . '/inc/functions/get_woocommerce_urls.php';

/**
 * Customizer
 */
require_once ARTS_THEME_PATH . '/inc/customizer/customizer.php';

/**
 * Check If Footer Has Active Sidebars
 */
require_once ARTS_THEME_PATH . '/inc/functions/footer_has_active_sidebars.php';

/**
 * Render Footer Widgets & Columns
 */
require_once ARTS_THEME_PATH . '/inc/functions/render_footer_widgets.php';

/**
 * Helper Functions (Elementor)
 */
require_once ARTS_THEME_PATH . '/inc/functions/elementor_helpers.php';

/**
 * Elementor Compatibility Functions
 */
require_once ARTS_THEME_PATH . '/inc/functions/elementor_compatibility.php';

/**
 * Frontend Styles & Scripts
 */
require_once ARTS_THEME_PATH . '/inc/functions/frontend.php';

/**
 * Get Post Author
 */
require_once ARTS_THEME_PATH . '/inc/functions/get_post_author.php';

/**
 * Nav Menu
 */
require_once ARTS_THEME_PATH . '/inc/functions/nav.php';

/**
 * Pagination for Posts
 */
require_once ARTS_THEME_PATH . '/inc/functions/pagination.php';

/**
 * Password Form for Protected Posts
 */
require_once ARTS_THEME_PATH . '/inc/functions/password_form.php';

/**
 * Theme Support Features
 */
require_once ARTS_THEME_PATH . '/inc/functions/theme_support.php';

/**
 * Widget Areas
 */
require_once ARTS_THEME_PATH . '/inc/functions/widget_areas.php';

/**
 * Wrap Post Count in Widgets (categories, archives) into <span> Tag
 */
require_once ARTS_THEME_PATH . '/inc/functions/wrap_count.php';

/**
 * WP Contact Form 7: Don't Wrap Form Fields Into </p>
 */
require_once ARTS_THEME_PATH . '/inc/functions/wpcf7.php';

/**
 * WPForms: Force enable "Load Assets Globally" option if AJAX is on
 */
require_once ARTS_THEME_PATH . '/inc/functions/wpforms.php';

/**
 * Set default title depending on the page
 */
require_once ARTS_THEME_PATH . '/inc/functions/set_page_title.php';

/**
 * Markup for Lazy Images
 */
require_once ARTS_THEME_PATH . '/inc/functions/the_lazy_image.php';

/**
 * Get the terms names of taxonomy
 */
require_once ARTS_THEME_PATH . '/inc/functions/get_taxonomy_term_names.php';

/**
 * Remove rendering of SVG duotone filters
 */
require_once ARTS_THEME_PATH . '/inc/functions/remove_duotone_filters.php';

/**
 * Fix for Intuitive CPO plugin
 */
require_once ARTS_THEME_PATH . '/inc/functions/hicpo_fix_capabilities.php';

/**
 * Load Required Plugins
 */
require_once ARTS_THEME_PATH . '/inc/tgm/load_plugins.php';

/**
 * Demo Import
 */
require_once ARTS_THEME_PATH . '/inc/importer/importer.php';

/**
 * Theme License & Updates Manager
 */
require_once ARTS_THEME_PATH . '/inc/updater/updater.php';
