<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

$arts_page_header_settings     = Utilities::get_document_option( 'page_header_settings' );
$arts_page_transition_settings = Utilities::get_document_option( 'page_transition_settings' );
$arts_is_elementor_page        = Utilities::is_built_with_elementor();
$arts_class_page               = '';
$arts_attrs_page               = '';
$arts_class_burger_col         = '';

/**
 * Use Individual Page Transition Settings from Elementor
 * Or Use Global Settings from Customizer
 */
if ( $arts_page_transition_settings ) {
	$arts_ajax_curtain_color = Utilities::get_document_option( 'page_ajax_curtain_color' );
} else {
	$arts_ajax_curtain_color = get_theme_mod( 'ajax_curtain_color', 'bg-off-white' );
}

$arts_enable_smooth_scroll           = get_theme_mod( 'enable_smooth_scroll', false );
$arts_enable_smooth_scroll_mobile    = get_theme_mod( 'enable_smooth_scroll_mobile', false );
$arts_enable_ajax                    = get_theme_mod( 'enable_ajax', false );
$arts_enable_master_audio_background = get_theme_mod( 'enable_master_audio_background', false );
$arts_master_audio_player_position   = get_theme_mod( 'master_audio_player_position', 'header' );
$arts_enable_preloader               = arts_is_preloader_enabled();
$arts_enable_cursor                  = get_theme_mod( 'enable_cursor', false );
$arts_enable_spinner_desktop         = get_theme_mod( 'enable_spinner_desktop', false );
$arts_enable_spinner_mobile          = get_theme_mod( 'enable_spinner_mobile', true );
$arts_outdated_browsers_enabled      = get_theme_mod( 'outdated_browsers_enabled', true );

if ( $arts_enable_smooth_scroll === true ) {
	$arts_class_page .= ' js-smooth-scroll';

	if ( $arts_enable_smooth_scroll_mobile == true ) {
		$arts_class_page .= ' js-smooth-scroll_enable-mobile';
	}
}

if ( $arts_enable_ajax ) {
	$attrs_wrapper   = 'data-barba=wrapper';
	$arts_attrs_page = 'data-barba=container';
}

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?> >
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		<meta http-equiv="x-ua-compatible" content="ie=edge">
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
		<?php
		if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
		}
		?>
		<?php if ( $arts_outdated_browsers_enabled ) : ?>
			<div id="outdated"></div>
		<?php endif; ?>
		<?php if ( $arts_enable_ajax ) : ?>
			<div <?php echo esc_attr( $attrs_wrapper ); ?>>
				<?php if ( $arts_enable_spinner_desktop || $arts_enable_spinner_mobile ) : ?>
					<!-- Loading Spinner -->
					<?php get_template_part( 'template-parts/svg/spinner' ); ?>
					<!-- - Loading Spinner -->
				<?php endif; ?>
		<?php endif; ?>
			<?php if ( $arts_enable_cursor ) : ?>
				<!-- CURSOR FOLLOWER-->
				<?php get_template_part( 'template-parts/cursor/cursor' ); ?>
				<!-- - CURSOR FOLLOWER-->
			<?php endif; ?>
			<?php if ( $arts_enable_preloader ) : ?>
				<!-- PAGE PRELOADER -->
				<?php get_template_part( 'template-parts/preloader/preloader' ); ?>
				<!-- - PAGE PRELOADER -->
			<?php endif; ?>
			<?php if ( $arts_enable_ajax ) : ?>
				<!-- TRANSITION CURTAIN -->
				<div class="transition-curtain <?php echo esc_attr( $arts_ajax_curtain_color ); ?>"></div>
				<!-- - TRANSITION CURTAIN -->
			<?php endif; ?>
			<?php if ( $arts_enable_master_audio_background ) : ?>
				<!-- Audio Background -->
				<?php get_template_part( 'template-parts/audio/audio' ); ?>
				<!-- - Audio Background -->
			<?php endif; ?>
			<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) : ?>
				<!-- PAGE HEADER -->
				<?php get_template_part( 'template-parts/header/header' ); // since Cassio 2.0.0 ?>
				<!-- - PAGE HEADER -->
			<?php endif; ?>
			<!-- PAGE MAIN -->
			<div class="page-wrapper <?php echo esc_attr( $arts_class_page ); ?>" <?php echo esc_attr( $arts_attrs_page ); ?>>
				<?php if ( function_exists( 'elementor_theme_do_location' ) ) : ?>
					<?php elementor_theme_do_location( 'popup' ); ?>
				<?php endif; ?>
				<main class="page-wrapper__content">
