<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * Post Show All Info
 */
new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'    => 'post_show_info',
		'label'       => esc_html__( 'Show All info', 'cassio' ),
		'description' => esc_html__( 'Show post information (posted date, author, comments, etc...).', 'cassio' ),
		'section'     => 'post',
		'default'     => 'on',
		'priority'    => $priority++,
		'choices'     => array(
			true  => esc_html__( 'On', 'cassio' ),
			false => esc_html__( 'Off', 'cassio' ),
		),
	)
);

/**
 * Post Date
 */
new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'post_show_date',
		'label'           => esc_html__( 'Show Date', 'cassio' ),
		'section'         => 'post',
		'default'         => 'on',
		'priority'        => $priority++,
		'choices'         => array(
			true  => esc_html__( 'On', 'cassio' ),
			false => esc_html__( 'Off', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'post_show_info',
				'value'   => true,
			),
		),
	)
);

/**
 * Post Categories
 */
new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'post_show_categories',
		'label'           => esc_html__( 'Show Categories', 'cassio' ),
		'section'         => 'post',
		'default'         => 'on',
		'priority'        => $priority++,
		'choices'         => array(
			true  => esc_html__( 'On', 'cassio' ),
			false => esc_html__( 'Off', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'post_show_info',
				'value'   => true,
			),
		),
	)
);

/**
 * Post Comments Counter
 */
new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'post_show_comments_counter',
		'label'           => esc_html__( 'Show Comments Counter', 'cassio' ),
		'section'         => 'post',
		'default'         => 'on',
		'priority'        => $priority++,
		'choices'         => array(
			true  => esc_html__( 'On', 'cassio' ),
			false => esc_html__( 'Off', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'post_show_info',
				'value'   => true,
			),
		),
	)
);

/**
 * Post Author
 */
new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'post_show_author',
		'label'           => esc_html__( 'Show Author', 'cassio' ),
		'section'         => 'post',
		'default'         => 'on',
		'priority'        => $priority++,
		'choices'         => array(
			true  => esc_html__( 'On', 'cassio' ),
			false => esc_html__( 'Off', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'post_show_info',
				'value'   => true,
			),
		),
	)
);

/**
 * Post Read More Button
 */
new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'post_show_read_more',
		'label'           => esc_html__( 'Show "More" Button', 'cassio' ),
		'section'         => 'post',
		'default'         => 'on',
		'priority'        => $priority++,
		'choices'         => array(
			true  => esc_html__( 'On', 'cassio' ),
			false => esc_html__( 'Off', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'post_show_info',
				'value'   => true,
			),
		),
	)
);
