<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'    => 'enable_fix_mobile_vh',
		'label'       => esc_html__( 'Fit Fullscreen Height Elements', 'cassio' ),
		'description' => esc_html__( 'This option calculates the full height elements to fit the entire screen considering the height of bottom navigation bar.', 'cassio' ),
		'section'     => 'layout',
		'default'     => true,
		'priority'    => $priority++,
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'        => 'enable_fix_mobile_vh_update',
		'label'           => esc_html__( 'Update Fullscreen Height Elements on Window Resize', 'cassio' ),
		'description'     => esc_html__( 'Disable to avoid page jump when scrolling on mobile devices.', 'cassio' ),
		'section'         => 'layout',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_fix_mobile_vh',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);
