<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * XL
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'XLarge', 'cassio' ),
		'settings' => 'paddings_margins_generic_heading' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_max_xlarge',
		'description' => esc_html__( 'Desktop padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 400,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-max-xlarge',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_min_xlarge',
		'description' => esc_html__( 'Mobile padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 160,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-min-xlarge',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'paddings_margins_generic_divider' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * L
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Large', 'cassio' ),
		'settings' => 'paddings_margins_generic_heading' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_max_large',
		'description' => esc_html__( 'Desktop padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 300,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-max-large',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_min_large',
		'description' => esc_html__( 'Mobile padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 100,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-min-large',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'paddings_margins_generic_divider' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * M
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Medium', 'cassio' ),
		'settings' => 'paddings_margins_generic_heading' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_max_normal',
		'description' => esc_html__( 'Desktop padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 200,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-max-normal',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_min_normal',
		'description' => esc_html__( 'Mobile padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 60,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-min-normal',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'paddings_margins_generic_divider' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * S
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Small', 'cassio' ),
		'settings' => 'paddings_margins_generic_heading' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_max_small',
		'description' => esc_html__( 'Desktop padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 80,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-max-small',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_min_small',
		'description' => esc_html__( 'Mobile padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 40,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-min-small',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'paddings_margins_generic_divider' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * XS
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'XSmall', 'cassio' ),
		'settings' => 'paddings_margins_generic_heading' . $priority,
		'section'  => 'paddings_margins',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_max_xsmall',
		'description' => esc_html__( 'Desktop padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 60,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-max-xsmall',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'distance_min_xsmall',
		'description' => esc_html__( 'Mobile padding & margin (px)', 'cassio' ),
		'section'     => 'paddings_margins',
		'default'     => 40,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--distance-min-xsmall',
			),
		),
	)
);
