<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'    => 'menu_style',
		'label'       => esc_html__( 'Menu Style', 'cassio' ),
		'description' => esc_html__( 'This option has an effect only on desktop. On mobile there is always a fullscreen overlay menu.', 'cassio' ),
		'section'     => 'menu',
		'default'     => 'classic',
		'priority'    => $priority++,
		'choices'     => array(
			'classic'    => esc_html__( 'Classic', 'cassio' ),
			'fullscreen' => esc_html__( 'Fullscreen', 'cassio' ),
		),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'        => 'enable_morphing_letters',
		'label'           => esc_html__( 'Display Decorative Circle', 'cassio' ),
		'description'     => esc_html__( 'Only Desktop Menu', 'cassio' ),
		'section'         => 'menu',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting' => 'menu_style',
				'value'   => 'fullscreen',
			),
		),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings' => 'enable_menu_split_chars_animation',
		'label'    => esc_html__( 'Enable Split Characters Animation in Fullscreen Menu', 'cassio' ),
		'section'  => 'menu',
		'default'  => true,
		'priority' => $priority++,
	)
);

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'        => 'menu_overlay_circle_contents',
		'label'           => esc_html__( 'Circle Contents', 'cassio' ),
		'section'         => 'menu',
		'default'         => 'letters',
		'priority'        => $priority++,
		'choices'         => array(
			'letters' => esc_html__( 'Morphing Letters', 'cassio' ),
			'logo'    => esc_html__( 'Site Logo', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'enable_morphing_letters',
				'value'   => true,
			),
			array(
				'setting' => 'menu_style',
				'value'   => 'fullscreen',
			),
		),
	)
);

new \Kirki\Field\Multicheck(
	array(
		'settings'        => 'morphing_letters_set',
		'label'           => esc_html__( 'Morphing Letters Set', 'cassio' ),
		'section'         => 'menu',
		'default'         => array( 'latin' ),
		'choices'         => array(
			'latin'     => esc_html__( 'Latin', 'cassio' ),
			'latin-ext' => esc_html__( 'Latin Extended', 'cassio' ),
			'cyrillic'  => esc_html__( 'Cyrillic', 'cassio' ),
			'numbers'   => esc_html__( 'Numbers', 'cassio' ),
		),
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting' => 'menu_overlay_circle_contents',
				'value'   => 'letters',
			),
			array(
				'setting' => 'enable_morphing_letters',
				'value'   => true,
			),
			array(
				'setting' => 'menu_style',
				'value'   => 'fullscreen',
			),
		),
	)
);


new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'        => 'menu_overlay_background',
		'label'           => esc_html__( 'Menu Background', 'cassio' ),
		'section'         => 'menu',
		'default'         => 'ornament',
		'priority'        => $priority++,
		'choices'         => array(
			'none'     => esc_html__( 'None', 'cassio' ),
			'ornament' => esc_html__( 'Ornament', 'cassio' ),
			'custom'   => esc_html__( 'Custom', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'menu_style',
				'value'   => 'fullscreen',
			),
		),
	)
);

new \Kirki\Field\Image(
	array(
		'settings'        => 'menu_overlay_background_url',
		'section'         => 'menu',
		'default'         => '',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting' => 'menu_style',
				'value'   => 'fullscreen',
			),
			array(
				'setting' => 'menu_overlay_background',
				'value'   => 'custom',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'header_overlay_menu_theme',
		'label'           => esc_html__( 'Menu Overlay Theme', 'cassio' ),
		'section'         => 'menu',
		'default'         => 'bg-dark',
		'priority'        => $priority++,
		'transport'       => 'postMessage',
		'choices'         => ARTS_THEME_COLORS_ARRAY,
		'tooltip'         => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
		'active_callback' => array(
			array(
				'setting' => 'menu_style',
				'value'   => 'fullscreen',
			),
		),
	)
);

new \Kirki\Field\Color(
	array(
		'settings'        => 'menu_overlay_background_color',
		'label'           => esc_html__( 'Menu Background Overlay', 'cassio' ),
		'section'         => 'menu',
		'default'         => 'rgba(0,0,0,0)',
		'priority'        => $priority++,
		'transport'       => 'auto',
		'choices'         => array(
			'alpha' => true,
		),
		'tooltip'         => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
		'active_callback' => array(
			array(
				'setting' => 'menu_style',
				'value'   => 'fullscreen',
			),
			array(
				'setting'  => 'menu_overlay_background',
				'operator' => '!=',
				'value'    => 'none',
			),
		),
		'output'          => array(
			array(
				'element'  => '.header__curtain:after',
				'property' => 'background-color',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'label'           => esc_html__( 'Menu Additional Information', 'cassio' ),
		'description'     => esc_html__( 'Add text or HTML information that will appear in opened overlay menu.', 'cassio' ),
		'settings'        => 'menu_generic_heading' . $priority,
		'section'         => 'menu',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'span',
		),
		'active_callback' => array(
			array(
				'setting' => 'menu_style',
				'value'   => 'fullscreen',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'label'           => esc_html__( 'Menu Additional Information (Only Mobile Menu)', 'cassio' ),
		'description'     => esc_html__( 'Add text or HTML information that will appear in opened overlay menu', 'cassio' ),
		'settings'        => 'menu_generic_heading' . $priority,
		'section'         => 'menu',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'span',
		),
		'active_callback' => array(
			array(
				'setting' => 'menu_style',
				'value'   => 'classic',
			),
		),
	)
);

new \Kirki\Field\Repeater(
	array(
		'settings'  => 'menu_overlay_info',
		'section'   => 'menu',
		'priority'  => $priority++,
		'row_label' => array(
			'type'  => 'text',
			'value' => esc_html__( 'Column', 'cassio' ),
			'field' => 'column',
		),
		'fields'    => array(
			'column' => array(
				'type' => 'textarea',
			),
		),
		'choices'   => array(
			'limit' => 3,
		),
	)
);
