<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'  => 'header_container',
		'label'     => esc_html__( 'Container', 'cassio' ),
		'section'   => 'header_options',
		'default'   => 'container-fluid',
		'priority'  => $priority++,
		'choices'   => array(
			'container-fluid' => esc_html__( 'Fullwidth', 'cassio' ),
			'container'       => esc_html__( 'Boxed', 'cassio' ),
		),
		'transport' => 'postMessage',
	)
);

new \Kirki\Field\Select(
	array(
		'settings'  => 'header_main_theme',
		'label'     => esc_html__( 'Main Color Theme', 'cassio' ),
		'section'   => 'header_options',
		'default'   => 'header_color-black',
		'priority'  => $priority++,
		'transport' => 'postMessage',
		'choices'   => array(
			'header_color-white' => esc_html__( 'White', 'cassio' ),
			'header_color-black' => esc_html__( 'Black', 'cassio' ),
		),
		'tooltip'   => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
	)
);

new \Kirki\Field\Select(
	array(
		'settings' => 'header_main_logo',
		'label'    => esc_html__( 'Main Logo to Display', 'cassio' ),
		'section'  => 'header_options',
		'default'  => 'header_logo-primary',
		'priority' => $priority++,
		'choices'  => array(
			'header_logo-primary'   => esc_html__( 'Primary', 'cassio' ),
			'header_logo-secondary' => esc_html__( 'Secondary', 'cassio' ),
		),
		'tooltip'  => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
	)
);

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings' => 'header_type',
		'label'    => esc_html__( 'Position', 'cassio' ),
		'section'  => 'header_options',
		'default'  => 'sticky',
		'priority' => $priority++,
		'choices'  => array(
			'absolute' => esc_html__( 'Absolute', 'cassio' ),
			'sticky'   => esc_html__( 'Sticky', 'cassio' ),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'header_sticky_theme',
		'label'           => esc_html__( 'Sticky Color Theme', 'cassio' ),
		'section'         => 'header_options',
		'default'         => 'bg-dark-2',
		'priority'        => $priority++,
		'choices'         => ARTS_THEME_COLORS_ARRAY,
		'tooltip'         => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
		'active_callback' => array(
			array(
				'setting' => 'header_type',
				'value'   => 'sticky',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'header_sticky_logo',
		'label'           => esc_html__( 'Sticky Logo to Display', 'cassio' ),
		'section'         => 'header_options',
		'default'         => 'header_logo-secondary',
		'priority'        => $priority++,
		'choices'         => array(
			'header_logo-primary'   => esc_html__( 'Primary', 'cassio' ),
			'header_logo-secondary' => esc_html__( 'Secondary', 'cassio' ),
		),
		'tooltip'         => esc_html__( 'This option may be overriden for the current page from Elementor document settings.', 'cassio' ),
		'active_callback' => array(
			array(
				'setting' => 'header_type',
				'value'   => 'sticky',
			),
		),
	)
);
