<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings' => 'enable_custom_portfolio_slug',
		'label'    => esc_html__( 'Enable custom slug', 'cassio' ),
		'section'  => 'portfolio',
		'default'  => false,
		'priority' => $priority++,
	)
);

new \Kirki\Field\Text(
	array(
		'settings'        => 'portfolio_slug',
		'label'           => esc_html__( 'Slug', 'cassio' ),
		'description'     => sprintf(
			'%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s',
			esc_html__( 'You will need to', 'cassio' ),
			admin_url( 'options-permalink.php' ),
			esc_html__( 'update your permalinks', 'cassio' ),
			esc_html__( '(click "Save Changes") each time you change the slug', 'cassio' )
		),
		'section'         => 'portfolio',
		'default'         => 'portfolio',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting' => 'enable_custom_portfolio_slug',
				'value'   => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'    => 'enable_portfolio_nav',
		'label'       => esc_html__( 'Show prev / next portfolio navigation', 'cassio' ),
		'description' => esc_html__( 'Appears at the bottom of the portfolio pages.', 'cassio' ),
		'section'     => 'portfolio',
		'default'     => true,
		'priority'    => $priority++,
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'portfolio_nav_hover_effect',
		'label'           => esc_html__( 'Hover Effect', 'cassio' ),
		'section'         => 'portfolio',
		'default'         => 'reveal',
		'priority'        => $priority++,
		'choices'         => array(
			'no-split' => esc_html__( 'None', 'cassio' ),
			'none'     => esc_html__( 'None (keep chars split)', 'cassio' ),
			'reveal'   => esc_html__( 'Split Chars Reveal', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'enable_portfolio_nav',
				'value'   => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'        => 'enable_portfolio_archive_link',
		'label'           => esc_html__( 'Enable archive link', 'cassio' ),
		'section'         => 'portfolio',
		'default'         => 'on',
		'priority'        => $priority++,
		'choices'         => array(
			true  => esc_html__( 'On', 'cassio' ),
			false => esc_html__( 'Off', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting' => 'enable_portfolio_nav',
				'value'   => true,
			),
		),
	)
);

new \Kirki\Field\Dropdown_Pages(
	array(
		'settings'        => 'portfolio_archive_link',
		'description'     => esc_html__( 'Choose a link to the page where all your portfolio items are listed.', 'cassio' ),
		'section'         => 'portfolio',
		'default'         => '',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting' => 'enable_portfolio_nav',
				'value'   => true,
			),
			array(
				'setting' => 'enable_portfolio_archive_link',
				'value'   => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'        => 'enable_portfolio_loop',
		'label'           => esc_html__( 'Loop the portfolio navigation', 'cassio' ),
		'section'         => 'portfolio',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting' => 'enable_portfolio_nav',
				'value'   => true,
			),
		),
	)
);
