<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings' => 'enable_custom_services_slug',
		'label'    => esc_html__( 'Enable custom slug', 'cassio' ),
		'section'  => 'services',
		'default'  => false,
		'priority' => $priority++,
	)
);

new \Kirki\Field\Text(
	array(
		'settings'        => 'services_slug',
		'label'           => esc_html__( 'Slug', 'cassio' ),
		'description'     => sprintf(
			'%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s',
			esc_html__( 'You will need to', 'cassio' ),
			admin_url( 'options-permalink.php' ),
			esc_html__( 'update your permalinks', 'cassio' ),
			esc_html__( '(click "Save Changes") each time you change the slug', 'cassio' )
		),
		'section'         => 'services',
		'default'         => 'services',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_custom_services_slug',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);
