<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'    => 'enable_cursor',
		'label'       => esc_html__( 'Enable Mouse Cursor Follower', 'cassio' ),
		'description' => esc_html__( 'It won\'t appear on touch devices regardless of this setting.', 'cassio' ),
		'section'     => 'cursor_follower',
		'default'     => false,
		'priority'    => $priority++,
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings' => 'enable_loading_progress',
		'label'    => esc_html__( 'Enable System "Progress" Cursor', 'cassio' ),
		'section'  => 'cursor_follower',
		'default'  => true,
		'priority' => $priority++,
	)
);

new \Kirki\Field\Number(
	array(
		'settings'        => 'cursor_attraction_delay',
		'label'           => esc_html__( 'Cursor Attraction Delay', 'cassio' ),
		'description'     => esc_html__( 'The lower the value is, the faster virtual mouse follower will attract to the native cursor pointer.', 'cassio' ),
		'tooltip'         => esc_html__( 'A float value between 0.0 and 0.5 defining the time (in seconds) needed the virtual mouse follower to attract to the native cursor pointer.', 'cassio' ),
		'section'         => 'cursor_follower',
		'default'         => 0.04,
		'priority'        => $priority++,
		'choices'         => array(
			'min'  => 0,
			'max'  => 0.5,
			'step' => 0.01,
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_cursor',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'cursor_background',
		'label'           => esc_html__( 'Color Theme', 'cassio' ),
		'section'         => 'cursor_follower',
		'default'         => 'bg-accent-primary-3',
		'priority'        => $priority++,
		'choices'         => ARTS_THEME_COLORS_ARRAY,
		'active_callback' => array(
			array(
				'setting'  => 'enable_cursor',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'label'           => esc_html__( 'Helper Labels', 'cassio' ),
		'settings'        => 'cursor_follower_heading',
		'section'         => 'cursor_follower',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'span',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_cursor',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Text(
	array(
		'settings'        => 'cursor_label_slider',
		'description'     => esc_html__( 'Draggable Sliders', 'cassio' ),
		'section'         => 'cursor_follower',
		'default'         => esc_html__( 'Drag Me', 'cassio' ),
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_cursor',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);
