<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings' => 'enable_preloader',
		'label'    => esc_html__( 'Enable Page Preloader', 'cassio' ),
		'section'  => 'preloader',
		'default'  => false,
		'priority' => $priority++,
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'preloader_show_once',
		'label'           => esc_html__( 'Show Only Once', 'cassio' ),
		'description'     => esc_html__( 'Let site preloader to appear only once on the initial site load. Further site navigation will continue without preloader until a user will close the current browser tab.', 'cassio' ),
		'section'         => 'preloader',
		'default'         => false,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Radio_Buttonset(
	array(
		'settings'        => 'preloader_style',
		'label'           => esc_html__( 'Preloader Style', 'cassio' ),
		'section'         => 'preloader',
		'default'         => 'counter',
		'priority'        => $priority++,
		'choices'         => array(
			'logo'         => esc_html__( 'Logo', 'cassio' ),
			'counter'      => esc_html__( 'Counter', 'cassio' ),
			'custom_image' => esc_html__( 'Custom Image', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'preloader_logo',
		'label'           => esc_html__( 'Logo to Display', 'cassio' ),
		'section'         => 'preloader',
		'default'         => 'primary',
		'priority'        => $priority++,
		'choices'         => array(
			'primary'   => esc_html__( 'Primary', 'cassio' ),
			'secondary' => esc_html__( 'Secondary', 'cassio' ),
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'preloader_style',
				'operator' => '==',
				'value'    => 'logo',
			),
		),
	)
);

new \Kirki\Field\Image(
	array(
		'settings'        => 'preloader_image_url',
		'section'         => 'preloader',
		'default'         => '',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'preloader_style',
				'operator' => '==',
				'value'    => 'custom_image',
			),
		),
	)
);

/**
 * Loading Circle
 */
new \Kirki\Field\Generic(
	array(
		'label'           => esc_html__( 'Loading Circle', 'cassio' ),
		'settings'        => 'preloader_generic_heading' . $priority,
		'section'         => 'preloader',
		'priority'        => $priority++,
		'choices'         => array(
			'element' => 'span',
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'        => 'preloader_circle_max_size',
		'description'     => esc_html__( 'Desktop size (px)', 'cassio' ),
		'section'         => 'preloader',
		'default'         => 300,
		'priority'        => $priority++,
		'choices'         => array(
			'min'  => 50,
			'max'  => 1000,
			'step' => 50,
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => ':root',
				'property' => '--preloader-circle-max-size',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'        => 'preloader_circle_min_size',
		'description'     => esc_html__( 'Mobile size (px)', 'cassio' ),
		'section'         => 'preloader',
		'default'         => 200,
		'priority'        => $priority++,
		'choices'         => array(
			'min'  => 50,
			'max'  => 1000,
			'step' => 50,
		),
		'transport'       => 'auto',
		'output'          => array(
			array(
				'element'  => ':root',
				'property' => '--preloader-circle-min-size',
			),
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'preloader_generic_divider' . $priority,
		'section'  => 'preloader',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * Loading Text
 */
new \Kirki\Field\Text(
	array(
		'settings'        => 'preloader_text',
		'label'           => esc_html__( 'Loading Text', 'cassio' ),
		'section'         => 'preloader',
		'default'         => esc_html__( 'Loading', 'cassio' ),
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'preloader_bg_outer_theme',
		'label'           => esc_html__( 'Preloader Background Theme', 'cassio' ),
		'section'         => 'preloader',
		'default'         => 'bg-dark',
		'priority'        => $priority++,
		'choices'         => ARTS_THEME_COLORS_ARRAY,
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'        => 'preloader_bg_inner_theme',
		'label'           => esc_html__( 'Preloader Curtain Theme', 'cassio' ),
		'section'         => 'preloader',
		'default'         => 'bg-accent-primary-1',
		'priority'        => $priority++,
		'choices'         => ARTS_THEME_COLORS_ARRAY,
		'active_callback' => array(
			array(
				'setting'  => 'enable_preloader',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);
