<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings' => 'enable_smooth_scroll',
		'label'    => esc_html__( 'Enable Page Smooth Scroll', 'cassio' ),
		'section'  => 'smooth_scroll',
		'default'  => false,
		'priority' => $priority++,
	)
);

new \Kirki\Field\Checkbox(
	array(
		'settings'        => 'enable_smooth_scroll_elementor_canvas_template',
		'label'           => esc_html__( 'Enable on Elementor Canvas Pages ', 'cassio' ),
		'section'         => 'smooth_scroll',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_smooth_scroll',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'        => 'enable_smooth_scroll_mobile',
		'label'           => esc_html__( 'Enable on Touch Devices', 'cassio' ),
		'description'     => esc_html__( 'This option is NOT recommended as it replaces native momentum scroll experience. Use with caution!', 'cassio' ),
		'section'         => 'smooth_scroll',
		'default'         => false,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_smooth_scroll',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Number(
	array(
		'settings'        => 'smooth_scroll_damping',
		'label'           => esc_html__( 'Damping', 'cassio' ),
		'description'     => esc_html__( 'The lower the value is, the more smooth the scrolling will be.', 'cassio' ),
		'tooltip'         => esc_html__( 'A float value between 0.0 and 1.0 defining the momentum reduction damping factor.', 'cassio' ),
		'section'         => 'smooth_scroll',
		'default'         => 0.06,
		'priority'        => $priority++,
		'choices'         => array(
			'min'  => 0,
			'max'  => 1,
			'step' => 0.01,
		),
		'active_callback' => array(
			array(
				'setting'  => 'enable_smooth_scroll',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'        => 'smooth_scroll_render_by_pixels',
		'label'           => esc_html__( 'Enable Render by Pixels', 'cassio' ),
		'description'     => esc_html__( 'Render every frame in integer pixel values, set to true to improve scrolling performance.', 'cassio' ),
		'section'         => 'smooth_scroll',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_smooth_scroll',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'        => 'smooth_scroll_plugin_easing',
		'label'           => esc_html__( 'Enable Edge Easing', 'cassio' ),
		'description'     => esc_html__( 'The scroll will slow down with ease when reaching the page edges.', 'cassio' ),
		'section'         => 'smooth_scroll',
		'default'         => true,
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => 'enable_smooth_scroll',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);
