<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

$variant_primary = array(
	'100',
	'400',
	'400italic',
	'700',
	'700italic',
);

$variant_secondary = array(
	'400',
	'400italic',
	'italic',
	'700',
	'700italic',
);

$choices_primary   = arts_add_custom_choice();
$choices_secondary = arts_add_custom_choice();

$choices_primary['variant']   = $variant_primary;
$choices_secondary['variant'] = $variant_secondary;

/**
 * Primary Font
 */
new \Kirki\Field\Typography(
	array(
		'settings' => 'font_primary',
		'label'    => esc_html__( 'Primary Font', 'cassio' ),
		'section'  => 'fonts-options',
		'default'  => array(
			'font-family' => 'Roboto',
		),
		'priority' => $priority++,
		'choices'  => $choices_primary,
		'output'   => array(
			array(
				'element'  => ':root',
				'property' => '--font-primary',
				'choice'   => 'font-family',
			),
		),
	)
);

/**
 * Secondary Font
 */
new \Kirki\Field\Typography(
	array(
		'settings' => 'font_secondary',
		'label'    => esc_html__( 'Secondary Font', 'cassio' ),
		'section'  => 'fonts-options',
		'default'  => array(
			'font-family' => 'Playfair Display',
		),
		'priority' => $priority++,
		'choices'  => $choices_secondary,
		'output'   => array(
			array(
				'element'  => ':root',
				'property' => '--font-secondary',
				'choice'   => 'font-family',
			),
		),
	)
);

/**
 * Force Load All Fonts Variations
 */
new \Kirki\Field\Checkbox_Switch(
	array(
		'settings'    => 'force_load_all_fonts_variations',
		'label'       => esc_html__( 'Force Load All Selected Fonts Variations', 'cassio' ),
		'description' => esc_html__( 'Please also note that this may significantly decrease site loading speed if your font contains a lot of weights & styles.', 'cassio' ),
		'section'     => 'fonts-options',
		'default'     => false,
		'priority'    => $priority++,
	)
);
