<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * h1
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Heading 1', 'cassio' ),
		'settings' => 'h1_h6_generic_heading' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h1_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 65,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h1-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h1_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 34,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h1-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h1_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 1.28,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h1-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'h1_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h1-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'h1_h6_generic_divider' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * h2
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Heading 2', 'cassio' ),
		'settings' => 'h1_h6_generic_heading' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h2_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 52,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h2-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h2_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 30,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h2-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h2_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 1.38,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h2-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'h2_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h2-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'h1_h6_generic_divider' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * h3
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Heading 3', 'cassio' ),
		'settings' => 'h1_h6_generic_heading' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h3_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 42,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h3-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h3_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 26,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h3-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h3_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 1.57,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h3-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'h3_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h3-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'h1_h6_generic_divider' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * h4
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Heading 4', 'cassio' ),
		'settings' => 'h1_h6_generic_heading' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h4_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 33,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h4-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h4_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 22,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h4-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h4_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 1.61,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h4-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'h4_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h4-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'h1_h6_generic_divider' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * h5
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Heading 5', 'cassio' ),
		'settings' => 'h1_h6_generic_heading' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h5_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 20,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h5-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h5_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 18,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h5-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h5_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 1.7,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h5-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'h5_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h5-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'h1_h6_generic_divider' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * h6
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Heading 6', 'cassio' ),
		'settings' => 'h1_h6_generic_heading' . $priority,
		'section'  => 'h1_h6_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h6_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 20,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h6-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h6_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 16,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h6-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'h6_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 1.81,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h6-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'h6_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'h1_h6_headings',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--h6-font-weight',
			),
		),
	)
);
