<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * Paragraph
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Paragraph', 'cassio' ),
		'settings' => 'par_generic_heading' . $priority,
		'section'  => 'par_misc',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'par_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 18,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--paragraph-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'par_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 16,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--paragraph-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'par_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 1.75,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--paragraph-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'par_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 'normal',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--paragraph-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'par_generic_divider' . $priority,
		'section'  => 'par_misc',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * Subheading
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Small Subheading', 'cassio' ),
		'settings' => 'par_generic_heading' . $priority,
		'section'  => 'par_misc',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'subheading_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 13,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--subheading-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'subheading_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 11,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--subheading-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'subheading_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 1.75,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--subheading-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'subheading_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--subheading-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'par_generic_divider' . $priority,
		'section'  => 'par_misc',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * Blockquote
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Blockquote', 'cassio' ),
		'settings' => 'par_generic_heading' . $priority,
		'section'  => 'par_misc',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'blockquote_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 20,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--blockquote-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'blockquote_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 16,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--blockquote-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'blockquote_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 1.7,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--blockquote-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'blockquote_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'par_misc',
		'default'     => 'normal',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--blockquote-font-weight',
			),
		),
	)
);
