<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * Counter
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'Counter', 'cassio' ),
		'settings' => 'preloader_generic_heading' . $priority,
		'section'  => 'preloader_typography',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'preloader_counter_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'preloader_typography',
		'default'     => 107,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--preloader-counter-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'preloader_counter_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'preloader_typography',
		'default'     => 42,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--preloader-counter-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'preloader_counter_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'preloader_typography',
		'default'     => 1.1,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--preloader-counter-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'preloader_counter_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'preloader_typography',
		'default'     => '100',
		'priority'    => $priority++,
		'choices'     => array(
			'100'    => esc_html__( '100', 'cassio' ),
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--preloader-counter-font-weight',
			),
		),
	)
);
