<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$priority = 1;

/**
 * XXL Heading
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'XXL Heading', 'cassio' ),
		'settings' => 'xl_generic_heading' . $priority,
		'section'  => 'xl_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'xxl_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'xl_headings',
		'default'     => 167,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--xxl-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'xxl_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'xl_headings',
		'default'     => 42,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--xxl-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'xxl_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'xl_headings',
		'default'     => 1.1,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--xxl-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'xxl_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'xl_headings',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--xxl-font-weight',
			),
		),
	)
);

new \Kirki\Field\Generic(
	array(
		'settings' => 'xl_generic_divider' . $priority,
		'section'  => 'xl_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'hr',
		),
	)
);

/**
 * XL Heading
 */
new \Kirki\Field\Generic(
	array(
		'label'    => esc_html__( 'XL Heading', 'cassio' ),
		'settings' => 'xl_generic_heading' . $priority,
		'section'  => 'xl_headings',
		'priority' => $priority++,
		'choices'  => array(
			'element' => 'span',
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'xl_max_font_size',
		'description' => esc_html__( 'Desktop font size (px)', 'cassio' ),
		'section'     => 'xl_headings',
		'default'     => 107,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--xl-max-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'xl_min_font_size',
		'description' => esc_html__( 'Mobile font size (px)', 'cassio' ),
		'section'     => 'xl_headings',
		'default'     => 42,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 8,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--xl-min-font-size',
			),
		),
	)
);

new \Kirki\Field\Slider(
	array(
		'settings'    => 'xl_line_height',
		'description' => esc_html__( 'Line height (ratio)', 'cassio' ),
		'section'     => 'xl_headings',
		'default'     => 1.1,
		'priority'    => $priority++,
		'choices'     => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 0.1,
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--xl-line-height',
			),
		),
	)
);

new \Kirki\Field\Select(
	array(
		'settings'    => 'xl_font_weight',
		'description' => esc_html__( 'Font Weight', 'cassio' ),
		'section'     => 'xl_headings',
		'default'     => 'bold',
		'priority'    => $priority++,
		'choices'     => array(
			'normal' => esc_html__( 'Normal', 'cassio' ),
			'bold'   => esc_html__( 'Bold', 'cassio' ),
		),
		'transport'   => 'auto',
		'output'      => array(
			array(
				'element'  => ':root',
				'property' => '--xl-font-weight',
			),
		),
	)
);
