<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Hide ACF Menu
 */
add_filter( 'acf/settings/show_admin', '__return_false' );

add_action( 'acf/init', 'arts_acf_register_fields' );
if ( ! function_exists( 'arts_acf_register_fields' ) ) {
	/**
	 * Register ACF Fields
	 */
	function arts_acf_register_fields() {
		/**
		 * ACF Fields
		 */
		if ( function_exists( 'acf_add_local_field_group' ) ) {
			acf_add_local_field_group(
				array(
					'key'                   => 'group_5d591b18b478b',
					'title'                 => esc_html__( 'Additional Content', 'cassio' ),
					'fields'                => array(
						array(
							'key'               => 'field_5d591b3da42a1',
							'label'             => esc_html__( 'Subheading', 'cassio' ),
							'name'              => 'subheading',
							'type'              => 'textarea',
							'instructions'      => '',
							'required'          => 0,
							'conditional_logic' => 0,
							'wrapper'           => array(
								'width' => '',
								'class' => '',
								'id'    => '',
							),
							'default_value'     => '',
							'placeholder'       => '',
							'maxlength'         => '',
							'rows'              => '',
							'new_lines'         => 'br',
						),
						array(
							'key'               => 'field_5d591b7f53d11',
							'label'             => esc_html__( 'Secondary Featured Image', 'cassio' ),
							'name'              => 'secondary_image',
							'type'              => 'image',
							'instructions'      => '',
							'required'          => 0,
							'conditional_logic' => 0,
							'wrapper'           => array(
								'width' => '',
								'class' => '',
								'id'    => '',
							),
							'return_format'     => 'id',
							'preview_size'      => 'medium',
							'library'           => 'all',
							'min_width'         => '',
							'min_height'        => '',
							'min_size'          => '',
							'max_width'         => '',
							'max_height'        => '',
							'max_size'          => '',
							'mime_types'        => '',
						),
						array(
							'key'               => 'field_5d67363183770',
							'label'             => esc_html__( 'Featured Video', 'cassio' ),
							'name'              => 'video',
							'type'              => 'file',
							'instructions'      => esc_html__( 'Upload a video that can be used as a masthead background or as a slide in portfolio sliders.', 'cassio' ),
							'required'          => 0,
							'conditional_logic' => 0,
							'wrapper'           => array(
								'width' => '',
								'class' => '',
								'id'    => '',
							),
							'return_format'     => 'url',
							'library'           => 'all',
							'min_size'          => '',
							'max_size'          => '',
							'mime_types'        => 'mp4, webm, ogg, ogv',
						),
					),
					'location'              => array(
						array(
							array(
								'param'    => 'post_type',
								'operator' => '==',
								'value'    => 'arts_portfolio_item',
							),
						),
						array(
							array(
								'param'    => 'post_type',
								'operator' => '==',
								'value'    => 'arts_service',
							),
						),
						array(
							array(
								'param'    => 'post_type',
								'operator' => '==',
								'value'    => 'page',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen'        => '',
					'active'                => true,
					'description'           => '',
				)
			);

			// audio background
			acf_add_local_field_group(
				array(
					'key'                   => 'group_5e1838cc3fbe9',
					'title'                 => esc_html__( 'Audio Background', 'cassio' ),
					'fields'                => array(
						array(
							'key'               => 'field_5e18393bc3eee',
							'label'             => esc_html__( 'Audio File', 'cassio' ),
							'name'              => 'audio_file',
							'type'              => 'file',
							'instructions'      => get_theme_mod( 'enable_master_audio_background', false ) ? '' : sprintf(
								'%1s<p class="notice">%2s <a href="%3s" target="_blank">%4s</a></p>',
								esc_html__( 'Upload *.mp3, *.wav, *.ogg audio file', 'cassio' ),
								esc_html__( 'Please make sure you have enabled audio backgrounds in', 'cassio' ),
								admin_url( 'customize.php' ),
								esc_html__( 'WordPress Customizer.', 'cassio' )
							),
							'required'          => 0,
							'conditional_logic' => 0,
							'wrapper'           => array(
								'width' => '',
								'class' => '',
								'id'    => '',
							),
							'return_format'     => 'url',
							'library'           => 'all',
							'min_size'          => '',
							'max_size'          => '',
							'mime_types'        => 'mp3, wav, ogg',
						),
						array(
							'key'               => 'field_5e183995c3eef',
							'label'             => esc_html__( 'When a Visitor Lands on This Page...', 'cassio' ),
							'name'              => 'audio_ajax_options',
							'type'              => 'radio',
							'instructions'      => '',
							'required'          => 0,
							'conditional_logic' => 0,
							'wrapper'           => array(
								'width' => '',
								'class' => '',
								'id'    => '',
							),
							'choices'           => array(
								'music_off'   => esc_html__( 'Disable any Audio and Hide Player', 'cassio' ),
								'play_global' => esc_html__( 'Play Global Audio Background set from Customizer', 'cassio' ),
								'play'        => esc_html__( 'Play This Page Audio Background', 'cassio' ),
							),
							'allow_null'        => 0,
							'other_choice'      => 0,
							'default_value'     => 'play_global',
							'layout'            => 'vertical',
							'return_format'     => 'value',
							'save_other_choice' => 0,
						),
					),
					'location'              => array(
						array(
							array(
								'param'    => 'post_type',
								'operator' => '==',
								'value'    => 'page',
							),
						),
						array(
							array(
								'param'    => 'post_type',
								'operator' => '==',
								'value'    => 'arts_portfolio_item',
							),
						),
						array(
							array(
								'param'    => 'post_type',
								'operator' => '==',
								'value'    => 'arts_service',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen'        => '',
					'active'                => true,
					'description'           => '',
				)
			);

			// custom fonts fields
			acf_add_local_field_group(
				array(
					'key'                   => 'group_5da01c79399ce',
					'title'                 => esc_html__( 'Custom Fonts', 'cassio' ),
					'fields'                => array(
						array(
							'key'               => 'field_5da01caa50c9a',
							'label'             => '',
							'name'              => 'custom_fonts',
							'type'              => 'repeater',
							'instructions'      => '',
							'required'          => 0,
							'conditional_logic' => 0,
							'wrapper'           => array(
								'width' => '',
								'class' => '',
								'id'    => '',
							),
							'collapsed'         => 'field_5da01cfa50c9b',
							'min'               => 0,
							'max'               => 0,
							'layout'            => 'block',
							'button_label'      => esc_html__( 'Add Custom Font', 'cassio' ),
							'sub_fields'        => array(
								array(
									'key'               => 'field_5da01cfa50c9b',
									'label'             => esc_html__( 'Font Family Name', 'cassio' ),
									'name'              => 'font_name',
									'type'              => 'text',
									'instructions'      => '',
									'required'          => 1,
									'conditional_logic' => 0,
									'wrapper'           => array(
										'width' => '',
										'class' => '',
										'id'    => '',
									),
									'default_value'     => '',
									'placeholder'       => '',
									'prepend'           => '',
									'append'            => '',
									'maxlength'         => '',
								),
								array(
									'key'               => 'field_5da3c469ba39d',
									'label'             => esc_html__( 'Font Display', 'cassio' ),
									'name'              => 'font_display',
									'type'              => 'select',
									'instructions'      => sprintf(
										'<a href="https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display" target="_blank">%1s</a> %2s',
										esc_html__( 'More information', 'cassio' ),
										esc_html__( 'related to "font-display" descriptor.', 'cassio' )
									),
									'required'          => 1,
									'conditional_logic' => 0,
									'wrapper'           => array(
										'width' => '',
										'class' => '',
										'id'    => '',
									),
									'choices'           => array(
										'auto'     => 'auto',
										'block'    => 'block',
										'swap'     => 'swap',
										'fallback' => 'fallback',
										'optional' => 'optional',
									),
									'default_value'     => array(
										0 => 'auto',
									),
									'allow_null'        => 0,
									'multiple'          => 0,
									'ui'                => 0,
									'return_format'     => 'value',
									'ajax'              => 0,
									'placeholder'       => '',
								),
								array(
									'key'               => 'field_5da01d3550c9c',
									'label'             => esc_html__( 'Font Files', 'cassio' ),
									'name'              => 'font_files',
									'type'              => 'repeater',
									'instructions'      => '',
									'required'          => 1,
									'conditional_logic' => 0,
									'wrapper'           => array(
										'width' => '',
										'class' => '',
										'id'    => '',
									),
									'collapsed'         => 'field_5da01e9550c9e',
									'min'               => 0,
									'max'               => 0,
									'layout'            => 'block',
									'button_label'      => esc_html__( 'Add Font File', 'cassio' ),
									'sub_fields'        => array(
										array(
											'key'          => 'field_5da01d7250c9d',
											'label'        => 'Font File',
											'name'         => 'font_file',
											'type'         => 'file',
											'instructions' => esc_html__( 'Upload .woff or .woff2 font file', 'cassio' ),
											'required'     => 1,
											'conditional_logic' => 0,
											'wrapper'      => array(
												'width' => '',
												'class' => '',
												'id'    => '',
											),
											'return_format' => 'array',
											'library'      => 'all',
											'min_size'     => '',
											'max_size'     => '',
											'mime_types'   => 'woff, woff2',
										),
										array(
											'key'          => 'field_5da01e9550c9e',
											'label'        => esc_html__( 'Font Weight', 'cassio' ),
											'name'         => 'font_weight',
											'type'         => 'select',
											'instructions' => esc_html__( 'Select a font weight of the uploaded font file', 'cassio' ),
											'required'     => 1,
											'conditional_logic' => 0,
											'wrapper'      => array(
												'width' => '',
												'class' => '',
												'id'    => '',
											),
											'choices'      => array(
												100 => esc_html__( '100 (Thin)', 'cassio' ),
												'100italic' => esc_html__( '100i (Thin Italic)', 'cassio' ),
												200 => esc_html__( ' 200 (Ultra Light)', 'cassio' ),
												'200italic' => esc_html__( '200i (Ultra Light Italic)', 'cassio' ),
												300 => esc_html__( ' 300 (Light)', 'cassio' ),
												'300italic' => esc_html__( '300i (Light Italic)', 'cassio' ),
												400 => esc_html__( '400 (Regular)', 'cassio' ),
												'400italic' => esc_html__( '400i (Regular Italic)', 'cassio' ),
												500 => esc_html__( '500 (Medium)', 'cassio' ),
												'500italic' => esc_html__( '500i (Medium Italic)', 'cassio' ),
												600 => esc_html__( '600 (Semi Bold)', 'cassio' ),
												'600italic' => esc_html__( '600i (Semi Bold Italic)', 'cassio' ),
												700 => esc_html__( '700 (Bold)', 'cassio' ),
												'700italic' => esc_html__( '700i (Bold Italic)', 'cassio' ),
												800 => esc_html__( '800 (Extra Bold)', 'cassio' ),
												'800italic' => esc_html__( '800i (Extra Bold Italic)', 'cassio' ),
												900 => esc_html__( '900 (Black)', 'cassio' ),
												'900italic' => esc_html__( '900i (Black Italic)', 'cassio' ),
											),
											'default_value' => array(),
											'allow_null'   => 0,
											'multiple'     => 0,
											'ui'           => 0,
											'return_format' => 'value',
											'ajax'         => 0,
											'placeholder'  => '',
										),
									),
								),
							),
						),
					),
					'location'              => array(
						array(
							array(
								'param'    => 'options_page',
								'operator' => '==',
								'value'    => 'custom-fonts-settings',
							),
						),
					),
					'menu_order'            => 0,
					'position'              => 'normal',
					'style'                 => 'default',
					'label_placement'       => 'top',
					'instruction_placement' => 'label',
					'hide_on_screen'        => '',
					'active'                => true,
					'description'           => '',
				)
			);
		}

		/**
		 * Custom Fonts Admin Page
		 */
		if ( function_exists( 'acf_add_options_page' ) ) {
			acf_add_options_page(
				array(
					'page_title'      => 'Custom Fonts',
					'menu_title'      => 'Custom Fonts',
					'menu_slug'       => 'custom-fonts-settings',
					'capability'      => 'customize',
					'icon_url'        => 'dashicons-editor-textcolor',
					'update_button'   => esc_html__( 'Save Changes', 'cassio' ),
					'updated_message' => sprintf(
						'%1s <a href="%2s" target="_blank">%3s</a>',
						esc_html__( 'Fonts are saved and ready to use from', 'cassio' ),
						admin_url( 'customize.php' ),
						esc_html__( 'WordPress Customizer.', 'cassio' )
					),
				)
			);
		}
	}
}
