<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Add Custom Icons to Elementor Panel
 */
add_action( 'elementor/controls/controls_registered', 'arts_add_elementor_icons' );
if ( ! function_exists( 'arts_add_elementor_icons' ) ) {
	function arts_add_elementor_icons( $controls_registry ) {
		$theme_icons = array(
			'lnr lnr-home'                 => 'lnr-home',
			'lnr lnr-apartment'            => 'lnr-apartment',
			'lnr lnr-pencil'               => 'lnr-pencil',
			'lnr lnr-magic-wand'           => 'lnr-magic-wand',
			'lnr lnr-drop'                 => 'lnr-drop',
			'lnr lnr-lighter'              => 'lnr-lighter',
			'lnr lnr-poop'                 => 'lnr-poop',
			'lnr lnr-sun'                  => 'lnr-sun',
			'lnr lnr-moon'                 => 'lnr-moon',
			'lnr lnr-cloud'                => 'lnr-cloud',
			'lnr lnr-cloud-upload'         => 'lnr-cloud-upload',
			'lnr lnr-cloud-download'       => 'lnr-cloud-download',
			'lnr lnr-cloud-sync'           => 'lnr-cloud-sync',
			'lnr lnr-cloud-check'          => 'lnr-cloud-check',
			'lnr lnr-database'             => 'lnr-database',
			'lnr lnr-lock'                 => 'lnr-lock',
			'lnr lnr-cog'                  => 'lnr-cog',
			'lnr lnr-trash'                => 'lnr-trash',
			'lnr lnr-dice'                 => 'lnr-dice',
			'lnr lnr-heart'                => 'lnr-heart',
			'lnr lnr-star'                 => 'lnr-star',
			'lnr lnr-star-half'            => 'lnr-star-half',
			'lnr lnr-star-empty'           => 'lnr-star-empty',
			'lnr lnr-flag'                 => 'lnr-flag',
			'lnr lnr-envelope'             => 'lnr-envelope',
			'lnr lnr-paperclip'            => 'lnr-paperclip',
			'lnr lnr-inbox'                => 'lnr-inbox',
			'lnr lnr-eye'                  => 'lnr-eye',
			'lnr lnr-printer'              => 'lnr-printer',
			'lnr lnr-file-empty'           => 'lnr-file-empty',
			'lnr lnr-file-add'             => 'lnr-file-add',
			'lnr lnr-enter'                => 'lnr-enter',
			'lnr lnr-exit'                 => 'lnr-exit',
			'lnr lnr-graduation-hat'       => 'lnr-graduation-hat',
			'lnr lnr-license'              => 'lnr-license',
			'lnr lnr-music-note'           => 'lnr-music-note',
			'lnr lnr-film-play'            => 'lnr-film-play',
			'lnr lnr-camera-video'         => 'lnr-camera-video',
			'lnr lnr-camera'               => 'lnr-camera',
			'lnr lnr-picture'              => 'lnr-picture',
			'lnr lnr-book'                 => 'lnr-book',
			'lnr lnr-bookmark'             => 'lnr-bookmark',
			'lnr lnr-user'                 => 'lnr-user',
			'lnr lnr-users'                => 'lnr-users',
			'lnr lnr-shirt'                => 'lnr-shirt',
			'lnr lnr-store'                => 'lnr-store',
			'lnr lnr-cart'                 => 'lnr-cart',
			'lnr lnr-tag'                  => 'lnr-tag',
			'lnr lnr-phone-handset'        => 'lnr-phone-handset',
			'lnr lnr-phone'                => 'lnr-phone',
			'lnr lnr-pushpin'              => 'lnr-pushpin',
			'lnr lnr-map-marker'           => 'lnr-map-marker',
			'lnr lnr-map'                  => 'lnr-map',
			'lnr lnr-location'             => 'lnr-location',
			'lnr lnr-calendar-full'        => 'lnr-calendar-full',
			'lnr lnr-keyboard'             => 'lnr-keyboard',
			'lnr lnr-spell-check'          => 'lnr-spell-check',
			'lnr lnr-screen'               => 'lnr-screen',
			'lnr lnr-smartphone'           => 'lnr-smartphone',
			'lnr lnr-tablet'               => 'lnr-tablet',
			'lnr lnr-laptop'               => 'lnr-laptop',
			'lnr lnr-laptop-phone'         => 'lnr-laptop-phone',
			'lnr lnr-power-switch'         => 'lnr-power-switch',
			'lnr lnr-bubble'               => 'lnr-bubble',
			'lnr lnr-heart-pulse'          => 'lnr-heart-pulse',
			'lnr lnr-construction'         => 'lnr-construction',
			'lnr lnr-pie-chart'            => 'lnr-pie-chart',
			'lnr lnr-chart-bars'           => 'lnr-chart-bars',
			'lnr lnr-gift'                 => 'lnr-gift',
			'lnr lnr-diamond'              => 'lnr-diamond',
			'lnr lnr-linearicons'          => 'lnr-linearicons',
			'lnr lnr-dinner'               => 'lnr-dinner',
			'lnr lnr-coffee-cup'           => 'lnr-coffee-cup',
			'lnr lnr-leaf'                 => 'lnr-leaf',
			'lnr lnr-paw'                  => 'lnr-paw',
			'lnr lnr-rocket'               => 'lnr-rocket',
			'lnr lnr-briefcase'            => 'lnr-briefcase',
			'lnr lnr-bus'                  => 'lnr-bus',
			'lnr lnr-car'                  => 'lnr-car',
			'lnr lnr-train'                => 'lnr-train',
			'lnr lnr-bicycle'              => 'lnr-bicycle',
			'lnr lnr-wheelchair'           => 'lnr-wheelchair',
			'lnr lnr-select'               => 'lnr-select',
			'lnr lnr-earth'                => 'lnr-earth',
			'lnr lnr-smile'                => 'lnr-smile',
			'lnr lnr-sad'                  => 'lnr-sad',
			'lnr lnr-neutral'              => 'lnr-neutral',
			'lnr lnr-mustache'             => 'lnr-mustache',
			'lnr lnr-alarm'                => 'lnr-alarm',
			'lnr lnr-bullhorn'             => 'lnr-bullhorn',
			'lnr lnr-volume-high'          => 'lnr-volume-high',
			'lnr lnr-volume-medium'        => 'lnr-volume-medium',
			'lnr lnr-volume-low'           => 'lnr-volume-low',
			'lnr lnr-volume'               => 'lnr-volume',
			'lnr lnr-mic'                  => 'lnr-mic',
			'lnr lnr-hourglass'            => 'lnr-hourglass',
			'lnr lnr-undo'                 => 'lnr-undo',
			'lnr lnr-redo'                 => 'lnr-redo',
			'lnr lnr-sync'                 => 'lnr-sync',
			'lnr lnr-history'              => 'lnr-history',
			'lnr lnr-clock'                => 'lnr-clock',
			'lnr lnr-download'             => 'lnr-download',
			'lnr lnr-upload'               => 'lnr-upload',
			'lnr lnr-enter-down'           => 'lnr-enter-down',
			'lnr lnr-exit-up'              => 'lnr-exit-up',
			'lnr lnr-bug'                  => 'lnr-bug',
			'lnr lnr-code'                 => 'lnr-code',
			'lnr lnr-link'                 => 'lnr-link',
			'lnr lnr-unlink'               => 'lnr-unlink',
			'lnr lnr-thumbs-up'            => 'lnr-thumbs-up',
			'lnr lnr-thumbs-down'          => 'lnr-thumbs-down',
			'lnr lnr-magnifier'            => 'lnr-magnifier',
			'lnr lnr-cross'                => 'lnr-cross',
			'lnr lnr-menu'                 => 'lnr-menu',
			'lnr lnr-list'                 => 'lnr-list',
			'lnr lnr-chevron-up'           => 'lnr-chevron-up',
			'lnr lnr-chevron-down'         => 'lnr-chevron-down',
			'lnr lnr-chevron-left'         => 'lnr-chevron-left',
			'lnr lnr-chevron-right'        => 'lnr-chevron-right',
			'lnr lnr-arrow-up'             => 'lnr-arrow-up',
			'lnr lnr-arrow-down'           => 'lnr-arrow-down',
			'lnr lnr-arrow-left'           => 'lnr-arrow-left',
			'lnr lnr-arrow-right'          => 'lnr-arrow-right',
			'lnr lnr-move'                 => 'lnr-move',
			'lnr lnr-warning'              => 'lnr-warning',
			'lnr lnr-question-circle'      => 'lnr-question-circle',
			'lnr lnr-menu-circle'          => 'lnr-menu-circle',
			'lnr lnr-checkmark-circle'     => 'lnr-checkmark-circle',
			'lnr lnr-cross-circle'         => 'lnr-cross-circle',
			'lnr lnr-plus-circle'          => 'lnr-plus-circle',
			'lnr lnr-circle-minus'         => 'lnr-circle-minus',
			'lnr lnr-arrow-up-circle'      => 'lnr-arrow-up-circle',
			'lnr lnr-arrow-down-circle'    => 'lnr-arrow-down-circle',
			'lnr lnr-arrow-left-circle'    => 'lnr-arrow-left-circle',
			'lnr lnr-arrow-right-circle'   => 'lnr-arrow-right-circle',
			'lnr lnr-chevron-up-circle'    => 'lnr-chevron-up-circle',
			'lnr lnr-chevron-down-circle'  => 'lnr-chevron-down-circle',
			'lnr lnr-chevron-left-circle'  => 'lnr-chevron-left-circle',
			'lnr lnr-chevron-right-circle' => 'lnr-chevron-right-circle',
			'lnr lnr-crop'                 => 'lnr-crop',
			'lnr lnr-frame-expand'         => 'lnr-frame-expand',
			'lnr lnr-frame-contract'       => 'lnr-frame-contract',
			'lnr lnr-layers'               => 'lnr-layers',
			'lnr lnr-funnel'               => 'lnr-funnel',
			'lnr lnr-text-format'          => 'lnr-text-format',
			'lnr lnr-text-format-remove'   => 'lnr-text-format-remove',
			'lnr lnr-text-size'            => 'lnr-text-size',
			'lnr lnr-bold'                 => 'lnr-bold',
			'lnr lnr-italic'               => 'lnr-italic',
			'lnr lnr-underline'            => 'lnr-underline',
			'lnr lnr-strikethrough'        => 'lnr-strikethrough',
			'lnr lnr-highlight'            => 'lnr-highlight',
			'lnr lnr-text-align-left'      => 'lnr-text-align-left',
			'lnr lnr-text-align-center'    => 'lnr-text-align-center',
			'lnr lnr-text-align-right'     => 'lnr-text-align-right',
			'lnr lnr-text-align-justify'   => 'lnr-text-align-justify',
			'lnr lnr-line-spacing'         => 'lnr-line-spacing',
			'lnr lnr-indent-increase'      => 'lnr-indent-increase',
			'lnr lnr-indent-decrease'      => 'lnr-indent-decrease',
			'lnr lnr-pilcrow'              => 'lnr-pilcrow',
			'lnr lnr-direction-ltr'        => 'lnr-direction-ltr',
			'lnr lnr-direction-rtl'        => 'lnr-direction-rtl',
			'lnr lnr-page-break'           => 'lnr-page-break',
			'lnr lnr-sort-alpha-asc'       => 'lnr-sort-alpha-asc',
			'lnr lnr-sort-amount-asc'      => 'lnr-sort-amount-asc',
			'lnr lnr-hand'                 => 'lnr-hand',
			'lnr lnr-pointer-up'           => 'lnr-pointer-up',
			'lnr lnr-pointer-right'        => 'lnr-pointer-right',
			'lnr lnr-pointer-down'         => 'lnr-pointer-down',
			'lnr lnr-pointer-left'         => 'lnr-pointer-left',
		);

		$icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );
		$icons = array_merge( $theme_icons, $icons );
		$controls_registry->get_control( 'icon' )->set_settings( 'options', $icons );

		wp_enqueue_style( 'linear-icons', ARTS_THEME_URL . '/css/linear-icons.min.css', array(), ARTS_THEME_VERSION );
	}
}
