<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once ARTS_THEME_PATH . '/inc/classes/class-arts-add-custom-fonts.php';

/**
 * Initialize custom fonts
 */
add_action( 'after_setup_theme', 'arts_init_custom_fonts' );
if ( ! function_exists( 'arts_init_custom_fonts' ) ) {
	function arts_init_custom_fonts() {
		\Arts_Add_Custom_Fonts::instance();
	}
}

/**
 * Add custom fonts choice
 */
function arts_add_custom_choice() {
	return array(
		'fonts' => apply_filters( 'arts/kirki_font_choices', array() ),
	);
}

/**
 * Force Load all fonts variations (Kirki)
 */
add_action( 'after_setup_theme', 'arts_font_add_all_variants', 100 );
if ( ! function_exists( 'arts_font_add_all_variants' ) ) {
	function arts_font_add_all_variants() {
		$force_load_all_fonts_variations = get_theme_mod( 'force_load_all_fonts_variations', false );

		if ( class_exists( 'Kirki_Fonts_Google' ) && $force_load_all_fonts_variations ) {
			/** @disregard P1009 Assuming that the class exists in here */
			/** @disregard P1014 Assuming that the static property exists in here */
			Kirki_Fonts_Google::$force_load_all_variants = true;
		}
	}
}
