<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

/**
 * Enqueue Theme CSS Files
 */
add_action( 'wp_enqueue_scripts', 'arts_enqueue_styles', 20 );
if ( ! function_exists( 'arts_enqueue_styles' ) ) {
	function arts_enqueue_styles() {
		$typography_primary      = get_theme_mod( 'font_primary', true );
		$typography_secondary    = get_theme_mod( 'font_secondary', true );
		$enable_cf_7_modals      = get_theme_mod( 'enable_cf_7_modals', true );
		$enable_loading_progress = get_theme_mod( 'enable_loading_progress', true );
		$ajax_enabled            = get_theme_mod( 'enable_ajax', false );

		// Force load Elementor assets
		// on non-Elementor pages with AJAX turned on
		if ( class_exists( '\Elementor\Frontend' ) && ! Utilities::is_built_with_elementor() && $ajax_enabled ) {
			\Elementor\Frontend::instance()->enqueue_styles();
			wp_enqueue_style( 'elementor-post-holder', ARTS_THEME_URL . '/css/elementor-post-holder.min.css', array( 'elementor-common' ), ARTS_THEME_VERSION );
			wp_add_inline_style( 'elementor-post-holder', ' ' );
		}

		wp_enqueue_style( 'bootstrap-grid', ARTS_THEME_URL . '/css/bootstrap-grid.min.css', array(), '4.1.3' );
		wp_enqueue_style( 'bootstrap-reboot', ARTS_THEME_URL . '/css/bootstrap-reboot.min.css', array(), '4.1.3' );
		wp_enqueue_style( 'font-awesome', ARTS_THEME_URL . '/css/font-awesome.min.min.css', array(), '4.7.0' );
		wp_enqueue_style( 'material-icons', ARTS_THEME_URL . '/css/material-icons.min.css', array(), '3.0.1' );
		wp_enqueue_style( 'linear-icons', ARTS_THEME_URL . '/css/linear-icons.min.css', array(), '1.0.0' );
		wp_enqueue_style( 'magnific-popup', ARTS_THEME_URL . '/css/magnific-popup.min.css', array(), '1.1.0' );
		wp_enqueue_style( 'cassio-main-style', ARTS_THEME_URL . '/css/main.css', array(), ARTS_THEME_VERSION );
		wp_enqueue_style( 'cassio-theme-style', ARTS_THEME_URL . '/style.css', array(), ARTS_THEME_VERSION );

		// fallback font if fonts are not set
		if ( ! class_exists( 'Kirki' ) || ! $typography_primary || ! $typography_secondary ) {
			wp_enqueue_style( 'cassio-fonts', '//fonts.googleapis.com/css?family=Roboto:100,400,400i,700,700i%7CPlayfair+Display:400,400i,700,700i&display=swap', array(), ARTS_THEME_VERSION );
		}

		// hide default Contact Form 7 response boxes if custom modals are enabled
		if ( $enable_cf_7_modals ) {
			wp_add_inline_style( 'contact-form-7', trim( '.wpcf7-mail-sent-ok, .wpcf7 form.sent .wpcf7-response-output, .wpcf7-mail-sent-ng, .wpcf7 form.failed .wpcf7-response-output { display: none !important; }' ) );
		}

		// enable system "progress" cursor
		if ( $enable_loading_progress ) {
			wp_add_inline_style( 'cassio-main-style', trim( '.cursor-progress, .cursor-progress * { cursor: progress; }' ) );
		}
	}
}

/**
 * Enqueue Modernizr & Polyfills
 */
add_action( 'wp_enqueue_scripts', 'arts_enqueue_polyfills', 20 );
if ( ! function_exists( 'arts_enqueue_polyfills' ) ) {
	function arts_enqueue_polyfills() {
		$outdated_browsers_enabled = get_theme_mod( 'outdated_browsers_enabled', true );

		if ( $outdated_browsers_enabled ) {
			wp_enqueue_script( 'outdated-browser-rework', ARTS_THEME_URL . '/js/outdated-browser-rework.min.js', array(), '1.1.0', false );
		}

		wp_enqueue_script( 'modernizr', ARTS_THEME_URL . '/js/modernizr.custom.min.js', array(), '3.6.0', false );
	}
}

/**
 * Enqueue Theme JS Files
 */
add_action( 'wp_enqueue_scripts', 'arts_enqueue_scripts', 50 );
if ( ! function_exists( 'arts_enqueue_scripts' ) ) {
	function arts_enqueue_scripts() {
		$ajax_enabled          = get_theme_mod( 'enable_ajax', false );
		$smooth_scroll_enabled = get_theme_mod( 'enable_smooth_scroll', false );
		$gmap_api_key          = arts_get_gmap_key();
		$main_script_deps      = array(
			'modernizr',
			'jquery',
			'isotope',
			'imagesloaded',
		);
		$enable_cf_7_modals    = get_theme_mod( 'enable_cf_7_modals', true );

		wp_register_script( 'three', ARTS_THEME_URL . '/js/three.min.js', array(), 'r120', true );

		// Force load Elementor assets
		// on non-Elementor pages with AJAX turned on
		if ( class_exists( '\Elementor\Frontend' ) && ! Utilities::is_built_with_elementor() && $ajax_enabled ) {
			\Elementor\Frontend::instance()->enqueue_scripts();
		}

		if ( is_singular() && comments_open() ) {
			wp_enqueue_script( 'comment-reply' );
		}

		if ( $ajax_enabled ) {
			wp_enqueue_script( 'barba', ARTS_THEME_URL . '/js/barba.umd.min.js', array( 'jquery' ), '2.9.7', true );
			$main_script_deps [] = 'barba';
		}

		if ( $smooth_scroll_enabled ) {
			wp_enqueue_script( 'smooth-scrollbar', ARTS_THEME_URL . '/js/smooth-scrollbar.min.js', array( 'jquery' ), '8.4.1', true );
			wp_enqueue_script( 'lockscroll', ARTS_THEME_URL . '/js/lockscroll.min.js', array( 'smooth-scrollbar' ), ARTS_THEME_VERSION, true );
			wp_enqueue_script( 'edge-easing', ARTS_THEME_URL . '/js/edgeEasing.min.js', array( 'smooth-scrollbar' ), ARTS_THEME_VERSION, true );
			$main_script_deps [] = 'smooth-scrollbar';
		}

		if ( $enable_cf_7_modals ) {
			wp_enqueue_script( 'bootstrap-modal', ARTS_THEME_URL . '/js/bootstrap-modal.min.js', array( 'jquery', 'bootstrap-util' ), '4.1.3', true );
			wp_enqueue_script( 'bootstrap-util', ARTS_THEME_URL . '/js/bootstrap-util.min.js', array( 'jquery' ), '4.1.3', true );
		}

		wp_enqueue_script( 'imagesloaded' );
		wp_enqueue_script( 'animation-gsap', ARTS_THEME_URL . '/js/animation.gsap.min.js', array( 'scrollmagic', 'tweenmax' ), '2.0.5', true );
		wp_enqueue_script( 'drawsvg-plugin', ARTS_THEME_URL . '/js/DrawSVGPlugin.min.js', array( 'tweenmax' ), '0.2.1', true );
		wp_enqueue_script( 'isotope', ARTS_THEME_URL . '/js/isotope.pkgd.min.js', array(), '3.0.6', true );
		wp_enqueue_script( 'jquery-art-parallax', ARTS_THEME_URL . '/js/jquery.artParallax.min.js', array( 'jquery', 'scrollmagic', 'tweenmax' ), ARTS_THEME_VERSION, true );
		wp_enqueue_script( 'jquery-get-all-attributes', ARTS_THEME_URL . '/js/jquery.getAllAttributes.min.js', array( 'jquery' ), ARTS_THEME_VERSION, true );
		wp_enqueue_script( 'jquery-lazy', ARTS_THEME_URL . '/js/jquery.lazy.min.js', array( 'jquery' ), '1.7.10', true );
		wp_enqueue_script( 'jquery-lazy-plugins', ARTS_THEME_URL . '/js/jquery.lazy.plugins.min.js', array( 'jquery', 'jquery-lazy' ), '1.7.10', true );
		wp_enqueue_script( 'jquery-magnific-popup', ARTS_THEME_URL . '/js/jquery.magnific-popup.min.js', array( 'jquery' ), '1.1.0', true );
		wp_enqueue_script( 'jquery-scrollmagic', ARTS_THEME_URL . '/js/jquery.ScrollMagic.min.js', array( 'scrollmagic' ), '2.0.5', true );
		wp_enqueue_script( 'morph-svg-plugin', ARTS_THEME_URL . '/js/MorphSVGPlugin.min.js', array( 'tweenmax' ), '0.9.1', true );
		wp_enqueue_script( 'scrollmagic', ARTS_THEME_URL . '/js/ScrollMagic.min.js', array(), '2.0.7', true );
		wp_enqueue_script( 'split-text', ARTS_THEME_URL . '/js/SplitText.min.js', array( 'tweenmax' ), '0.7.0', true );
		wp_enqueue_script( 'tweenmax', ARTS_THEME_URL . '/js/TweenMax.min.js', array(), '2.1.3', true );
		wp_enqueue_script( 'cassio-components', ARTS_THEME_URL . '/js/components.js', $main_script_deps, ARTS_THEME_VERSION, true );

		if ( $gmap_api_key ) {
			wp_register_script(
				'googlemap',
				esc_url( '//maps.googleapis.com/maps/api/js?loading=async&callback=setGoogleMapLoaded&key=' . $gmap_api_key ),
				array( 'cassio-components' ),
				null,
				array(
					'in_footer' => true,
					'strategy'  => 'async',
				)
			);

			wp_add_inline_script(
				'googlemap',
				'function setGoogleMapLoaded() { window.googleMapLoaded = true; } window.googleMapLoaded = new Promise((resolve) => { setGoogleMapLoaded = resolve; });',
				'before'
			);
		}
	}
}

/**
 * Enqueue Elementor Editor Assets
 */
add_action( 'elementor/editor/after_enqueue_scripts', 'arts_enqueue_elementor_preview_scripts', 99 );
if ( ! function_exists( 'arts_enqueue_elementor_preview_scripts' ) ) {
	function arts_enqueue_elementor_preview_scripts() {
		wp_enqueue_script( 'cassio-elementor-preview', ARTS_THEME_URL . '/js/elementor-preview.min.js', array(), ARTS_THEME_VERSION, true );
	}
}

/**
 * Enqueue Customizer Live Preview Script
 */
add_action( 'customize_preview_init', 'arts_customize_preview_script' );
if ( ! function_exists( 'arts_customize_preview_script' ) ) {
	function arts_customize_preview_script() {
		wp_enqueue_script( 'cassio-customizer-preview', ARTS_THEME_URL . '/js/customizer.min.js', array(), ARTS_THEME_VERSION, true );
	}
}

/**
 * Localize Theme Options
 */
add_action( 'wp_enqueue_scripts', 'arts_localize_data', 60 );
if ( ! function_exists( 'arts_localize_data' ) ) {
	function arts_localize_data() {
		$smc_trigger_hook = get_theme_mod( 'smc_trigger_hook', 0.85 );

		$animation_on_scroll_reveal_timescale   = get_theme_mod( 'animation_on_scroll_reveal_timescale', 1 );
		$animation_overlay_menu_open_timescale  = get_theme_mod( 'animation_overlay_menu_open_timescale', 1 );
		$animation_overlay_menu_close_timescale = get_theme_mod( 'animation_overlay_menu_close_timescale', 1.5 );
		$animation_preloader_timescale          = get_theme_mod( 'animation_preloader_timescale', 0.9 );
		$animation_flying_headings_stagger      = get_theme_mod( 'animation_flying_headings_stagger', 0.15 );

		$ajax_enabled                       = get_theme_mod( 'enable_ajax', false );
		$ajax_prevent_rules                 = get_theme_mod( 'ajax_prevent_rules' );
		$ajax_prevent_woocommerce_pages     = get_theme_mod( 'ajax_prevent_woocommerce_pages', false );
		$ajax_eval_inline_container_scripts = get_theme_mod( 'ajax_eval_inline_container_scripts', false );
		$ajax_load_missing_scripts          = get_theme_mod( 'ajax_load_missing_scripts', false );
		$ajax_load_missing_styles           = get_theme_mod( 'ajax_load_missing_styles', false );
		$ajax_update_script_nodes           = get_theme_mod( 'ajax_update_script_nodes' );

		$enable_smooth_scroll           = get_theme_mod( 'enable_smooth_scroll', false );
		$smooth_scroll_damping          = get_theme_mod( 'smooth_scroll_damping', 0.06 );
		$smooth_scroll_render_by_pixels = get_theme_mod( 'smooth_scroll_render_by_pixels', true );
		$smooth_scroll_plugin_easing    = get_theme_mod( 'smooth_scroll_plugin_easing', true );

		$custom_js_init       = get_theme_mod( 'custom_js_init' );
		$custom_js_head_nodes = get_theme_mod( 'custom_js_head_nodes' );

		$cursor_follower_enabled = get_theme_mod( 'enable_cursor', false );
		$cursor_label_slider     = get_theme_mod( 'cursor_label_slider', esc_html__( 'Drag Me', 'cassio' ) );
		$cursor_attraction_delay = get_theme_mod( 'cursor_attraction_delay', 0.04 );

		$enable_cf_7_modals = get_theme_mod( 'enable_cf_7_modals', true );

		$master_audio_player_label_playing = get_theme_mod( 'master_audio_player_label_playing', esc_html__( 'Sound on', 'cassio' ) );
		$master_audio_player_icon_playing  = get_theme_mod( 'master_audio_player_icon_playing', 'pause' );
		$master_audio_player_label_paused  = get_theme_mod( 'master_audio_player_label_paused', esc_html__( 'Sound off', 'cassio' ) );
		$master_audio_player_icon_paused   = get_theme_mod( 'master_audio_player_icon_paused', 'play_arrow' );

		$enable_fix_mobile_vh        = get_theme_mod( 'enable_fix_mobile_vh', true );
		$enable_fix_mobile_vh_update = get_theme_mod( 'enable_fix_mobile_vh_update', true );

		$enable_menu_split_chars_animation = get_theme_mod( 'enable_menu_split_chars_animation', true );

		if ( isset( $_GET['smooth_scrolling'] ) ) {
			if ( $_GET['smooth_scrolling'] == 'yes' ) {
				$enable_smooth_scroll = true;
			} elseif ( $_GET['smooth_scrolling'] == 'no' ) {
				$enable_smooth_scroll = false;
			}
		}

		if ( $ajax_enabled && $ajax_prevent_woocommerce_pages && class_exists( 'woocommerce' ) ) {

			// add AJAX rules that prevents all "TO" WooCommerce pages
			$woocommerce_urls        = Utilities::get_woocommerce_urls();
			$woocommerce_urls_string = '';

			foreach ( $woocommerce_urls as $url ) {
				$woocommerce_urls_string .= 'a[href*="' . $url . '"],';
			}

			$ajax_prevent_rules .= $woocommerce_urls_string;

			// add AJAX rule that prevents all the links "FROM" WooCommerce pages to other website pages
			$ajax_prevent_rules .= '.woocommerce-page a';

		}

		wp_localize_script(
			'cassio-components',
			'theme',
			array(
				'themeURL'                => esc_js( ARTS_THEME_URL ),
				'ajax'                    => array(
					'enabled'                    => esc_js( $ajax_enabled ),
					'preventRules'               => $ajax_prevent_rules,
					'evalInlineContainerScripts' => esc_js( $ajax_eval_inline_container_scripts ),
					'loadMissingScripts'         => esc_js( $ajax_load_missing_scripts ),
					'loadMissingStyles'          => esc_js( $ajax_load_missing_styles ),
				),
				'animations'              => array(
					'triggerHook'                => esc_js( $smc_trigger_hook ),
					'timeScale'                  => array(
						'onScrollReveal'   => esc_js( $animation_on_scroll_reveal_timescale ),
						'overlayMenuOpen'  => esc_js( $animation_overlay_menu_open_timescale ),
						'overlayMenuClose' => esc_js( $animation_overlay_menu_close_timescale ),
						'preloader'        => esc_js( $animation_preloader_timescale ),
					),
					'flyingHeadingsStagger'      => esc_js( $animation_flying_headings_stagger ),
					'cursorAttractionDelay'      => esc_js( $cursor_attraction_delay ),
					'hasMenuSplitCharsAnimation' => esc_js( $enable_menu_split_chars_animation ),
				),
				'smoothScroll'            => array(
					'enabled'             => esc_js( $enable_smooth_scroll ),
					'damping'             => esc_js( $smooth_scroll_damping ),
					'renderByPixels'      => esc_js( $smooth_scroll_render_by_pixels ),
					'continuousScrolling' => $smooth_scroll_plugin_easing ? false : true,
					'plugins'             => array(
						'edgeEasing' => esc_js( $smooth_scroll_plugin_easing ),
					),
				),
				'cursorFollower'          => array(
					'enabled' => esc_js( $cursor_follower_enabled ),
					'labels'  => array(
						'slider' => esc_js( $cursor_label_slider ),
					),
				),
				'contactForm7'            => array(
					'customModals' => esc_js( $enable_cf_7_modals ),
				),
				'customJSInit'            => trim( $custom_js_init ),
				'updateHeadNodes'         => esc_js( $custom_js_head_nodes ),
				'updateScriptNodes'       => esc_js( $ajax_update_script_nodes ),
				'audio'                   => array(
					'playing' => array(
						'label' => esc_js( $master_audio_player_label_playing ),
						'icon'  => esc_js( $master_audio_player_icon_playing ),
					),
					'paused'  => array(
						'label' => esc_js( $master_audio_player_label_paused ),
						'icon'  => esc_js( $master_audio_player_icon_paused ),
					),
				),
				'mobileBarFix'            => array(
					'enabled' => esc_js( $enable_fix_mobile_vh ),
					'update'  => esc_js( $enable_fix_mobile_vh_update ),
				),
				'isElementorEditorActive' => esc_js( Utilities::is_elementor_editor_active() ),
				'assets'                  => array(
					'promises' => array(),
				),
				'threeJS'                 => ARTS_THEME_URL . '/js/three.min.js',
			)
		);
	}
}

/**
 * Exclude certain JS from the aggregation
 * function of Autoptimize plugin
 */
add_filter( 'autoptimize_filter_js_exclude', 'arts_ao_override_jsexclude', 30, 1 );
if ( ! function_exists( 'arts_ao_override_jsexclude' ) ) {
	/**
	 * JS optimization exclude strings, as configured in admin page.
	 *
	 * @param $exclude: comma-seperated list of exclude strings
	 * @return: comma-seperated list of exclude strings
	 */
	function arts_ao_override_jsexclude( $exclude ) {
		return $exclude . ', outdated-browser-rework';
	}
}

/**
 * Force disable HTML minification for Autoptimize plugin
 * if AJAX transitions are enabled to avoid incorrect
 * page rendering.
 */
add_filter( 'autoptimize_filter_html_noptimize', 'arts_ao_disable_html_minification_ajax', 10, 1 );
if ( ! function_exists( 'arts_ao_disable_html_minification_ajax' ) ) {
	function arts_ao_disable_html_minification_ajax( $value ) {
		$ajax_enabled = get_theme_mod( 'enable_ajax', false );

		if ( $ajax_enabled ) {
			$value = true;
		}

		return $value;
	}
}
