<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'arts_get_social_icon' ) ) {
	function arts_get_social_icon( $icon_class ) {
		$socials = apply_filters(
			'arts/widgets/cassio_widget_social/icons',
			array(
				'facebook'    => array(
					'title'      => esc_html__( 'Facebook URL', 'cassio' ),
					'icon'       => 'fa fa-facebook-f fa-fw',
					'aria-label' => esc_html__( 'Facebook', 'cassio' ),
				),
				'twitter'     => array(
					'title'      => esc_html__( 'Twitter URL', 'cassio' ),
					'icon'       => 'fa fa-twitter fa-fw',
					'aria-label' => esc_html__( 'Twitter', 'cassio' ),
				),
				'instagram'   => array(
					'title'      => esc_html__( 'Instagram URL', 'cassio' ),
					'icon'       => 'fa fa-instagram fa-fw',
					'aria-label' => esc_html__( 'Instagram', 'cassio' ),
				),
				'linkedin'    => array(
					'title'      => esc_html__( 'LinkedIn URL', 'cassio' ),
					'icon'       => 'fa fa-linkedin fa-fw',
					'aria-label' => esc_html__( 'LinkedIn', 'cassio' ),
				),
				'google_plus' => array(
					'title'      => esc_html__( 'Google Plus URL', 'cassio' ),
					'icon'       => 'fa fa-google-plus fa-fw',
					'aria-label' => esc_html__( 'Google Plus', 'cassio' ),
				),
				'vk'          => array(
					'title'      => esc_html__( 'VK URL', 'cassio' ),
					'icon'       => 'fa fa-vk fa-fw',
					'aria-label' => esc_html__( 'VK', 'cassio' ),
				),
				'youtube'     => array(
					'title'      => esc_html__( 'YouTube URL', 'cassio' ),
					'icon'       => 'fa fa-youtube fa-fw',
					'aria-label' => esc_html__( 'YouTube', 'cassio' ),
				),
				'vimeo'       => array(
					'title'      => esc_html__( 'Vimeo URL', 'cassio' ),
					'icon'       => 'fa fa-vimeo fa-fw',
					'aria-label' => esc_html__( 'Vimeo', 'cassio' ),
				),
				'dribbble'    => array(
					'title'      => esc_html__( 'Dribbble URL', 'cassio' ),
					'icon'       => 'fa fa-dribbble fa-fw',
					'aria-label' => esc_html__( 'Dribbble', 'cassio' ),
				),
				'pinterest'   => array(
					'title'      => esc_html__( 'Pinterest URL', 'cassio' ),
					'icon'       => 'fa fa-pinterest fa-fw',
					'aria-label' => esc_html__( 'Pinterest', 'cassio' ),
				),
				'behance'     => array(
					'title'      => esc_html__( 'Behance URL', 'cassio' ),
					'icon'       => 'fa fa-behance fa-fw',
					'aria-label' => esc_html__( 'Behance', 'cassio' ),
				),
				'flickr'      => array(
					'title'      => esc_html__( 'Flickr URL', 'cassio' ),
					'icon'       => 'fa fa-flickr fa-fw',
					'aria-label' => esc_html__( 'Flickr', 'cassio' ),
				),
				'tumblr'      => array(
					'title'      => esc_html__( 'Tumblr URL', 'cassio' ),
					'icon'       => 'fa fa-tumblr fa-fw',
					'aria-label' => esc_html__( 'Tumblr', 'cassio' ),
				),
				'vine'        => array(
					'title'      => esc_html__( 'Vine URL', 'cassio' ),
					'icon'       => 'fa fa-vine fa-fw',
					'aria-label' => esc_html__( 'Vine', 'cassio' ),
				),
				'github'      => array(
					'title'      => esc_html__( 'Github URL', 'cassio' ),
					'icon'       => 'fa fa-github fa-fw',
					'aria-label' => esc_html__( 'Github', 'cassio' ),
				),
				'soundcloud'  => array(
					'title'      => esc_html__( 'SoundCloud URL', 'cassio' ),
					'icon'       => 'fa fa-soundcloud fa-fw',
					'aria-label' => esc_html__( 'SoundCloud', 'cassio' ),
				),
				'telegram'    => array(
					'title'      => esc_html__( 'Telegram URL', 'cassio' ),
					'icon'       => 'fa fa-telegram fa-fw',
					'aria-label' => esc_html__( 'Telegram', 'cassio' ),
				),
				'medium'      => array(
					'title'      => esc_html__( 'Medium URL', 'cassio' ),
					'icon'       => 'fa fa-medium fa-fw',
					'aria-label' => esc_html__( 'Medium', 'cassio' ),
				),
				'skype'       => array(
					'title'      => esc_html__( 'Skype URL', 'cassio' ),
					'icon'       => 'fa fa-skype fa-fw',
					'aria-label' => esc_html__( 'Skype', 'cassio' ),
				),
				'whatsapp'    => array(
					'title'      => esc_html__( 'WhatsApp URL', 'cassio' ),
					'icon'       => 'fa fa-whatsapp fa-fw',
					'aria-label' => esc_html__( 'WhatsApp', 'cassio' ),
				),
				'slack'       => array(
					'title'      => esc_html__( 'Slack URL', 'cassio' ),
					'icon'       => 'fa fa-slack fa-fw',
					'aria-label' => esc_html__( 'Slack', 'cassio' ),
				),
				'tiktok'      => array(
					'title'      => esc_html__( 'TikTok URL', 'cassio' ),
					'icon'       => 'fa fa-tiktok fa-fw',
					'aria-label' => esc_html__( 'TikTok', 'cassio' ),
				),
			)
		);

		$result = array(
			'aria-label' => '',
			'class'      => '',
		);

		foreach ( $socials as $social ) {
			if ( $social['icon'] === $icon_class ) {
				$result = array(
					'aria-label' => $social['aria-label'],
					'class'      => $social['icon'],
				);

				break;
			}
		}

		return $result;
	}
}
