<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'arts_render_footer_widgets' ) ) {
	function arts_render_footer_widgets( $suffix = 'upper', $default_columns = 4 ) {
		$footer_columns = get_theme_mod( 'footer_columns_' . $suffix, $default_columns );
		$class_col      = '';

		switch ( $footer_columns ) {
			case 1: {
				$class_col = 'col text-center';
				break;
			}
			case 2: {
				$class_col = 'col-lg-6';
				break;
			}
			case 3: {
				$class_col = 'col-lg-4';
				break;
			}
			default: {
				$class_col = 'col-lg-3';
				break;
			}
		}

		for ( $i = 1; $i <= $footer_columns; $i++ ) {
			if ( is_active_sidebar( 'footer-sidebar-' . $suffix . $i ) ) {

				$class_col_order = ' order-lg-' . $i;

				if ( $footer_columns == 2 && $i == 1 ) {
					$class_col = 'col-lg-6 text-left';
				}
				if ( $footer_columns == 2 && $i == 2 ) {
					$class_col = 'col-lg-6 text-right';
				}
				if ( $footer_columns == 3 && $i == 1 ) {
					$class_col = 'col-lg-4 text-left';
				}
				if ( $footer_columns == 3 && $i == 2 ) {
					$class_col = 'col-lg-4 text-center';
				}
				if ( $footer_columns == 3 && $i == 3 ) {
					$class_col = 'col-lg-4 text-right';
				}
				if ( get_theme_mod( 'order_column_' . $i . '_' . $suffix ) > 1 ) {
					$order           = get_theme_mod( 'order_column_' . $i . '_' . $suffix );
					$class_col_order = ' order-lg-' . $i . ' order-' . $order;
				}

				?>
					<div class="<?php echo esc_attr( $class_col . $class_col_order ); ?> footer__column">
						<?php dynamic_sidebar( 'footer-sidebar-' . $suffix . $i ); ?>
					</div>
				<?php

			}
		}
	}
}