<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

add_filter( 'arts/utilities/get_page_titles/strings', 'filter_arts_utilities_get_page_titles_strings' );
if ( ! function_exists( 'filter_arts_utilities_get_page_titles_strings' ) ) {
	/**
	 * Filters the page titles strings for localization.
	 *
	 * @param array $strings
	 * @return array $strings
	 */
	function filter_arts_utilities_get_page_titles_strings( $strings ) {
		$strings['category'] = esc_html__( 'Posts in category', 'cassio' );
		$strings['author']   = esc_html__( 'Posts by author', 'cassio' );
		$strings['tag']      = esc_html__( 'Posts with tag', 'cassio' );
		$strings['day']      = esc_html__( 'Day archive', 'cassio' );
		$strings['month']    = esc_html__( 'Month archive', 'cassio' );
		$strings['year']     = esc_html__( 'Year archive', 'cassio' );
		$strings['search']   = esc_html__( 'Search', 'cassio' );
		$strings['blog']     = esc_html__( 'Blog', 'cassio' );

		return $strings;
	}
}

if ( ! function_exists( 'arts_set_page_title' ) ) {
	/**
	 * Retrieves the page titles, subtitles, and descriptions based on the current context.
	 *
	 * @param bool $bc_compatibility_enabled Optional. Whether to enable backward compatibility with the previous version. Default true.
	 * @return array {
	 *   Array containing the page title, subtitle, and description.
	 *
	 *   @type string $title       The page title.
	 *   @type string $subtitle    The page subtitle.
	 *   @type string $description The page description.
	 * }
	 * @deprecated 3.6.0 Use `\Arts\Utilities\Utilities::get_page_titles()` method instead.
	 */
	function arts_set_page_title( $bc_compatibility_enabled = true ) {
		$titles = Utilities::get_page_titles();

		if ( $bc_compatibility_enabled ) {
			$titles = array( $titles['title'], $titles['subtitle'], $titles['description'] );
		}

		return $titles;
	}
}
