<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

$arts_is_elementor_page    = Utilities::is_built_with_elementor();
$arts_enable_portfolio_nav = get_theme_mod( 'enable_portfolio_nav', true );
$arts_post_type            = get_post_type();

get_header();
get_template_part( 'template-parts/masthead/masthead' );

the_post();

?>

<?php if ( ! $arts_is_elementor_page ) : ?>
	<div class="container-fluid container_xs-no-padding">
		<section class="section section_mt-small section_mb-small section_pt-small section_pb-small bg-white">
			<div class="container">
				<div class="row justify-content-center">
					<div class="col">
						<div class="post">
							<div class="post__content clearfix">
								<?php the_content(); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
<?php else : ?>
	<?php the_content(); ?>
<?php endif; ?>


<?php

if ( $arts_post_type == 'arts_portfolio_item' && $arts_is_elementor_page && $arts_enable_portfolio_nav ) {

	get_template_part( 'template-parts/nav/nav', 'portfolio' );

}

get_footer();
