<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$arts_sidebar_position = get_theme_mod( 'sidebar_position', 'right_side' );
$arts_enable_gutters   = get_theme_mod( 'enable_static_page_gutters', true );

$arts_posts_col_class   = 'col-lg-8 order-lg-1';
$arts_sidebar_col_class = 'col-lg-3 order-lg-2';

if ( $arts_sidebar_position == 'left_side' ) {
	$arts_posts_col_class   = 'col-lg-8 order-lg-2';
	$arts_sidebar_col_class = 'col-lg-3 order-lg-1';
}

if ( is_active_sidebar( 'blog-sidebar' ) ) {
	$arts_blog_row_class = 'row justify-content-between';
} else {
	$arts_blog_row_class = 'row justify-content-center';
}

?>

<?php if ( $arts_enable_gutters ) : ?>
	<div class="container-fluid container_xs-no-padding">
<?php endif; ?>
	<section class="section section_mt-small section_pt-small section_pb-small bg-white">
		<div class="container">
			<div class="<?php echo esc_attr( $arts_blog_row_class ); ?>">
				<div class="<?php echo esc_attr( $arts_posts_col_class ); ?>">
					<?php if ( have_posts() ) : ?>
						<div class="section-blog__posts">
							<?php get_template_part( 'template-parts/loop/loop', 'blog' ); ?>
						</div>
						<!-- - posts -->
					<?php else : ?>
						<?php get_template_part( 'template-parts/content/content', 'none' ); ?>
					<?php endif; ?>
					<?php if ( get_the_posts_pagination() ) : ?>
						<div class="section-blog__wrapper-pagination">
							<?php arts_posts_pagination(); ?>
						</div>
						<!-- - pagination -->
					<?php endif; ?>
				</div>
				<?php if ( is_active_sidebar( 'blog-sidebar' ) ) : ?>
					<div class="<?php echo esc_attr( $arts_sidebar_col_class ); ?>">
						<div class="section-blog__sidebar">
							<?php get_sidebar(); ?>
						</div>
					</div>
					<!-- - sidebar -->
				<?php endif; ?>
			</div>
		</div>
	</section>
<?php if ( $arts_enable_gutters ) : ?>
	</div>
<?php endif; ?>
