<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

$arts_has_menu                     = has_nav_menu( 'main_menu' );
$arts_menu_style                   = get_theme_mod( 'menu_style', 'classic' );
$arts_page_header_settings         = Utilities::get_document_option( 'page_header_settings' );
$arts_class_burger_col             = '';
$arts_enable_ajax                  = get_theme_mod( 'enable_ajax', false );
$arts_is_elementor_canvas_template = Utilities::get_document_option( 'template' ) === 'elementor_canvas';

/**
 * Use Individual Page Header Settings from Elementor
 * Or Use Global Settings from Customizer
 */
if ( $arts_page_header_settings ) {
	$arts_class_header               = Utilities::get_document_option( 'page_header_main_theme' );
	$arts_class_sticky_header        = Utilities::get_document_option( 'page_header_sticky_theme' );
	$arts_class_overlay_menu_wrapper = Utilities::get_document_option( 'page_header_overlay_menu_theme' );
	$arts_attrs_header_logo          = Utilities::get_document_option( 'page_header_main_logo' );
	$arts_attrs_header_sticky_logo   = Utilities::get_document_option( 'page_header_sticky_logo' );
} else {
	$arts_class_header               = get_theme_mod( 'header_main_theme', 'header_color-black' );
	$arts_class_sticky_header        = get_theme_mod( 'header_sticky_theme', 'bg-dark-2' );
	$arts_class_overlay_menu_wrapper = get_theme_mod( 'header_overlay_menu_theme', 'bg-dark' );
	$arts_attrs_header_logo          = get_theme_mod( 'header_main_logo', 'header_logo-primary' );
	$arts_attrs_header_sticky_logo   = get_theme_mod( 'header_sticky_logo', 'header_logo-secondary' );
}

$arts_class_curtain          = '';
$arts_header_type            = get_theme_mod( 'header_type', 'sticky' );
$arts_header_container_class = get_theme_mod( 'header_container', 'container-fluid' );
$arts_menu_style             = get_theme_mod( 'menu_style', 'classic' );

$arts_social_links = get_theme_mod( 'social_links', null );

$arts_enable_morphing_letters      = get_theme_mod( 'enable_morphing_letters', true );
$arts_morphing_letters_set         = get_theme_mod( 'morphing_letters_set', array( 'latin' ) );
$arts_menu_overlay_circle_contents = get_theme_mod( 'menu_overlay_circle_contents', 'letters' );

$arts_menu_overlay_background     = get_theme_mod( 'menu_overlay_background', 'ornament' );
$arts_menu_overlay_background_url = get_theme_mod( 'menu_overlay_background_url' );
$arts_menu_overlay_background_id  = '';
$arts_menu_overlay_info           = get_theme_mod( 'menu_overlay_info' );
$arts_menu_overlay_info_length    = 0;
$arts_menu_overlay_info_class_col;
$arts_menu_overlay_info_classes_alignment = array();
$arts_enable_master_audio_background      = get_theme_mod( 'enable_master_audio_background', false );
$arts_master_audio_player_position        = get_theme_mod( 'master_audio_player_position', 'header' );

$arts_header_has_lang_switcher = is_active_sidebar( 'lang-switcher-sidebar' ) && ( class_exists( 'SitePress' ) || class_exists( 'Polylang' ) || class_exists( 'TRP_Translate_Press' ) );
$arts_class_col_right          = $arts_header_has_lang_switcher ? '' : 'd-none d-lg-block';

if ( ( $arts_menu_overlay_background === 'custom' && ! empty( $arts_menu_overlay_background_url ) ) ) {
	$arts_menu_overlay_background_id = attachment_url_to_postid( $arts_menu_overlay_background_url );
}

if ( is_array( $arts_menu_overlay_info ) ) {
	$arts_menu_overlay_info_length = count( $arts_menu_overlay_info );
}

if ( $arts_header_type === 'sticky' ) {
	$arts_class_header .= ' header_fixed';
	$arts_class_header .= ' js-sticky-header';
}

if ( $arts_header_type === 'absolute' ) {
	$arts_class_header .= ' header_absolute';
}

if ( $arts_menu_style === 'classic' ) {
	$arts_class_burger_col = 'd-lg-none';
}

if ( $arts_menu_style === 'fullscreen' && ! $arts_enable_morphing_letters ) {
	$arts_class_overlay_menu_wrapper .= ' text-center justify-content-center';
}

if ( $arts_menu_overlay_background === 'ornament' ) {
	$arts_class_curtain .= ' bg-ornament';
}

switch ( $arts_menu_overlay_info_length ) {
	case 3:
		$arts_menu_overlay_info_class_col         = 'col-lg-4';
		$arts_menu_overlay_info_classes_alignment = array( 'text-left', 'text-center', 'text-right' );
		break;
	case 2:
		$arts_menu_overlay_info_class_col         = 'col-lg-6';
		$arts_menu_overlay_info_classes_alignment = array( 'text-left', 'text-right', '' );
		break;
	default:
		$arts_menu_overlay_info_class_col = 'col';
		if ( $arts_enable_morphing_letters ) {
			$arts_menu_overlay_info_classes_alignment = array( 'text-left', '', '' );
		} else {
			$arts_menu_overlay_info_classes_alignment = array( 'text-center', '', '' );
		}
		break;
}

if ( $arts_is_elementor_canvas_template ) {
	if ( $arts_enable_ajax ) {
		$arts_class_header .= ' hidden';
	} else {
		return;
	}
}

?>

<header id="page-header" class="header <?php echo esc_attr( $arts_class_header ); ?>" data-header-animation="" data-header-sticky-theme="<?php echo esc_attr( $arts_class_sticky_header ); ?>" data-header-sticky-logo="<?php echo esc_attr( $arts_attrs_header_sticky_logo ); ?>" data-header-logo="<?php echo esc_attr( $arts_attrs_header_logo ); ?>">
  <div class="<?php echo esc_attr( $arts_header_container_class ); ?> header__controls header__container">
	<div class="row justify-content-between align-items-center">
	  <div class="col text-left header__col-left">
		<?php get_template_part( 'template-parts/logo/logo' ); ?>
	  </div>
		<?php if ( $arts_has_menu && $arts_menu_style === 'classic' ) : ?>
		<div class="col-auto text-center d-none d-lg-block">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'main_menu',
					'container'      => false,
				)
			);
			?>
		</div>
		<?php endif; ?>
		<?php if ( $arts_has_menu ) : ?>
		<div class="col-auto text-center <?php echo esc_attr( $arts_class_burger_col ); ?>">
		  <div class="header__burger" id="js-burger">
			<div class="header__burger-line"></div>
			<div class="header__burger-line"></div>
		  </div>
		</div>
		<?php endif; ?>
		<?php if ( $arts_social_links || $arts_header_has_lang_switcher || $arts_enable_master_audio_background ) : ?>
		<div class="col text-right header__col-right <?php echo esc_attr( $arts_class_col_right ); ?>">
		  <div class="row justify-content-end align-items-center">
			<?php if ( $arts_enable_master_audio_background && $arts_master_audio_player_position == 'header' ) : ?>
			  <!-- Audio Control -->
			  <div class="col-auto d-none d-lg-block">
				<?php get_template_part( 'template-parts/audio/control' ); ?>
			  </div>
			  <!-- - Audio Control -->
			<?php endif; ?>
			<?php if ( $arts_social_links ) : ?>
			  <div class="col-auto d-none d-lg-block">
				<ul class="social">
				  <?php foreach ( $arts_social_links as $item ) : ?>
						<li class="social__item">
							<?php if ( function_exists( 'arts_get_social_icon' ) ) : ?>
								<?php
									$icon       = arts_get_social_icon( $item['social_icon'] );
									$aria_label = array_key_exists( 'aria-label', $icon ) ? $icon['aria-label'] : '';
								?>
								<a class="social__icon <?php echo esc_attr( $item['social_icon'] ); ?>" href="<?php echo esc_url( $item['social_url'] ); ?>" aria-label="<?php echo esc_attr( $aria_label ); ?>" target="_blank"></a>
							<?php else : ?>
								<a class="social__icon <?php echo esc_attr( $item['social_icon'] ); ?>" href="<?php echo esc_url( $item['social_url'] ); ?>" target="_blank"></a>
							<?php endif; ?>
						</li>
					<?php endforeach; ?>
				</ul>
			  </div>
			<?php endif; ?>
			<?php if ( $arts_header_has_lang_switcher ) : ?>
			  <div class="col-auto">
				<div class="lang-switcher">
				  <?php dynamic_sidebar( 'lang-switcher-sidebar' ); ?>
				</div>
			  </div>
			<?php endif; ?>
		  </div>
		</div>
		<?php endif; ?>
	</div>
	<?php if ( $arts_has_menu ) : ?>
	  <div class="header__overlay-menu-back material-icons" id="js-submenu-back">arrow_back</div>
	  <!-- - back button -->
	<?php endif; ?>
  </div>
  <div class="header__wrapper-overlay-menu container-fluid <?php echo esc_attr( $arts_class_overlay_menu_wrapper ); ?>">
	<!-- menu overlay -->
	<div class="header__wrapper-menu">
		<?php
		$enable_menu_split_chars_animation = get_theme_mod( 'enable_menu_split_chars_animation', true );
		$split_type                        = $enable_menu_split_chars_animation ? 'lines, words, chars' : 'lines, words';

		wp_nav_menu(
			array(
				'theme_location' => 'main_menu',
				'container'      => false,
				'menu_class'     => 'menu-overlay js-menu-overlay',
				'link_before'    => '<div class="menu-overlay__item-wrapper js-text-to-fly split-text js-split-text" data-split-text-type="' . $split_type . '">',
				'link_after'     => '</div>',
				'walker'         => new Arts_Walker_Nav_Menu_Overlay(),
			)
		);
		?>
	</div>
	<!-- - menu overlay -->
	<?php if ( $arts_menu_overlay_info || $arts_social_links ) : ?>
	  <!-- information -->
	  <div class="header__wrapper-overlay-widgets">
		<div class="container-fluid">
		  <div class="row justify-content-between">
			<?php if ( $arts_enable_master_audio_background && $arts_master_audio_player_position == 'header' ) : ?>
			  <!-- Audio Control -->
			  <div class="col d-lg-none">
				<div class="audio-control-wrapper">
				  <?php get_template_part( 'template-parts/audio/control' ); ?>
				</div>
			  </div>
			  <!-- - Audio Control -->
			<?php endif; ?>
			<?php if ( $arts_social_links ) : ?>
			  <div class="col-lg-4 text-center d-lg-none">
				<ul class="social">
				  <?php foreach ( $arts_social_links as $item ) : ?>
					<li class="social__item">
					  <a class="social__icon <?php echo esc_attr( $item['social_icon'] ); ?>" href="<?php echo esc_url( $item['social_url'] ); ?>" target="_blank"></a>
					</li>
					<?php endforeach; ?>
				</ul>
			  </div>
			<?php endif; ?>
			<?php if ( $arts_menu_overlay_info ) : ?>
				<?php foreach ( $arts_menu_overlay_info as $index => $item ) : ?>
				<div class="header__widget <?php echo esc_attr( $arts_menu_overlay_info_class_col ); ?> <?php echo esc_attr( $arts_menu_overlay_info_classes_alignment[ $index ] ); ?>">
				  <div class="split-text js-split-text" data-split-text-type="lines" data-split-text-set="lines">
					<?php echo wp_kses( $item['column'], wp_kses_allowed_html( 'post' ) ); ?>
				  </div>
				</div>
				<?php endforeach; ?>
			<?php endif; ?>
		  </div>
		</div>
	  </div>
	  <!-- - information -->
	<?php endif; ?>
	<?php if ( $arts_menu_style === 'fullscreen' && $arts_enable_morphing_letters && ! empty( $arts_morphing_letters_set ) ) : ?>
	  <!-- letters -->
	  <div class="header__circle-letters">
			<?php if ( $arts_menu_overlay_circle_contents === 'letters' ) : ?>
				<svg class="vector-letters" width="158px" height="158px" viewBox="0 0 158 158" version="1.1" xmlns="http://www.w3.org/2000/svg"	xmlns:xlink="http://www.w3.org/1999/xlink">
					<?php foreach ( $arts_morphing_letters_set as $set ) : ?>
						<?php get_template_part( 'template-parts/svg/path/letters', esc_attr( $set ) ); ?>
					<?php endforeach; ?>
				</svg>
			<?php endif; ?>
			<?php if ( $arts_menu_overlay_circle_contents === 'logo' ) : ?>
				<?php get_template_part( 'template-parts/logo/logo' ); ?>
			<?php endif; ?>
			<?php get_template_part( 'template-parts/svg/circle' ); ?>
	  </div>
	  <!-- - letters -->
	<?php endif; ?>
	<!-- background -->
	<?php if ( $arts_menu_overlay_background === 'custom' && ! empty( $arts_menu_overlay_background_id ) ) : ?>
		<?php
		arts_the_lazy_image(
			array(
				'id'    => $arts_menu_overlay_background_id,
				'class' => array(
					'image' => array( 'header__curtain', $arts_class_curtain ),
				),
			)
		);
		?>
	<?php else : ?>
	  <div class="header__curtain <?php echo esc_attr( $arts_class_curtain ); ?>"></div>
	<?php endif; ?>
	<!-- - background -->
  </div>
</header>
