<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$arts_title                 = get_bloginfo( 'name' );
$arts_tagline               = get_bloginfo( 'description' );
$arts_display_title_tagline = get_theme_mod( 'header_text', true );
$arts_logo_class            = 'logo ';
$arts_logo_wrapper_class    = 'logo__wrapper-img ';
$arts_has_custom_logo       = has_custom_logo();

if ( ! $arts_display_title_tagline ) {
	$arts_logo_wrapper_class .= 'logo__wrapper-img_no-margin ';
}

?>

<a class="<?php echo esc_attr( $arts_logo_class ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
	<?php if ( $arts_has_custom_logo ) : ?>
		<?php
			$arts_logo               = get_theme_mod( 'custom_logo' );
			$arts_logo_url           = wp_get_attachment_url( $arts_logo );
			$arts_logo_secondary_url = get_theme_mod( 'custom_logo_secondary' );
		?>
		<div class="<?php echo esc_attr( $arts_logo_wrapper_class ); ?>">
			<img class="logo__img-primary" src="<?php echo esc_attr( $arts_logo_url ); ?>" alt="<?php echo esc_attr( $arts_title ); ?>">
			<?php if ( $arts_logo_secondary_url ) : ?>
				<img class="logo__img-secondary" src="<?php echo esc_attr( $arts_logo_secondary_url ); ?>" alt="<?php echo esc_attr( $arts_title ); ?>">
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php if ( ! empty( $arts_title ) && $arts_display_title_tagline ) : ?>
		<div class="logo__text">
			<span class="logo__text-title"><?php echo esc_html( $arts_title ); ?></span>
			<?php if ( ! empty( $arts_tagline ) ) : ?>
				<span class="logo__text-tagline"><?php echo esc_html( $arts_tagline ); ?></span>
			<?php endif; ?>
		</div>
	<?php endif; ?>
</a>
